/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.Strings;
import org.burningwave.Throwables;
import org.burningwave.json.Check;
import org.burningwave.json.IndexedObjectCheck;
import org.burningwave.json.LeafCheck;
import org.burningwave.json.ObjectCheck;
import org.burningwave.json.ObjectHandler;
import org.burningwave.json.Path;
import org.burningwave.json.SLF4J;
import org.burningwave.json.SchemaHolder;
import org.burningwave.json.Validation;
import org.json.JSONException;
import org.slf4j.Logger;

public class Validator {
    public static final Function<Path.Validation.Context<?, ?>, Function<String, Function<Object[], Throwable>>> DEFAULT_EXCEPTION_BUILDER;
    private static final String DEFAULT_LEAF_CHECKS_ID;
    private static final String DEFAULT_OBJECT_CHECKS_ID;
    private static final String DEFAULT_INDEXED_OBJECT_CHECKS_ID;
    protected static final Object logger;
    protected final ObjectMapper objectMapper;
    protected final SchemaHolder schemaHolder;
    protected Function<Path.Validation.Context<?, ?>, Function<String, Function<Object[], Throwable>>> exceptionBuilder;
    protected final Map<String, Collection<ObjectCheck>> objectChecks;
    protected final Map<String, Collection<IndexedObjectCheck<?>>> indexedObjectChecks;
    protected final Map<String, Collection<LeafCheck<?, ?>>> leafChecks;
    protected final Collection<LeafCheck<?, ?>> defaultLeafChecks;
    protected final Collection<ObjectCheck> defaultObjectChecks;
    protected final Collection<IndexedObjectCheck<?>> defaultIndexedObjectChecks;

    public Validator(ObjectMapper objectMapper) {
        this(objectMapper, new SchemaHolder(objectMapper), DEFAULT_EXCEPTION_BUILDER);
    }

    public Validator(SchemaHolder schemaHolder) {
        this(schemaHolder.objectMapper, schemaHolder, DEFAULT_EXCEPTION_BUILDER);
    }

    public Validator(SchemaHolder schemaHolder, Function<Path.Validation.Context<?, ?>, Function<String, Function<Object[], Throwable>>> exceptionBuilder) {
        this(schemaHolder.objectMapper, schemaHolder, exceptionBuilder);
    }

    public Validator(ObjectMapper objectMapper, SchemaHolder schemaHolder, Function<Path.Validation.Context<?, ?>, Function<String, Function<Object[], Throwable>>> exceptionBuilder) {
        this.objectMapper = objectMapper;
        this.schemaHolder = schemaHolder;
        this.exceptionBuilder = exceptionBuilder;
        this.leafChecks = new LinkedHashMap();
        this.defaultLeafChecks = new ArrayList();
        this.leafChecks.put(DEFAULT_LEAF_CHECKS_ID, this.defaultLeafChecks);
        this.objectChecks = new LinkedHashMap<String, Collection<ObjectCheck>>();
        this.defaultObjectChecks = new ArrayList<ObjectCheck>();
        this.objectChecks.put(DEFAULT_OBJECT_CHECKS_ID, this.defaultObjectChecks);
        this.indexedObjectChecks = new LinkedHashMap();
        this.defaultIndexedObjectChecks = new ArrayList();
        this.indexedObjectChecks.put(DEFAULT_INDEXED_OBJECT_CHECKS_ID, this.defaultIndexedObjectChecks);
    }

    public void setExceptionBuilder(Function<Path.Validation.Context<?, ?>, Function<String, Function<Object[], Throwable>>> exceptionBuilder) {
        this.exceptionBuilder = exceptionBuilder;
    }

    public synchronized void registerCheck(Check<?, ?, ?> ... items) {
        this.registerCheck((String)null, items);
    }

    public synchronized void registerCheck(String checkGroupId, Check<?, ?, ?> ... items) {
        for (Check<?, ?, ?> item : items) {
            Map<String, Collection<Check.Abst>> checkMap = null;
            String defaultCheckListName = null;
            if (item instanceof ObjectCheck) {
                checkMap = this.objectChecks;
                defaultCheckListName = DEFAULT_OBJECT_CHECKS_ID;
            } else if (item instanceof IndexedObjectCheck) {
                checkMap = this.indexedObjectChecks;
                defaultCheckListName = DEFAULT_INDEXED_OBJECT_CHECKS_ID;
            } else if (item instanceof LeafCheck) {
                checkMap = this.leafChecks;
                defaultCheckListName = DEFAULT_LEAF_CHECKS_ID;
            }
            if (item instanceof Check.Group) {
                for (Check<?, ?, ?> nestedItem : ((Check.Group)item).items) {
                    this.registerCheck(checkGroupId, nestedItem);
                }
                continue;
            }
            if (checkMap != null) {
                String classNameForRegistration = checkGroupId != null ? checkGroupId : defaultCheckListName;
                Collection checkList = checkMap.computeIfAbsent(classNameForRegistration, clsName -> new ArrayList());
                checkList.add(item);
                continue;
            }
            throw new IllegalArgumentException(item + " is not a valid check type");
        }
    }

    public <I> Collection<Throwable> validate(Object jsonObject) {
        return this.validate(Validation.Config.forJsonObject(null));
    }

    public <I> Collection<Throwable> validate(Validation.Config<I> config) {
        try {
            ObjectHandler objectHandler;
            Object jsonObject = config.jsonObjectOrSupplier;
            if (jsonObject instanceof Supplier) {
                jsonObject = ((Supplier)config.jsonObjectOrSupplier).get();
            }
            if (jsonObject instanceof ObjectHandler) {
                objectHandler = (ObjectHandler)jsonObject;
                jsonObject = objectHandler.getRawValue();
            } else {
                objectHandler = ObjectHandler.create(this.objectMapper, jsonObject);
            }
            Validation.Context validationContext = this.createValidationContext(config, objectHandler);
            if (ObjectHandler.isConvertible(objectHandler.getValue())) {
                this.validate("", this.schemaHolder.getJsonSchema(objectHandler.getValue()), objectHandler.getRawValue(), validationContext);
            } else {
                this.validateRaw(validationContext);
            }
            return validationContext.exceptions;
        }
        catch (JSONException exc) {
            return (Collection)Throwables.INSTANCE.throwException((Throwable)exc);
        }
    }

    protected void validateRaw(Validation.Context validationContext) {
        this.validateRaw(validationContext, validationContext.objectChecks, check -> (ObjectSchema)this.buildSchemaMock(check.schemaClass, null));
        this.validateRaw(validationContext, validationContext.indexedObjectChecks, check -> this.buildSchemaMock(((IndexedObjectCheck)check).schemaClass, ((IndexedObjectCheck)check).itemsSchemaClass));
        this.validateRaw(validationContext, validationContext.leafChecks, check -> this.buildSchemaMock(((LeafCheck)check).schemaClass, null));
    }

    protected <S extends JsonSchema, T, C extends Check.Abst<S, T, C>> void validateRaw(Validation.Context validationContext, Collection<C> checkList, Function<C, S> schemaMockBuilder) {
        for (Check.Abst check : checkList) {
            if (check.predicate instanceof Path.Predicate) {
                this.processPathCheck(validationContext, schemaMockBuilder, check);
                continue;
            }
            this.processCheck(validationContext, schemaMockBuilder, check);
        }
    }

    protected <S extends JsonSchema, T, C extends Check.Abst<S, T, C>> void processPathCheck(Validation.Context validationContext, Function<C, S> schemaMockBuilder, C check) {
        Path.Predicate pathPredicate = (Path.Predicate)check.predicate;
        ArrayList objectHandlers = new ArrayList();
        Collection<Map.Entry<String, String>> pathForRegExColl = pathPredicate.pathForRegEx;
        for (Map.Entry<String, String> pathForRegEx : pathForRegExColl) {
            objectHandlers.addAll(validationContext.inputHandler.newFinder().findForPathMatches(pathForRegEx.getValue()));
        }
        if (!objectHandlers.isEmpty()) {
            for (ObjectHandler objectHandler : objectHandlers) {
                Path.Validation.Context pathValidationContext = new Path.Validation.Context(validationContext, objectHandler.path, (JsonSchema)schemaMockBuilder.apply(check), objectHandler.rawValue);
                if (!pathPredicate.test(pathValidationContext)) continue;
                check.action.accept(pathValidationContext);
            }
        } else {
            for (Map.Entry<String, String> pathForRegEx : pathForRegExColl) {
                Path.Validation.Context pathValidationContext = new Path.Validation.Context(validationContext, pathForRegEx.getKey(), (JsonSchema)schemaMockBuilder.apply(check), null);
                check.action.accept(pathValidationContext);
            }
        }
    }

    protected <S extends JsonSchema, T, C extends Check.Abst<S, T, C>> void processCheck(Validation.Context validationContext, Function<C, S> schemaMockBuilder, C check) {
        List objectHandlers = validationContext.inputHandler.newFinder().findForPathMatches(".*?");
        JsonSchema schemaMock = (JsonSchema)schemaMockBuilder.apply(check);
        for (ObjectHandler objectHandler : objectHandlers) {
            Path.Validation.Context pathValidationContext;
            if (!validationContext.checkValue(schemaMock, objectHandler.rawValue) || !check.predicate.test(pathValidationContext = new Path.Validation.Context(validationContext, objectHandler.path, schemaMock, objectHandler.rawValue))) continue;
            check.action.accept(pathValidationContext);
        }
    }

    protected <S extends JsonSchema> S buildSchemaMock(Class<S> schemaClass, Class<? extends JsonSchema> nestedTypeSchema) {
        ObjectSchema schema = null;
        if (schemaClass != null) {
            if (schemaClass.equals(ObjectSchema.class)) {
                schema = new ObjectSchema();
            } else if (schemaClass.equals(StringSchema.class)) {
                schema = new StringSchema();
            } else if (schemaClass.equals(IntegerSchema.class)) {
                schema = new IntegerSchema();
            } else if (schemaClass.equals(NumberSchema.class)) {
                schema = new NumberSchema();
            } else if (schemaClass.equals(BooleanSchema.class)) {
                schema = new BooleanSchema();
            } else if (schemaClass.equals(ArraySchema.class)) {
                ArraySchema arraySchema = new ArraySchema();
                final ArraySchema.SingleItems singleItems = new ArraySchema.SingleItems(this.buildSchemaMock(nestedTypeSchema, null));
                arraySchema.setItems(new ArraySchema.Items(){

                    public ArraySchema.SingleItems asSingleItems() {
                        return singleItems;
                    }
                });
                schema = arraySchema;
            }
            if (schema != null) {
                schema.setDescription(Validation.Context.MOCK_SCHEMA_LABEL);
            }
        }
        return (S)schema;
    }

    protected <I> void validate(String path, JsonSchema jsonSchema, Object jsonObject, Validation.Context validationContext) {
        if (jsonSchema instanceof ObjectSchema) {
            this.validate(path, (ObjectSchema)jsonSchema, (Map)jsonObject, validationContext);
        } else if (jsonSchema instanceof ArraySchema) {
            this.validate(path, (ArraySchema)jsonSchema, (Collection)jsonObject, validationContext);
        } else {
            this.validateValue(path, jsonSchema, jsonObject, validationContext);
        }
    }

    protected void validate(String path, ObjectSchema jsonSchema, Map<String, Object> jSonObject, Validation.Context validationContext) {
        Path.Validation.Context pathValidationContext = new Path.Validation.Context(validationContext, path, jsonSchema, jSonObject);
        if (validationContext.validationConfig.pathFilter.test(pathValidationContext)) {
            this.tryToExecuteChecks(validationContext.objectChecks, pathValidationContext);
            for (Map.Entry descriptor : jsonSchema.getProperties().entrySet()) {
                JsonSchema iteratedItemSchema = (JsonSchema)descriptor.getValue();
                String iteratedPath = (!path.isEmpty() ? path + "." : path) + (String)descriptor.getKey();
                this.validate(iteratedPath, iteratedItemSchema, this.getObject(() -> jSonObject::get, (String)descriptor.getKey()), validationContext);
            }
        } else {
            this.logSkippingValidation(pathValidationContext);
        }
    }

    protected <I> I getObject(Supplier<Function<String, I>> fieldRetriever, String fieldName) {
        try {
            return fieldRetriever.get().apply(fieldName);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected <I, S extends JsonSchema, T, C extends Check.Abst<S, T, C>> void validate(String path, ArraySchema jsonSchema, Collection<I> jSonObject, Validation.Context validationContext) {
        Path.Validation.Context pathValidationContext = new Path.Validation.Context(validationContext, path, jsonSchema, jSonObject);
        if (validationContext.validationConfig.pathFilter.test(pathValidationContext)) {
            Stream<Object> indexedObjectStream = jSonObject != null ? jSonObject.stream() : Stream.of(null);
            Collection<IndexedObjectCheck<?>> checkList = validationContext.indexedObjectChecks;
            this.tryToExecuteChecks(checkList, pathValidationContext);
            JsonSchema itemSchema = jsonSchema.getItems().asSingleItems().getSchema();
            AtomicInteger index = new AtomicInteger(0);
            indexedObjectStream.forEach(value -> this.validate(path + "[" + index.getAndIncrement() + "]", itemSchema, value, validationContext));
        } else {
            this.logSkippingValidation(pathValidationContext);
        }
    }

    protected <S extends JsonSchema, T, C extends Check.Abst<S, T, C>> void validateValue(String path, JsonSchema jsonSchema, Object value, Validation.Context validationContext) {
        Path.Validation.Context pathValidationContext = new Path.Validation.Context(validationContext, path, jsonSchema, value);
        if (validationContext.validationConfig.pathFilter.test(pathValidationContext)) {
            Collection<LeafCheck<?, ?>> checkList = validationContext.leafChecks;
            this.tryToExecuteChecks(checkList, pathValidationContext);
        } else {
            this.logSkippingValidation(pathValidationContext);
        }
    }

    protected <S extends JsonSchema, T, C extends Check.Abst<S, T, C>> void tryToExecuteChecks(Collection<C> checkList, Path.Validation.Context<S, T> pathValidationContext) {
        int executedChecks = 0;
        for (Check.Abst check : checkList) {
            if (!pathValidationContext.validationContext.validationConfig.checkFilter.apply(check).test(pathValidationContext) || !check.predicate.test(pathValidationContext)) continue;
            if (executedChecks++ == 0 && logger != null && pathValidationContext.validationContext.validationConfig.isDeepLoggingEnabled()) {
                ((Logger)logger).debug("Starting validation of path {} with value {}", (Object)pathValidationContext.path, (Object)pathValidationContext.validationContext.inputHandler.valueToString(pathValidationContext.rawValue));
            }
            check.action.accept(pathValidationContext);
        }
        if (executedChecks > 0) {
            if (pathValidationContext.validationContext.exceptions == null || pathValidationContext.validationContext.exceptions.isEmpty()) {
                if (logger != null && pathValidationContext.validationContext.validationConfig.isDeepLoggingEnabled()) {
                    ((Logger)logger).debug("Validation of path {} successfully completed", (Object)pathValidationContext.path);
                }
            } else if (logger != null && pathValidationContext.validationContext.validationConfig.isErrorLoggingEnabled()) {
                ((Logger)logger).debug("Validation of path {} completed with errors", (Object)pathValidationContext.path);
            }
        } else if (logger != null && pathValidationContext.validationContext.validationConfig.isDeepLoggingEnabled()) {
            ((Logger)logger).debug("No custom check executed for path {} with value {}", (Object)pathValidationContext.path, (Object)pathValidationContext.validationContext.inputHandler.valueToString(pathValidationContext.rawValue));
        }
    }

    protected <I> Validation.Context createValidationContext(Validation.Config<I> config, ObjectHandler objectHandler) {
        return new Validation.Context(this.exceptionBuilder, config, objectHandler, this.computeChecks(config.getGroupIds(), this.objectChecks, this.defaultObjectChecks), this.computeChecks(config.getGroupIds(), this.indexedObjectChecks, this.defaultIndexedObjectChecks), this.computeChecks(config.getGroupIds(), this.leafChecks, this.defaultLeafChecks));
    }

    protected <C extends Check<?, ?, C>> Collection<C> computeChecks(Collection<String> groupIds, Map<String, Collection<C>> registeredChecks, Collection<C> defaultChecks) {
        return groupIds.stream().map(registeredChecks::get).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.isEmpty() ? defaultChecks : list));
    }

    protected void logSkippingValidation(Path.Validation.Context<?, ?> pathValidationContext) {
        if (logger != null && pathValidationContext.validationContext.validationConfig.isDeepLoggingEnabled()) {
            ((Logger)logger).debug("Skipping validation of path {} with value {}", (Object)pathValidationContext.path, (Object)pathValidationContext.validationContext.inputHandler.valueToString(pathValidationContext.rawValue));
        }
    }

    static {
        DEFAULT_LEAF_CHECKS_ID = Strings.INSTANCE.toStringWithRandomUUIDSuffix("defaultLeafChecks");
        DEFAULT_OBJECT_CHECKS_ID = Strings.INSTANCE.toStringWithRandomUUIDSuffix("defaultObjectChecks");
        DEFAULT_INDEXED_OBJECT_CHECKS_ID = Strings.INSTANCE.toStringWithRandomUUIDSuffix("defaultIndexedObjectChecks");
        DEFAULT_EXCEPTION_BUILDER = pathValidationContext -> checkType -> messageArguments -> {
            Strings.INSTANCE.compile(checkType, messageArguments);
            return new Validation.Exception(pathValidationContext.getPath(), Strings.INSTANCE.compile(checkType, messageArguments));
        };
        logger = SLF4J.INSTANCE.tryToInitLogger(Validator.class);
    }
}

