/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.Classes;
import org.burningwave.TerminateIterationException;
import org.burningwave.Throwables;
import org.burningwave.json.Path;
import org.burningwave.reflection.FieldAccessor;

public class ObjectHandler {
    private static Function<ObjectHandler, Object> valueRetriever;
    final ObjectMapper objectMapper;
    final ObjectHandler rootHandler;
    final String path;
    Supplier<Object> valueSupplier;
    final Object rawValue;

    static Function<ObjectHandler, Object> buildValueRetriever(FieldAccessor fieldAccessor) {
        return objectHandler -> {
            Object value = objectHandler.rootHandler.getValue();
            for (String pathSegment : objectHandler.removeRootPrefix(objectHandler.path).split("\\.")) {
                if (value == null) break;
                if (value instanceof Map) {
                    pathSegment = "[" + pathSegment + "]";
                }
                try {
                    value = fieldAccessor.get(value, pathSegment);
                }
                catch (IndexOutOfBoundsException exc) {
                    value = null;
                    break;
                }
            }
            return value;
        };
    }

    static Function<ObjectHandler, Object> buildAlwaysNullVaueIfNotValorizedRetriever() {
        return objectHandler -> objectHandler.rootHandler.rawValue == objectHandler.rootHandler.getValue() ? objectHandler.rawValue : null;
    }

    ObjectHandler(ObjectMapper objectMapper, String path, ObjectHandler masterObjectHandler, Object convertedValue, Object originalValue) {
        this.objectMapper = objectMapper;
        this.path = path;
        this.rootHandler = masterObjectHandler == null && "".equals(path) ? this : masterObjectHandler;
        this.rawValue = convertedValue;
        this.valueSupplier = originalValue != null ? () -> originalValue : () -> valueRetriever.apply(this);
    }

    public static ObjectHandler create(ObjectMapper objectMapper, Object jsonObject) {
        if (ObjectHandler.isConvertible(jsonObject)) {
            if (jsonObject instanceof Collection) {
                return new ObjectHandler(objectMapper, "", null, objectMapper.convertValue(jsonObject, (TypeReference)new TypeReference<List<Object>>(){}), jsonObject);
            }
            return new ObjectHandler(objectMapper, "", null, objectMapper.convertValue(jsonObject, (TypeReference)new TypeReference<Map<String, Object>>(){}), jsonObject);
        }
        return new ObjectHandler(objectMapper, "", null, jsonObject, jsonObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isConvertible(Object jsonObject) {
        if (Classes.INSTANCE.isPrimitive(jsonObject)) return false;
        if (jsonObject instanceof Map) return false;
        if (!(jsonObject instanceof Collection)) return true;
        if (((Collection)jsonObject).stream().findFirst().map(Map.class::isInstance).orElseGet(() -> false) != false) return false;
        return true;
    }

    public Finder newFinder() {
        return new Finder(this);
    }

    public ValueFinder newValueFinder() {
        return new ValueFinder(this);
    }

    public <V> ValueFinderAndConverter<V> newValueFinderAndConverter(Class<V> outputClass) {
        return new ValueFinderAndConverter<V>(this, outputClass);
    }

    protected <O> O findFirst(Object jSonObject, Predicate<ObjectHandler> filter, Function<ObjectHandler, O> converter) {
        ArrayList collector = new ArrayList();
        try {
            this.findValues(this.isRoot() ? "" : "", jSonObject, (ObjectHandler objectHandler) -> {
                boolean testResult = objectHandler.rawValue != null && filter.test((ObjectHandler)objectHandler);
                return new AbstractMap.SimpleEntry<Boolean, TerminateIterationException>(testResult, (TerminateIterationException)((Object)(testResult ? TerminateIterationException.INSTANCE : null)));
            }, converter, collector);
        }
        catch (TerminateIterationException terminateIterationException) {
            // empty catch block
        }
        return (O)collector.stream().findFirst().orElseGet(() -> null);
    }

    protected <O> List<O> find(Object jSonObject, Predicate<ObjectHandler> filter, Function<ObjectHandler, O> converter) {
        ArrayList collector = new ArrayList();
        this.findValues(this.isRoot() ? "" : "", jSonObject, (ObjectHandler objectHandler) -> new AbstractMap.SimpleEntry<Boolean, Object>(filter.test((ObjectHandler)objectHandler), null), converter, collector);
        return collector;
    }

    protected <I, O> void findValues(String path, Object jSonObject, Function<ObjectHandler, Map.Entry<Boolean, TerminateIterationException>> filter, Function<ObjectHandler, O> converter, Collection<O> collector) {
        if (jSonObject instanceof Map) {
            this.findValues(path, (Map)jSonObject, filter, converter, collector);
        } else if (jSonObject instanceof Collection) {
            this.findValues(path, (Collection)jSonObject, filter, converter, collector);
        } else {
            this.checkAndCollectValue(path, jSonObject, filter, converter, collector);
        }
    }

    protected <O> void findValues(String path, Map<String, Object> jSonObject, Function<ObjectHandler, Map.Entry<Boolean, TerminateIterationException>> filter, Function<ObjectHandler, O> converter, Collection<O> collector) {
        this.checkAndCollectValue(path, jSonObject, filter, converter, collector);
        for (Map.Entry<String, Object> nameAndValue : jSonObject.entrySet()) {
            String iteratedPath = (!path.isEmpty() ? path + "." : path) + nameAndValue.getKey();
            this.findValues(iteratedPath, nameAndValue.getValue(), filter, converter, collector);
        }
    }

    protected <I, O> void findValues(String path, Collection<I> jSonObject, Function<ObjectHandler, Map.Entry<Boolean, TerminateIterationException>> filter, Function<ObjectHandler, O> converter, Collection<O> collector) {
        this.checkAndCollectValue(path, jSonObject, filter, converter, collector);
        Stream<Object> indexedObjectStream = jSonObject != null ? jSonObject.stream() : Stream.of(new Object[0]);
        AtomicInteger index = new AtomicInteger(0);
        indexedObjectStream.forEach(vl -> this.findValues(path + "[" + index.getAndIncrement() + "]", vl, filter, converter, collector));
    }

    <O> void checkAndCollectValue(String path, Object value, Function<ObjectHandler, Map.Entry<Boolean, TerminateIterationException>> filter, Function<ObjectHandler, O> converter, Collection<O> collector) {
        TerminateIterationException terminateIterationException;
        path = this.removeRootPrefix(path);
        String finalPath = this.path.isEmpty() ? path : (path.isEmpty() ? this.path : this.path + "." + path);
        ObjectHandler objectHandler = !Path.INSTANCE.isRoot(finalPath) ? new ObjectHandler(this.objectMapper, finalPath, this.rootHandler, value, null) : this.rootHandler;
        Map.Entry<Boolean, TerminateIterationException> testResult = filter.apply(objectHandler);
        if (testResult.getKey().booleanValue()) {
            collector.add(converter.apply(objectHandler));
        }
        if ((terminateIterationException = testResult.getValue()) != null) {
            throw terminateIterationException;
        }
    }

    public <T> T getRawValue() {
        return (T)this.rawValue;
    }

    public <T> T getValue() {
        return (T)this.valueSupplier.get();
    }

    public <T> T getValueOrRawValue() {
        T value = this.getValue();
        return value != null ? value : this.getRawValue();
    }

    protected String removeRootPrefix(String path) {
        if (!"".isEmpty() && path.startsWith("") && (path = path.replaceFirst("", "")).startsWith(".")) {
            path = path.substring(1);
        }
        return path;
    }

    public String getPath() {
        return this.path;
    }

    public ObjectHandler getParent() {
        try {
            return (ObjectHandler)this.rootHandler.newFinder().findForPathEquals(new String[]{Path.INSTANCE.normalize(this.path, "../")});
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public boolean isRoot() {
        return Path.INSTANCE.isRoot(this.path);
    }

    public <I, T> T convert(Class<T> targetClass) {
        T originalValue = this.getValueOrRawValue();
        if (originalValue == null) {
            return null;
        }
        return (T)this.objectMapper.convertValue(originalValue, targetClass);
    }

    public String toString() {
        return this.path + " - " + Optional.ofNullable(this.rawValue).map(this::valueToString).orElseGet(() -> "null");
    }

    protected String valueToString(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException exc) {
            return (String)Throwables.INSTANCE.throwException((Throwable)exc);
        }
    }

    static {
        try {
            if (((Boolean)Configuration.freezeAndGet().get("reflection.enabled")).booleanValue()) {
                valueRetriever = ObjectHandler.buildValueRetriever(FieldAccessor.INSTANCE);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (valueRetriever == null) {
                valueRetriever = ObjectHandler.buildAlwaysNullVaueIfNotValorizedRetriever();
            }
        }
    }

    public static final class Configuration {
        private static Map<String, Object> values = new LinkedHashMap<String, Object>();
        private static boolean freezed;

        private Configuration() {
        }

        public static void disableReflection() {
            Configuration.putConfigurationValue("reflection.enabled", false);
        }

        private static void putConfigurationValue(String key, Object value) {
            try {
                values.put(key, value);
            }
            catch (UnsupportedOperationException exc) {
                throw new UnsupportedOperationException("Cannot add configuration value after that the " + ObjectHandler.class.getSimpleName() + " has been initialized");
            }
        }

        private static Map<String, Object> freezeAndGet() {
            if (!freezed) {
                values = Collections.unmodifiableMap(values);
            }
            return values;
        }

        static {
            Configuration.putConfigurationValue("reflection.enabled", true);
        }

        public static final class Key {
            private static final String REFLECTION_ENABLED = "reflection.enabled";

            private Key() {
            }
        }
    }

    public static class Finder
    extends AbstFinder {
        Finder(ObjectHandler objectHandler) {
            super(objectHandler);
        }

        ObjectHandler convert(ObjectHandler found) {
            return found;
        }
    }

    public static class ValueFinder
    extends AbstFinder {
        ValueFinder(ObjectHandler objectHandler) {
            super(objectHandler);
        }

        @Override
        <V> V convert(ObjectHandler found) {
            return (V)found.getValueOrRawValue();
        }
    }

    public static class ValueFinderAndConverter<V>
    extends AbstFinder {
        private Class<V> outputClass;

        ValueFinderAndConverter(ObjectHandler objectHandler, Class<V> outputClass) {
            super(objectHandler);
            this.outputClass = outputClass;
        }

        @Override
        V convert(ObjectHandler found) {
            return found.convert(this.outputClass);
        }

        public ValueFinderAndConverter<V> changeOutputClass(Class<V> outputClass) {
            this.outputClass = outputClass;
            return this;
        }
    }

    static abstract class AbstFinder {
        private ObjectHandler objectHandler;

        AbstFinder(ObjectHandler objectHandler) {
            this.objectHandler = objectHandler;
        }

        public <V> List<V> find(Predicate<ObjectHandler> filter) {
            return this.objectHandler.find(this.objectHandler.rawValue, filter, this::convert);
        }

        public <V> V findFirst(Predicate<ObjectHandler> filter) {
            return (V)this.objectHandler.findFirst(this.objectHandler.rawValue, filter, this::convert);
        }

        public <V> V findForPathEquals(String ... pathSegments) {
            return this.findFirst(oW -> oW.path.equals(Path.of(pathSegments)));
        }

        public <V> V findFirstForPath(Predicate<String> pathPredicate) {
            return this.findFirst(oW -> pathPredicate.test(oW.path));
        }

        public <V> V findFirstForPathStartsWith(String ... pathSegments) {
            return this.findFirstForPathMatches(Path.INSTANCE.toStartsWithRegEx(Path.of(pathSegments)));
        }

        public <V> V findFirstForPathEndsWith(String ... pathSegments) {
            return this.findFirstForPathMatches(Path.INSTANCE.toEndsWithRegEx(Path.of(pathSegments)));
        }

        public <V> V findFirstForPathContains(String ... pathSegments) {
            return this.findFirstForPathMatches(Path.INSTANCE.toContainsRegEx(Path.of(pathSegments)));
        }

        public <V> V findFirstForPathMatches(String regEx) {
            return this.findFirst(oW -> oW.path.matches(regEx));
        }

        public <I, V> V findFirstForValue(Predicate<I> valuePredicate) {
            return this.findFirst(oW -> valuePredicate.test(oW.getValueOrRawValue()));
        }

        public <V> List<V> findForPathStartsWith(String ... pathSegments) {
            return this.findForPathMatches(Path.INSTANCE.toStartsWithRegEx(Path.of(pathSegments)));
        }

        public <V> List<V> findForPathEndsWith(String ... pathSegments) {
            return this.findForPathMatches(Path.INSTANCE.toEndsWithRegEx(Path.of(pathSegments)));
        }

        public <V> List<V> findForPathContains(String ... pathSegments) {
            return this.findForPathMatches(Path.INSTANCE.toContainsRegEx(Path.of(pathSegments)));
        }

        public <V> List<V> findForPathMatches(String regEx) {
            return this.find(oW -> oW.path.matches(regEx));
        }

        public <V> List<V> findForPath(Predicate<String> pathPredicate) {
            return this.find(oW -> pathPredicate.test(oW.path));
        }

        public <I, V> List<V> findForValue(Predicate<I> valuePredicate) {
            return this.find(oW -> valuePredicate.test(oW.getValueOrRawValue()));
        }

        <V> List<V> convert(List<ObjectHandler> founds) {
            return founds.stream().map(this::convert).collect(Collectors.toList());
        }

        abstract <V> V convert(ObjectHandler var1);
    }
}

