/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import java.util.LinkedHashMap;
import java.util.Map;
import org.burningwave.Throwables;

public class SchemaHolder {
    private final Map<Class<?>, JsonSchema> jsonSchemasForClasses;
    final ObjectMapper objectMapper;
    final JsonSchemaGenerator jsonSchemaGenerator;

    public SchemaHolder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        SchemaFactoryWrapper schemaFactoryWrapper = new SchemaFactoryWrapper();
        schemaFactoryWrapper.setVisitorContext(new VisitorContext(){

            public String addSeenSchemaUri(JavaType aSeenSchema) {
                return this.javaTypeToUrn(aSeenSchema);
            }
        });
        this.jsonSchemaGenerator = new JsonSchemaGenerator(this.objectMapper, schemaFactoryWrapper);
        this.jsonSchemasForClasses = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I> JsonSchema getJsonSchema(I jsonObject) {
        Class<?> jsonObjectClass = jsonObject.getClass();
        JsonSchema jsonSchema = this.jsonSchemasForClasses.get(jsonObjectClass);
        if (jsonSchema == null) {
            Map<Class<?>, JsonSchema> map = this.jsonSchemasForClasses;
            synchronized (map) {
                jsonSchema = this.jsonSchemasForClasses.get(jsonObjectClass);
                if (jsonSchema == null) {
                    try {
                        jsonSchema = this.jsonSchemaGenerator.generateSchema(jsonObjectClass);
                        this.jsonSchemasForClasses.put(jsonObjectClass, jsonSchema);
                    }
                    catch (JsonMappingException exc) {
                        return (JsonSchema)Throwables.INSTANCE.throwException((Throwable)exc);
                    }
                }
            }
        }
        return jsonSchema;
    }
}

