/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dependencies;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.burningwave.core.classes.ClassHelper;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.common.Strings;
import org.burningwave.core.function.TriConsumer;
import org.burningwave.core.io.FileInputStream;
import org.burningwave.core.io.FileScanConfig;
import org.burningwave.core.io.FileSystemHelper;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.ZipInputStream;

public class Sniffer
extends MemoryClassLoader {
    private Function<JavaClass, Boolean> javaClassFilterAndAdder;
    private Function<FileSystemItem, Boolean> resourceFilterAndAdder;
    private Map<String, FileSystemItem> resources;
    private Map<String, JavaClass> javaClasses;
    private TriConsumer<String, String, ByteBuffer> resourcesConsumer;
    private ClassLoader mainClassLoader;

    protected Sniffer(boolean useThreadContextClassLoaderAsParent, Collection<String> baseClassPaths, FileSystemHelper fileSystemHelper, ClassHelper classHelper, Function<JavaClass, Boolean> javaClassAdder, Function<FileSystemItem, Boolean> resourceAdder, TriConsumer<String, String, ByteBuffer> resourcesConsumer) {
        super(useThreadContextClassLoaderAsParent ? Thread.currentThread().getContextClassLoader() : null, classHelper);
        this.javaClassFilterAndAdder = javaClassAdder;
        this.resourceFilterAndAdder = resourceAdder;
        this.resourcesConsumer = resourcesConsumer;
        this.resources = new ConcurrentHashMap<String, FileSystemItem>();
        this.javaClasses = new ConcurrentHashMap<String, JavaClass>();
        fileSystemHelper.scan(FileScanConfig.forPaths(baseClassPaths).toScanConfiguration(this.getFileSystemMapStorer(), this.getZipEntryMapStorer()));
        if (!useThreadContextClassLoaderAsParent) {
            this.mainClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this));
        }
    }

    Consumer<FileSystemHelper.Scan.ItemContext<FileInputStream>> getFileSystemMapStorer() {
        return scannedItemContext -> {
            String absolutePath = ((FileInputStream)scannedItemContext.getInput()).getAbsolutePath();
            this.resources.put(absolutePath, FileSystemItem.ofPath((String)absolutePath));
            if (absolutePath.endsWith(".class")) {
                JavaClass javaClass = JavaClass.create((ByteBuffer)((FileInputStream)scannedItemContext.getInput()).toByteBuffer());
                this.addCompiledClass(javaClass.getName(), javaClass.getByteCode());
                this.javaClasses.put(absolutePath, javaClass);
            }
        };
    }

    Consumer<FileSystemHelper.Scan.ItemContext<ZipInputStream.Entry>> getZipEntryMapStorer() {
        return scannedItemContext -> {
            String absolutePath = ((ZipInputStream.Entry)scannedItemContext.getInput()).getAbsolutePath();
            this.resources.put(absolutePath, FileSystemItem.ofPath((String)absolutePath));
            if (absolutePath.endsWith(".class")) {
                JavaClass javaClass = JavaClass.create((ByteBuffer)((ZipInputStream.Entry)scannedItemContext.getInput()).toByteBuffer());
                if (javaClass.getName().contains("Base64Variant")) {
                    this.logDebug("Entered");
                }
                this.addCompiledClass(javaClass.getName(), javaClass.getByteCode());
                this.javaClasses.put(absolutePath, javaClass);
            }
        };
    }

    protected void consumeClass(String className) {
        for (Map.Entry<String, JavaClass> entry : this.javaClasses.entrySet()) {
            JavaClass javaClass;
            if (!entry.getValue().getName().equals(className) || !this.javaClassFilterAndAdder.apply(javaClass = entry.getValue()).booleanValue()) continue;
            this.resourcesConsumer.accept((Object)entry.getKey(), (Object)javaClass.getPath(), (Object)javaClass.getByteCode());
        }
    }

    protected Collection<FileSystemItem> consumeResource(String relativePath, boolean breakWhenFound) {
        LinkedHashSet<FileSystemItem> founds = new LinkedHashSet<FileSystemItem>();
        if (Strings.isNotEmpty((String)relativePath)) {
            for (Map.Entry<String, FileSystemItem> entry : this.resources.entrySet()) {
                if (!entry.getValue().getAbsolutePath().endsWith(relativePath)) continue;
                FileSystemItem fileSystemItem = entry.getValue();
                founds.add(fileSystemItem);
                if (this.resourceFilterAndAdder.apply(fileSystemItem).booleanValue()) {
                    this.resourcesConsumer.accept((Object)entry.getKey(), (Object)relativePath, (Object)fileSystemItem.toByteBuffer());
                }
                if (!breakWhenFound) continue;
                break;
            }
        }
        return founds;
    }

    public void addLoadedCompiledClass(String className, ByteBuffer byteCode) {
        super.addLoadedCompiledClass(className, byteCode);
        this.consumeClass(className);
    }

    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class cls = super.loadClass(className, resolve);
        this.consumeClass(className);
        return cls;
    }

    public URL getResource(String name) {
        Enumeration<URL> urls = this.getResources(name, true);
        if (urls.hasMoreElements()) {
            return urls.nextElement();
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getResources(name, false);
    }

    private Enumeration<URL> getResources(String name, boolean findFirst) {
        return Collections.enumeration(this.consumeResource(name, findFirst).stream().map(fileSystemItem -> {
            this.resourceFilterAndAdder.apply((FileSystemItem)fileSystemItem);
            return fileSystemItem.getURL();
        }).collect(Collectors.toSet()));
    }

    public InputStream getResourceAsStream(String name) {
        FileSystemItem fileSystemItem = this.consumeResource(name, true).stream().findFirst().orElseGet(() -> null);
        if (fileSystemItem != null) {
            return fileSystemItem.toInputStream();
        }
        return this.getLoadedCompiledClassesAsInputStream(name);
    }

    public void close() {
        if (this.mainClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.mainClassLoader);
        }
        this.resources.clear();
        this.resources = null;
        this.javaClasses.clear();
        this.javaClasses = null;
        this.javaClassFilterAndAdder = null;
        this.resourceFilterAndAdder = null;
        this.mainClassLoader = null;
        super.close();
    }
}

