/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dependencies;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.function.ThrowingBiFunction;
import org.burningwave.core.function.TriConsumer;
import org.burningwave.core.io.FileSystemItem;

public class Sniffer
extends MemoryClassLoader {
    private Function<JavaClass, Boolean> javaClassFilterAndAdder;
    private Function<FileSystemItem, Boolean> resourceFilterAndAdder;
    private Map<String, FileSystemItem> resources;
    private Map<String, JavaClass> javaClasses;
    private Map<String, JavaClass> bwJavaClasses;
    private TriConsumer<String, String, ByteBuffer> resourcesConsumer;
    ClassLoader threadContextClassLoader;
    Function<Boolean, ClassLoader> masterClassLoaderRetrieverAndResetter;
    ThrowingBiFunction<String, Boolean, Class<?>, ClassNotFoundException> classLoadingFunction;

    public Sniffer(ClassLoader parent) {
        super(parent);
    }

    protected Sniffer init(boolean useAsMasterClassLoader, Collection<String> baseClassPaths, Function<JavaClass, Boolean> javaClassAdder, Function<FileSystemItem, Boolean> resourceAdder, TriConsumer<String, String, ByteBuffer> resourcesConsumer) {
        this.threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        this.javaClassFilterAndAdder = javaClassAdder;
        this.resourceFilterAndAdder = resourceAdder;
        this.resourcesConsumer = resourcesConsumer;
        this.initResourceLoader(baseClassPaths);
        if (useAsMasterClassLoader) {
            StaticComponentContainer.ClassLoaders.getDefineClassMethod(this.threadContextClassLoader);
            StaticComponentContainer.ClassLoaders.getDefinePackageMethod(this.threadContextClassLoader);
            this.classLoadingFunction = (className, resolve) -> {
                if (!className.startsWith("org.burningwave.") && !className.startsWith("io.github.toolfactory.")) {
                    return super.loadClass(className, resolve.booleanValue());
                }
                try {
                    return StaticComponentContainer.ClassLoaders.defineOrLoad(this.threadContextClassLoader, this.bwJavaClasses.get(className));
                }
                catch (NoClassDefFoundError | ReflectiveOperationException exc) {
                    throw new ClassNotFoundException(StaticComponentContainer.Classes.retrieveName(exc));
                }
            };
            this.masterClassLoaderRetrieverAndResetter = StaticComponentContainer.ClassLoaders.setAsParent(this.threadContextClassLoader, (ClassLoader)((Object)this));
        } else {
            this.classLoadingFunction = (clsName, resolveFlag) -> super.loadClass(clsName, resolveFlag.booleanValue());
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this));
        }
        return this;
    }

    public synchronized void addByteCode(String className, ByteBuffer byteCode) {
        super.addByteCode(className, byteCode);
    }

    private void initResourceLoader(Collection<String> baseClassPaths) {
        this.resources = new ConcurrentHashMap<String, FileSystemItem>();
        this.javaClasses = new ConcurrentHashMap<String, JavaClass>();
        this.bwJavaClasses = new ConcurrentHashMap<String, JavaClass>();
        StaticComponentContainer.ManagedLoggersRepository.logInfo(((Object)((Object)this)).getClass()::getName, "Scanning paths :\n{}", new Object[]{String.join((CharSequence)"\n", baseClassPaths)});
        for (String classPath : baseClassPaths) {
            FileSystemItem.ofPath((String)classPath).refresh().findInAllChildren(FileSystemItem.Criteria.forAllFileThat(fileSystemItem -> {
                String absolutePath = fileSystemItem.getAbsolutePath();
                this.resources.put(absolutePath, FileSystemItem.ofPath((String)absolutePath));
                JavaClass javaClass = fileSystemItem.toJavaClass();
                if (javaClass != null) {
                    this.addByteCode(javaClass.getName(), javaClass.getByteCode());
                    this.javaClasses.put(absolutePath, javaClass);
                    if (javaClass.getName().startsWith("org.burningwave.") || javaClass.getName().startsWith("io.github.toolfactory.")) {
                        this.bwJavaClasses.put(javaClass.getName(), javaClass);
                    }
                }
                return true;
            }));
        }
    }

    protected void consumeClass(String className) {
        this.consumeClasses(Arrays.asList(className));
    }

    public void consumeClasses(Collection<String> currentNotFoundClasses) {
        for (Map.Entry<String, JavaClass> entry : this.javaClasses.entrySet()) {
            JavaClass javaClass;
            if (!currentNotFoundClasses.contains(entry.getValue().getName()) || !this.javaClassFilterAndAdder.apply(javaClass = entry.getValue()).booleanValue()) continue;
            this.resourcesConsumer.accept((Object)entry.getKey(), (Object)javaClass.getPath(), (Object)javaClass.getByteCode());
        }
    }

    protected Collection<FileSystemItem> consumeResource(String relativePath, boolean breakWhenFound) {
        LinkedHashSet<FileSystemItem> founds = new LinkedHashSet<FileSystemItem>();
        if (StaticComponentContainer.Strings.isNotEmpty(relativePath)) {
            for (Map.Entry<String, FileSystemItem> entry : this.resources.entrySet()) {
                if (!entry.getValue().getAbsolutePath().endsWith(relativePath)) continue;
                FileSystemItem fileSystemItem = entry.getValue();
                founds.add(fileSystemItem);
                if (this.resourceFilterAndAdder.apply(fileSystemItem).booleanValue()) {
                    this.resourcesConsumer.accept((Object)entry.getKey(), (Object)relativePath, (Object)fileSystemItem.toByteBuffer());
                }
                if (!breakWhenFound) continue;
                break;
            }
        }
        return founds;
    }

    public void addLoadedByteCode(String className, ByteBuffer byteCode) {
        super.addLoadedByteCode(className, byteCode);
        this.consumeClass(className);
    }

    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class cls = (Class)this.classLoadingFunction.apply((Object)className, (Object)resolve);
        this.consumeClass(className);
        return cls;
    }

    public Class<?> _loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class cls = (Class)this.classLoadingFunction.apply((Object)className, (Object)resolve);
        this.consumeClass(className);
        return cls;
    }

    public URL getResource(String name) {
        Enumeration<URL> urls = this.getResources(name, true);
        if (urls.hasMoreElements()) {
            return urls.nextElement();
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getResources(name, false);
    }

    private Enumeration<URL> getResources(String name, boolean findFirst) {
        return Collections.enumeration(this.consumeResource(name, findFirst).stream().map(fileSystemItem -> {
            this.resourceFilterAndAdder.apply((FileSystemItem)fileSystemItem);
            return fileSystemItem.getURL();
        }).collect(Collectors.toSet()));
    }

    public InputStream getResourceAsStream(String name) {
        FileSystemItem fileSystemItem = this.consumeResource(name, true).stream().findFirst().orElseGet(() -> null);
        if (fileSystemItem != null) {
            return fileSystemItem.toInputStream();
        }
        return this.getByteCodeAsInputStream(name);
    }

    public void close() {
        this.closeResources(() -> this.masterClassLoaderRetrieverAndResetter == null, task -> {
            if (this.threadContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.threadContextClassLoader);
            }
            if (this.masterClassLoaderRetrieverAndResetter != null) {
                this.masterClassLoaderRetrieverAndResetter.apply(true);
                this.masterClassLoaderRetrieverAndResetter = null;
            }
            this.resources.clear();
            this.javaClasses.clear();
            this.unregister();
        });
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

