/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dependencies;

import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.ComponentContainer;
import org.burningwave.core.assembler.ComponentSupplier;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ByteCodeHunter;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.concurrent.QueuedTasksExecutor;
import org.burningwave.core.function.TriConsumer;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.tools.dependencies.Sniffer;

public class Capturer
implements Component {
    protected static final String BURNINGWAVE_CLASSES_RELATIVE_DESTINATION_PATH = "[org.burningwave]";
    protected static final String TOOLFACTORY_CLASSES_RELATIVE_DESTINATION_PATH = "[io.github.toolfactory]";
    ByteCodeHunter byteCodeHunter;

    Capturer(ByteCodeHunter byteCodeHunter) {
        this.byteCodeHunter = byteCodeHunter;
    }

    public static Capturer create(ComponentSupplier componentSupplier) {
        return new Capturer(componentSupplier.getByteCodeHunter());
    }

    public static Capturer getInstance() {
        return LazyHolder.getCapturerInstance();
    }

    public Result capture(String mainClassName, Collection<String> baseClassPaths, TriConsumer<String, String, ByteBuffer> resourceConsumer, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) {
        return this.capture(mainClassName, new String[0], baseClassPaths, resourceConsumer, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor);
    }

    public Result capture(String mainClassName, String[] mainMethodAruments, Collection<String> baseClassPaths, TriConsumer<String, String, ByteBuffer> resourceConsumer, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) {
        Result result = new Result();
        Function<JavaClass, Boolean> javaClassAdder = includeMainClass ? javaClass -> {
            result.put((JavaClass)javaClass);
            return true;
        } : javaClass -> {
            if (!javaClass.getName().equals(mainClassName)) {
                result.put((JavaClass)javaClass);
                return true;
            }
            return false;
        };
        result.findingTask = (QueuedTasksExecutor.Task)StaticComponentContainer.BackgroundExecutor.createTask(task -> {
            try (Sniffer resourceSniffer = new Sniffer(null).init(false, baseClassPaths, javaClassAdder, fileSystemItem -> {
                result.putResource((FileSystemItem)fileSystemItem);
                return true;
            }, resourceConsumer);){
                try {
                    Class<?> cls = Class.forName(mainClassName, false, (ClassLoader)((Object)resourceSniffer));
                    cls.getMethod("main", String[].class).invoke(null, new Object[]{mainMethodAruments});
                    if (continueToCaptureAfterSimulatorClassEndExecutionFor != null && continueToCaptureAfterSimulatorClassEndExecutionFor > 0L) {
                        Thread.sleep(continueToCaptureAfterSimulatorClassEndExecutionFor);
                    }
                    this.createExecutor(result.getStore().getAbsolutePath(), mainClassName, mainMethodAruments, UUID.randomUUID().toString());
                }
                catch (Throwable exc) {
                    try {
                        StaticComponentContainer.Driver.throwException((Object)exc, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.createExecutor(result.getStore().getAbsolutePath(), mainClassName, mainMethodAruments, UUID.randomUUID().toString());
                    }
                }
            }
        }).submit();
        return result;
    }

    public Result captureAndStore(String mainClassName, Collection<String> baseClassPaths, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) {
        return this.captureAndStore(mainClassName, new String[0], baseClassPaths, destinationPath, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor);
    }

    public Result captureAndStore(String mainClassName, String[] mainMethodAruments, Collection<String> baseClassPaths, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) {
        Result dependencies = this.capture(mainClassName, mainMethodAruments, baseClassPaths, this.getStoreFunction(destinationPath), includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor);
        dependencies.store = FileSystemItem.ofPath((String)destinationPath);
        return dependencies;
    }

    TriConsumer<String, String, ByteBuffer> getStoreFunction(String destinationPath) {
        String javaHome = StaticComponentContainer.Paths.clean(System.getProperty("java.home")) + "/";
        BiPredicate<String, FileSystemItem> storePredicate = (resourceAbsolutePath, fileSystemItem) -> !resourceAbsolutePath.startsWith(javaHome) && !fileSystemItem.exists();
        return (resourceAbsolutePath, resourceRelativePath, resourceContent) -> {
            String finalPath = resourceRelativePath.startsWith("io/github/toolfactory") ? destinationPath + "/" + TOOLFACTORY_CLASSES_RELATIVE_DESTINATION_PATH : (resourceRelativePath.startsWith("org/burningwave") ? destinationPath + "/" + BURNINGWAVE_CLASSES_RELATIVE_DESTINATION_PATH : this.getStoreEntryBasePath(destinationPath, (String)resourceAbsolutePath, (String)resourceRelativePath));
            FileSystemItem fileSystemItem = FileSystemItem.ofPath((String)(finalPath + "/" + resourceRelativePath));
            if (storePredicate.test((String)resourceAbsolutePath, fileSystemItem)) {
                StaticComponentContainer.Streams.store(fileSystemItem.getAbsolutePath(), resourceContent);
                StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Resource {} has been stored to class path {}", new Object[]{resourceRelativePath, fileSystemItem.getAbsolutePath()});
            }
        };
    }

    String getStoreEntryBasePath(String storeBasePath, String itemAbsolutePath, String ItemRelativePath) {
        String finalPath = itemAbsolutePath;
        if (finalPath.chars().filter(ch -> ch == 47).count() > 1L) {
            finalPath = finalPath.substring(0, finalPath.lastIndexOf(ItemRelativePath) - 1).substring(finalPath.indexOf("/") + 1);
            finalPath = "[" + finalPath.replace("/", "][") + "]";
        } else {
            finalPath = finalPath.replace("/", "");
        }
        return storeBasePath + "/" + this.getReducedPath(finalPath);
    }

    private String getReducedPath(String path) {
        String temp = path.substring(0, path.lastIndexOf("["));
        temp = temp.substring(0, temp.lastIndexOf("["));
        return path.substring(temp.lastIndexOf("["));
    }

    void createExecutor(String destinationPath, String mainClassName, String[] mainMethodAruments, String executorSuffix) {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            this.createWindowsExecutor(destinationPath, mainClassName, mainMethodAruments, executorSuffix);
        } else {
            this.createUnixExecutor(destinationPath, mainClassName, mainMethodAruments, executorSuffix);
        }
    }

    void createWindowsExecutor(String destinationPath, String mainClassName, String[] mainMethodAruments, String executorSuffix) {
        try {
            Set classPathSet = FileSystemItem.ofPath((String)destinationPath).refresh().findInChildren(FileSystemItem.Criteria.forAllFileThat(FileSystemItem::isFolder)).stream().map(fileSystemItem -> fileSystemItem.getAbsolutePath().replace(destinationPath + "/", "%~dp0")).collect(Collectors.toSet());
            String externalExecutorForWindows = "@echo off\n\"" + FileSystemItem.ofPath((String)System.getProperty("java.home")).getAbsolutePath() + "/bin/java\" -classpath \"" + String.join((CharSequence)System.getProperty("path.separator"), classPathSet) + "\" " + mainClassName + (mainMethodAruments.length > 0 ? " " + String.join((CharSequence)" ", this.toDoubleQuotedStringsForStringsThatContainEmptySpace(mainMethodAruments)) : "");
            Files.write(Paths.get(destinationPath + "/executor-" + executorSuffix + ".cmd", new String[0]), externalExecutorForWindows.getBytes(), new OpenOption[0]);
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred", exc);
        }
    }

    void createUnixExecutor(String destinationPath, String mainClassName, String[] mainMethodAruments, String executorSuffix) {
        try {
            Set classPathSet = FileSystemItem.ofPath((String)destinationPath).refresh().findInChildren(FileSystemItem.Criteria.forAllFileThat(FileSystemItem::isFolder)).stream().map(fileSystemItem -> fileSystemItem.getAbsolutePath()).collect(Collectors.toSet());
            String externalExecutorForUnix = FileSystemItem.ofPath((String)System.getProperty("java.home")).getAbsolutePath() + "/bin/java -classpath " + String.join((CharSequence)System.getProperty("path.separator"), classPathSet) + " " + mainClassName + (mainMethodAruments.length > 0 ? " " + String.join((CharSequence)" ", this.toDoubleQuotedStringsForStringsThatContainEmptySpace(mainMethodAruments)) : "");
            Files.write(Paths.get(destinationPath + "/executor-" + executorSuffix + ".sh", new String[0]), externalExecutorForUnix.getBytes(), new OpenOption[0]);
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred", exc);
        }
    }

    String[] toDoubleQuotedStringsForStringsThatContainEmptySpace(String[] values) {
        String[] newValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = values[i].contains(" ") ? "\"" + values[i] + "\"" : values[i];
        }
        return newValues;
    }

    static class LazyHolder {
        static final Capturer CAPTURER_INSTANCE = Capturer.create((ComponentSupplier)ComponentContainer.getInstance());

        LazyHolder() {
        }

        static Capturer getCapturerInstance() {
            return CAPTURER_INSTANCE;
        }
    }

    public static class Result
    implements Component {
        QueuedTasksExecutor.Task findingTask;
        Collection<FileSystemItem> resources;
        Collection<JavaClass> javaClasses = new CopyOnWriteArrayList<JavaClass>();
        FileSystemItem store;

        Result() {
            this.resources = new CopyOnWriteArrayList<FileSystemItem>();
        }

        public void putResource(FileSystemItem fileSystemItem) {
            this.resources.add(fileSystemItem);
        }

        JavaClass put(JavaClass javaClass) {
            this.javaClasses.add(javaClass);
            return javaClass;
        }

        public Collection<JavaClass> getJavaClasses() {
            return this.javaClasses;
        }

        public Collection<FileSystemItem> getResources() {
            return this.resources;
        }

        public JavaClass getJavaClass(Predicate<JavaClass> predicate) {
            return this.getJavaClasses().stream().filter(predicate).findFirst().orElseGet(() -> null);
        }

        public Collection<FileSystemItem> getResources(Predicate<FileSystemItem> predicate) {
            return this.getResources().stream().filter(predicate).collect(Collectors.toSet());
        }

        public QueuedTasksExecutor.Task getFindingTask() {
            return this.findingTask;
        }

        public void waitForTaskEnding() {
            this.findingTask.waitForFinish();
        }

        public FileSystemItem getStore() {
            return this.store;
        }

        public void close() {
            this.findingTask.abort();
            this.findingTask = null;
            this.resources.clear();
            this.resources = null;
            this.javaClasses.clear();
            this.javaClasses = null;
            this.store = null;
        }
    }
}

