/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dns;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.FieldCriteria;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.tools.dns.IPAddressUtil;

public class HostNameForIPMapper {
    public static final HostNameForIPMapper INSTANCE;
    private static final Field nameServiceField;
    private static final Class<?> nameServiceFieldClass;
    private static final Class<?> nameServiceClass;
    private static final Class<?> inetAddressClass;
    private static final Collection<Object> nameServices;

    private HostNameForIPMapper() {
    }

    private static Collection<Object> getNameServices() {
        if (nameServiceField.getName().equals("resolver")) {
            StaticComponentContainer.Methods.invokeStaticDirect(inetAddressClass, "resolver", new Object[0]);
        }
        CopyOnWriteArrayList<Object> nameServices = new CopyOnWriteArrayList<Object>();
        if (Collection.class.isAssignableFrom(nameServiceFieldClass)) {
            nameServices.addAll((Collection)StaticComponentContainer.Fields.getStatic(nameServiceField));
        } else {
            nameServices.add(StaticComponentContainer.Fields.getStatic(nameServiceField));
        }
        return nameServices;
    }

    private static Class<?> getNameServiceFieldClass(Field nameServiceField) {
        if (Collection.class.isAssignableFrom(nameServiceField.getType())) {
            ParameterizedType stringListType = (ParameterizedType)nameServiceField.getGenericType();
            return (Class)stringListType.getActualTypeArguments()[0];
        }
        return nameServiceField.getType();
    }

    @SafeVarargs
    public final HostNameForIPMapper install(Supplier<List<Map<String, Object>>> ... hostAliasesYAMLFormatSuppliers) {
        return this.install(Arrays.asList(hostAliasesYAMLFormatSuppliers));
    }

    public HostNameForIPMapper install(Collection<Supplier<List<Map<String, Object>>>> hostAliasesYAMLFormatSuppliers) {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>();
        for (Supplier<List<Map<String, Object>>> hostAliasesYAMLFormatSupplier : hostAliasesYAMLFormatSuppliers) {
            for (Map<String, Object> addressesForIp : hostAliasesYAMLFormatSupplier.get()) {
                Collection hostNames = (Collection)addressesForIp.get("hostnames");
                String iPAddress = (String)addressesForIp.get("ip");
                for (String hostName : hostNames) {
                    hostAliases.put(hostName, iPAddress);
                }
            }
        }
        return this.install(hostAliases);
    }

    public HostNameForIPMapper install(Map<String, String> hostAliases) {
        hostAliases = new LinkedHashMap<String, String>(hostAliases);
        List<Object> proxy = Collection.class.isAssignableFrom(nameServiceFieldClass) ? Arrays.asList(this.buildProxy(hostAliases, nameServiceClass, nameServices)) : this.buildProxy(hostAliases, nameServiceClass, nameServices);
        StaticComponentContainer.Fields.setStaticDirect(inetAddressClass, nameServiceField.getName(), proxy);
        return this;
    }

    private Object buildProxy(Map<String, String> hostAliases, Class<?> nameServiceClass, Collection<Object> targets) {
        return Proxy.newProxyInstance(nameServiceClass.getClassLoader(), new Class[]{nameServiceClass}, this.buildInvocationHandler(hostAliases, targets));
    }

    private InvocationHandler buildInvocationHandler(Map<String, String> hostAliases, Collection<Object> targets) {
        return (prx, method, args) -> {
            String methodName = method.getName();
            if (methodName.equals("lookupAllHostAddr") || methodName.equals("lookupByName")) {
                return this.getAllAddressesForHostName(hostAliases, targets, method, args);
            }
            if (method.getName().equals("getHostByAddr") || method.getName().equals("lookupByAddress")) {
                return this.getAllAddressesForHostAddress(hostAliases, targets, method, args).iterator().next();
            }
            Object toRet = null;
            for (Object object : targets) {
                if (object == null || (toRet = MethodHandles.lookup().unreflect(method).bindTo(object).invokeWithArguments(args)) == null) continue;
                return toRet;
            }
            return null;
        };
    }

    private Object getAllAddressesForHostName(Map<String, String> hostAliases, Collection<?> targets, Method method, Object ... args) throws Throwable {
        ArrayList<InetAddress> addresses;
        String hostName;
        block7: {
            hostName = (String)args[0];
            addresses = new ArrayList<InetAddress>();
            String iPAddress = hostAliases.get(hostName);
            if (iPAddress != null) {
                addresses.add(InetAddress.getByAddress(hostName, IPAddressUtil.INSTANCE.textToNumericFormat(iPAddress)));
            }
            Function<Object, Stream> inetAddressSupplier = method.getReturnType().equals(InetAddress[].class) ? obj -> Stream.of((InetAddress[])obj) : obj -> (Stream)obj;
            Iterator<?> iterator = targets.iterator();
            while (true) {
                Object nameService;
                if ((nameService = iterator.next()) == null) {
                    continue;
                }
                Object inetAddresses = StaticComponentContainer.Methods.invokeDirect(nameService, method.getName(), args);
                if (inetAddresses == null) continue;
                inetAddressSupplier.apply(inetAddresses).forEach(addresses::add);
                continue;
                break;
            }
            finally {
                if (!iterator.hasNext()) break block7;
            }
        }
        if (addresses.isEmpty()) {
            throw new UnknownHostException(hostName);
        }
        return method.getReturnType().equals(InetAddress[].class) ? addresses.toArray(new InetAddress[addresses.size()]) : addresses.stream();
    }

    private Collection<String> getAllAddressesForHostAddress(Map<String, String> hostAliases, Collection<?> nameServices, Method method, Object ... args) throws Throwable {
        ArrayList<String> hostNames;
        byte[] address;
        block7: {
            address = (byte[])args[0];
            hostNames = new ArrayList<String>();
            String iPAddress = IPAddressUtil.INSTANCE.numericToTextFormat(address);
            for (Map.Entry<String, String> addressForIp : hostAliases.entrySet()) {
                if (!addressForIp.getValue().equals(iPAddress)) continue;
                hostNames.add(addressForIp.getKey());
            }
            Iterator<Map.Entry<String, String>> iterator = nameServices.iterator();
            while (true) {
                Map.Entry<String, String> nameService;
                if ((nameService = iterator.next()) == null) {
                    continue;
                }
                String hostName = (String)StaticComponentContainer.Methods.invokeDirect(nameService, method.getName(), args);
                if (hostName == null) continue;
                hostNames.add(hostName);
                continue;
                break;
            }
            finally {
                if (!iterator.hasNext()) break block7;
            }
        }
        if (hostNames.isEmpty()) {
            throw new UnknownHostException(IPAddressUtil.INSTANCE.numericToTextFormat(address));
        }
        return hostNames;
    }

    static {
        inetAddressClass = InetAddress.class;
        nameServiceField = (Field)StaticComponentContainer.Fields.findFirst((MemberCriteria)((FieldCriteria)FieldCriteria.withoutConsideringParentClasses().name(fieldName -> fieldName.equals("nameService") || fieldName.equals("nameServices") || fieldName.equals("resolver"))), inetAddressClass);
        StaticComponentContainer.Fields.setAccessible((Member)nameServiceField, true);
        nameServiceFieldClass = nameServiceField.getType();
        nameServiceClass = HostNameForIPMapper.getNameServiceFieldClass(nameServiceField);
        nameServices = HostNameForIPMapper.getNameServices();
        INSTANCE = new HostNameForIPMapper();
    }
}

