/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dns;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.tools.dns.DefaultHostResolver;
import org.burningwave.tools.dns.IPAddressUtil;

public class HostResolverService {
    public static final HostResolverService INSTANCE = new HostResolverService();
    private Collection<Resolver> resolvers;
    private Map<?, ?> cache = (Map)StaticComponentContainer.Fields.getStaticDirect(StaticComponentContainer.Fields.findFirstAndMakeItAccessible(DefaultHostResolver.inetAddressClass, "cache", ConcurrentMap.class));
    private Set<?> expirySet = (Set)StaticComponentContainer.Fields.getStaticDirect(StaticComponentContainer.Fields.findFirstAndMakeItAccessible(DefaultHostResolver.inetAddressClass, "expirySet", NavigableSet.class));

    private HostResolverService() {
    }

    public HostResolverService install(Resolver ... resolvers) {
        this.resolvers = this.checkResolvers(resolvers);
        ArrayList<Object> proxy = Collection.class.isAssignableFrom(DefaultHostResolver.nameServiceFieldClass) ? new ArrayList<Object>(Arrays.asList(this.buildProxy())) : this.buildProxy();
        StaticComponentContainer.Fields.setStaticDirect(DefaultHostResolver.inetAddressClass, DefaultHostResolver.nameServiceField.getName(), (Object)proxy);
        return this;
    }

    public HostResolverService reset() {
        Object nameServices = Collection.class.isAssignableFrom(DefaultHostResolver.nameServiceFieldClass) ? DefaultHostResolver.nameServices : DefaultHostResolver.nameServices.iterator().next();
        StaticComponentContainer.Fields.setStaticDirect(DefaultHostResolver.inetAddressClass, DefaultHostResolver.nameServiceField.getName(), nameServices);
        this.cache.clear();
        this.expirySet.clear();
        return this;
    }

    private Collection<Resolver> checkResolvers(Resolver[] resolvers) {
        if (resolvers == null || resolvers.length < 1) {
            throw new IllegalArgumentException("Resolvers are required");
        }
        ArrayList<Resolver> resolverList = new ArrayList<Resolver>();
        for (int index = 0; index < resolvers.length; ++index) {
            if (resolvers[index] == null) {
                throw new IllegalArgumentException(StaticComponentContainer.Strings.compile("Resolver at index [{}] is null", new Object[]{index}));
            }
            resolverList.add(resolvers[index]);
        }
        return resolverList;
    }

    private Object buildProxy() {
        return Proxy.newProxyInstance(DefaultHostResolver.nameServiceClass.getClassLoader(), new Class[]{DefaultHostResolver.nameServiceClass}, this.buildInvocationHandler());
    }

    private InvocationHandler buildInvocationHandler() {
        return (prx, method, args) -> {
            String methodName = method.getName();
            if (methodName.equals(DefaultHostResolver.getAllAddressesForHostNameMethod.getName())) {
                return this.getAllAddressesForHostName(args);
            }
            if (methodName.equals(DefaultHostResolver.getAllHostNamesForHostAddress.getName())) {
                return this.getAllAddressesForHostAddress(args).iterator().next();
            }
            for (Resolver resolver : this.resolvers) {
                Object toRet = resolver.handle(method, args);
                if (toRet == null) continue;
                return toRet;
            }
            throw new UnsupportedOperationException(method.getName() + " is not supported");
        };
    }

    private Object getAllAddressesForHostName(Object ... args) throws Throwable {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (Resolver resolver : this.resolvers) {
            addresses.addAll(resolver.getAllAddressesForHostName(args));
        }
        if (addresses.isEmpty()) {
            throw new UnknownHostException((String)args[0]);
        }
        return DefaultHostResolver.getAllAddressesForHostNameMethod.getReturnType().equals(InetAddress[].class) ? addresses.toArray(new InetAddress[addresses.size()]) : addresses.stream();
    }

    private Collection<String> getAllAddressesForHostAddress(Object ... args) throws Throwable {
        ArrayList<String> hostNames = new ArrayList<String>();
        for (Resolver resolver : this.resolvers) {
            hostNames.addAll(resolver.getAllHostNamesForHostAddress(args));
        }
        if (hostNames.isEmpty()) {
            throw new UnknownHostException(IPAddressUtil.INSTANCE.numericToTextFormat((byte[])args[0]));
        }
        return hostNames;
    }

    public static interface Resolver {
        public Collection<InetAddress> getAllAddressesForHostName(Object ... var1);

        public Collection<String> getAllHostNamesForHostAddress(Object ... var1);

        default public Object handle(Method method, Object ... arguments) throws Throwable {
            throw new UnsupportedOperationException(method.getName() + " is not supported");
        }
    }
}

