/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import org.burningwave.tools.dns.HostResolverService;
import org.burningwave.tools.dns.IPAddressUtil;

public class MappedHostResolver
implements HostResolverService.Resolver {
    Map<String, String> hostAliases;

    @SafeVarargs
    public MappedHostResolver(Supplier<List<Map<String, Object>>> ... hostAliasesYAMLFormatSuppliers) {
        this(Arrays.asList(hostAliasesYAMLFormatSuppliers));
    }

    public MappedHostResolver(Collection<Supplier<List<Map<String, Object>>>> hostAliasesYAMLFormatSuppliers) {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>();
        for (Supplier<List<Map<String, Object>>> hostAliasesYAMLFormatSupplier : hostAliasesYAMLFormatSuppliers) {
            for (Map<String, Object> addressesForIp : hostAliasesYAMLFormatSupplier.get()) {
                String iPAddress = (String)addressesForIp.get("ip");
                Collection hostNames = (Collection)addressesForIp.get("hostnames");
                for (String hostName : hostNames) {
                    hostAliases.put(hostName, iPAddress);
                }
            }
        }
        this.hostAliases = hostAliases;
    }

    public MappedHostResolver(Map<String, String> hostAliases) {
        this.hostAliases = new LinkedHashMap<String, String>(hostAliases);
    }

    @Override
    public Collection<InetAddress> getAllAddressesForHostName(Object ... arguments) {
        String hostName = (String)arguments[0];
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        String iPAddress = this.hostAliases.get(hostName);
        if (iPAddress != null) {
            try {
                addresses.add(InetAddress.getByAddress(hostName, IPAddressUtil.INSTANCE.textToNumericFormat(iPAddress)));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return addresses;
    }

    @Override
    public Collection<String> getAllHostNamesForHostAddress(Object ... arguments) {
        byte[] address = (byte[])arguments[0];
        ArrayList<String> hostNames = new ArrayList<String>();
        String iPAddress = IPAddressUtil.INSTANCE.numericToTextFormat(address);
        for (Map.Entry<String, String> addressForIp : this.hostAliases.entrySet()) {
            if (!addressForIp.getValue().equals(iPAddress)) continue;
            hostNames.add(addressForIp.getKey());
        }
        return hostNames;
    }

    public synchronized MappedHostResolver putHost(String hostname, String iP) {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>(this.hostAliases);
        hostAliases.put(hostname, iP);
        this.hostAliases = hostAliases;
        return this;
    }

    public synchronized MappedHostResolver removeHost(String hostname) {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>(this.hostAliases);
        hostAliases.remove(hostname);
        this.hostAliases = hostAliases;
        return this;
    }

    public synchronized MappedHostResolver removeHostForIP(String iP) {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>(this.hostAliases);
        Iterator hostAliasesIterator = hostAliases.entrySet().iterator();
        while (hostAliasesIterator.hasNext()) {
            Map.Entry host = hostAliasesIterator.next();
            if (!((String)host.getValue()).equals(iP)) continue;
            hostAliasesIterator.remove();
        }
        this.hostAliases = hostAliases;
        return this;
    }

    @Override
    public boolean isReady(HostResolverService hostResolverService) {
        boolean isReady = HostResolverService.Resolver.super.isReady(hostResolverService);
        if (isReady) {
            String hostNameForTest = UUID.randomUUID().toString();
            this.putHost(hostNameForTest, "127.0.0.1");
            isReady = this.hostAliases.keySet().stream().filter(Objects::nonNull).findFirst().map(hostName -> {
                try {
                    return InetAddress.getByName(hostNameForTest);
                }
                catch (UnknownHostException exc) {
                    return null;
                }
            }).isPresent();
            this.removeHost(hostNameForTest);
        }
        return isReady;
    }
}

