/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dns;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.FieldCriteria;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.tools.dns.DefaultHostResolver;
import org.burningwave.tools.dns.IPAddressUtil;
import org.burningwave.tools.dns.MappedHostResolver;

public class HostResolverService {
    public static final HostResolverService INSTANCE;
    private static final Function<HostResolverService, Object> proxySupplier;
    private static final Function<Collection<InetAddress>, Object> getAllAddressesForHostNameResultConverter;
    private static Object cacheOne;
    private static Object cacheTwo;
    Collection<Resolver> resolvers;

    private HostResolverService() {
    }

    public HostResolverService install(Resolver ... resolvers) {
        return this.install(-1L, 250L, resolvers);
    }

    public synchronized HostResolverService install(long timeout, long sleepingTime, Resolver ... resolvers) {
        this.resolvers = this.checkResolvers(resolvers);
        StaticComponentContainer.Fields.setStaticDirect(DefaultHostResolver.nameServiceField, proxySupplier.apply(this));
        this.resolvers.stream().filter(MappedHostResolver.class::isInstance).findFirst().map(MappedHostResolver.class::cast).ifPresent(hostResolver -> {
            Long startTime = System.currentTimeMillis();
            Long expirationTime = startTime + timeout;
            while (!(hostResolver.isReady(this) || timeout >= 0L && expirationTime <= System.currentTimeMillis())) {
                try {
                    Thread.sleep(sleepingTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        return this;
    }

    public HostResolverService reset() {
        Object nameServices = Collection.class.isAssignableFrom(DefaultHostResolver.nameServiceFieldClass) ? DefaultHostResolver.nameServices : DefaultHostResolver.nameServices.iterator().next();
        StaticComponentContainer.Fields.setStaticDirect(DefaultHostResolver.nameServiceField, nameServices);
        this.clearCache();
        return this;
    }

    public void clearCache() {
        StaticComponentContainer.Methods.invokeDirect(cacheOne, "clear", new Object[0]);
        StaticComponentContainer.Methods.invokeDirect(cacheTwo, "clear", new Object[0]);
    }

    private Collection<Resolver> checkResolvers(Resolver[] resolvers) {
        if (resolvers == null || resolvers.length < 1) {
            throw new IllegalArgumentException("Resolvers are required");
        }
        ArrayList<Resolver> resolverList = new ArrayList<Resolver>();
        for (int index = 0; index < resolvers.length; ++index) {
            if (resolvers[index] == null) {
                throw new IllegalArgumentException(StaticComponentContainer.Strings.compile("Resolver at index [{}] is null", new Object[]{index}));
            }
            resolverList.add(resolvers[index]);
        }
        return resolverList;
    }

    private List<Object> buildProxies() {
        ArrayList<Object> proxies = new ArrayList<Object>();
        for (Resolver resolver : this.resolvers) {
            if (resolver instanceof DefaultHostResolver) {
                for (Object nameService : DefaultHostResolver.nameServices) {
                    proxies.add(Proxy.newProxyInstance(DefaultHostResolver.nameServiceClass.getClassLoader(), new Class[]{DefaultHostResolver.nameServiceClass}, this.buildOneToOneInvocationHandler(resolver, nameService)));
                }
                continue;
            }
            proxies.add(Proxy.newProxyInstance(DefaultHostResolver.nameServiceClass.getClassLoader(), new Class[]{DefaultHostResolver.nameServiceClass}, this.buildOneToOneInvocationHandler(resolver, null)));
        }
        return proxies;
    }

    public InvocationHandler buildOneToOneInvocationHandler(Resolver resolver, Object nameService) {
        Function<Object[], Map> argumentsMapBuilder = nameService != null ? arguments -> {
            Map<String, Object> argumentsMap = this.buildArgumentsMap((Object[])arguments);
            argumentsMap.put("nameServices", Arrays.asList(nameService));
            return argumentsMap;
        } : this::buildArgumentsMap;
        return (proxy, method, arguments) -> {
            String methodName = method.getName();
            if (methodName.equals(DefaultHostResolver.getAllAddressesForHostNameMethod.getName())) {
                return getAllAddressesForHostNameResultConverter.apply(resolver.checkAndGetAllAddressesForHostName((Map)argumentsMapBuilder.apply(arguments)));
            }
            if (methodName.equals(DefaultHostResolver.getAllHostNamesForHostAddressMethod.getName())) {
                return resolver.checkAndGgetAllHostNamesForHostAddress((Map)argumentsMapBuilder.apply(arguments)).iterator().next();
            }
            Object toRet = resolver.handle(method, arguments);
            if (toRet != null) {
                return toRet;
            }
            throw new UnsupportedOperationException(method.getName() + " is not supported");
        };
    }

    private Object buildProxy() {
        return Proxy.newProxyInstance(DefaultHostResolver.nameServiceClass.getClassLoader(), new Class[]{DefaultHostResolver.nameServiceClass}, (proxy, method, arguments) -> {
            String methodName = method.getName();
            if (methodName.equals(DefaultHostResolver.getAllAddressesForHostNameMethod.getName())) {
                return this.getAllAddressesForHostName(arguments);
            }
            if (methodName.equals(DefaultHostResolver.getAllHostNamesForHostAddressMethod.getName())) {
                return this.getAllHostNamesForHostAddress(arguments).iterator().next();
            }
            for (Resolver resolver : this.resolvers) {
                Object toRet = resolver.handle(method, arguments);
                if (toRet == null) continue;
                return toRet;
            }
            throw new UnsupportedOperationException(method.getName() + " is not supported");
        });
    }

    private Object getAllAddressesForHostName(Object ... args) throws Throwable {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Map<String, Object> argumentsMap = this.buildArgumentsMap(args);
        for (Resolver resolver : this.resolvers) {
            try {
                addresses.addAll(resolver.checkAndGetAllAddressesForHostName(argumentsMap));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        if (addresses.isEmpty()) {
            throw new UnknownHostException((String)args[0]);
        }
        return getAllAddressesForHostNameResultConverter.apply(addresses);
    }

    public Map<String, Object> buildArgumentsMap(Object[] args) {
        LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>();
        arguments.put("methodArguments", args);
        return arguments;
    }

    private Collection<String> getAllHostNamesForHostAddress(Object ... args) throws Throwable {
        ArrayList<String> hostNames = new ArrayList<String>();
        Map<String, Object> argumentsMap = this.buildArgumentsMap(args);
        for (Resolver resolver : this.resolvers) {
            try {
                hostNames.addAll(resolver.checkAndGgetAllHostNamesForHostAddress(argumentsMap));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        if (hostNames.isEmpty()) {
            throw new UnknownHostException(IPAddressUtil.INSTANCE.numericToTextFormat((byte[])args[0]));
        }
        return hostNames;
    }

    static {
        proxySupplier = Collection.class.isAssignableFrom(DefaultHostResolver.nameServiceFieldClass) ? HostResolverService::buildProxies : HostResolverService::buildProxy;
        Field cacheOneField = (Field)StaticComponentContainer.Fields.findOne((MemberCriteria)((FieldCriteria)FieldCriteria.withoutConsideringParentClasses().name(fieldName -> fieldName.equals("cache") || fieldName.equals("addressCache"))), DefaultHostResolver.inetAddressClass);
        if (cacheOneField.getName().equals("addressCache")) {
            cacheOne = StaticComponentContainer.Fields.getDirect(StaticComponentContainer.Fields.getStaticDirect(cacheOneField), "cache");
            cacheTwo = StaticComponentContainer.Fields.getDirect(StaticComponentContainer.Fields.getStaticDirect(DefaultHostResolver.inetAddressClass, "negativeCache"), "cache");
        } else {
            cacheOne = StaticComponentContainer.Fields.getStaticDirect(DefaultHostResolver.inetAddressClass, "cache");
            cacheTwo = StaticComponentContainer.Fields.getStaticDirect(DefaultHostResolver.inetAddressClass, "expirySet");
        }
        getAllAddressesForHostNameResultConverter = DefaultHostResolver.getAllAddressesForHostNameMethod.getReturnType().equals(InetAddress[].class) ? addresses -> addresses.toArray(new InetAddress[addresses.size()]) : addresses -> addresses.stream();
        INSTANCE = new HostResolverService();
    }

    public static interface Resolver {
        default public Collection<InetAddress> checkAndGetAllAddressesForHostName(Map<String, Object> argumentsMap) throws UnknownHostException {
            String hostName = (String)this.getMethodArguments(argumentsMap)[0];
            Collection<InetAddress> addresses = this.getAllAddressesForHostName(argumentsMap);
            if (addresses.isEmpty()) {
                throw new UnknownHostException(hostName);
            }
            return addresses;
        }

        default public Collection<String> checkAndGgetAllHostNamesForHostAddress(Map<String, Object> argumentsMap) throws UnknownHostException {
            byte[] address = (byte[])this.getMethodArguments(argumentsMap)[0];
            Collection<String> hostNames = this.getAllHostNamesForHostAddress(argumentsMap);
            if (hostNames.isEmpty()) {
                throw new UnknownHostException(IPAddressUtil.INSTANCE.numericToTextFormat(address));
            }
            return hostNames;
        }

        public Collection<InetAddress> getAllAddressesForHostName(Map<String, Object> var1);

        public Collection<String> getAllHostNamesForHostAddress(Map<String, Object> var1);

        default public boolean isReady(HostResolverService hostResolverService) {
            return hostResolverService.resolvers.contains(this);
        }

        default public Object handle(Method method, Object ... arguments) throws Throwable {
            throw new UnsupportedOperationException(method.getName() + " is not supported");
        }

        default public Object[] getMethodArguments(Map<String, Object> arguments) {
            return (Object[])arguments.get("methodArguments");
        }
    }
}

