/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dns;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import org.burningwave.tools.dns.HostResolutionRequestInterceptor;
import org.burningwave.tools.dns.IPAddressUtil;

public interface HostResolver {
    default public Collection<InetAddress> checkAndGetAllAddressesForHostName(Map<String, Object> argumentsMap) throws UnknownHostException {
        String hostName = (String)this.getMethodArguments(argumentsMap)[0];
        Collection<InetAddress> addresses = this.getAllAddressesForHostName(argumentsMap);
        if (addresses.isEmpty()) {
            throw new UnknownHostException(hostName);
        }
        return addresses;
    }

    default public Collection<String> checkAndGgetAllHostNamesForHostAddress(Map<String, Object> argumentsMap) throws UnknownHostException {
        byte[] address = (byte[])this.getMethodArguments(argumentsMap)[0];
        Collection<String> hostNames = this.getAllHostNamesForHostAddress(argumentsMap);
        if (hostNames.isEmpty()) {
            throw new UnknownHostException(IPAddressUtil.INSTANCE.numericToTextFormat(address));
        }
        return hostNames;
    }

    public Collection<InetAddress> getAllAddressesForHostName(Map<String, Object> var1);

    public Collection<String> getAllHostNamesForHostAddress(Map<String, Object> var1);

    default public boolean isReady(HostResolutionRequestInterceptor hostResolverService) {
        return hostResolverService.resolvers.contains(this);
    }

    default public Object handle(Method method, Object ... arguments) throws Throwable {
        throw new UnsupportedOperationException(method.getName() + " is not supported");
    }

    default public Object[] getMethodArguments(Map<String, Object> arguments) {
        return (Object[])arguments.get("methodArguments");
    }
}

