/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dependencies;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.burningwave.core.Strings;
import org.burningwave.core.classes.ClassHelper;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.function.TriConsumer;
import org.burningwave.core.io.FileScanConfig;
import org.burningwave.core.io.FileSystemHelper;
import org.burningwave.core.io.FileSystemItem;

public class Sniffer
extends MemoryClassLoader {
    private Function<JavaClass, Boolean> javaClassFilterAndAdder;
    private Function<FileSystemItem, Boolean> resourceFilterAndAdder;
    private Map<String, FileSystemItem> resources;
    private Map<String, JavaClass> javaClasses;
    private TriConsumer<String, String, ByteBuffer> resourcesConsumer;
    ClassLoader mainClassLoader = Thread.currentThread().getContextClassLoader();

    protected Sniffer(boolean useAsMasterClassLoader, FileSystemHelper fileSystemHelper, ClassHelper classHelper, Collection<String> baseClassPaths, Function<JavaClass, Boolean> javaClassAdder, Function<FileSystemItem, Boolean> resourceAdder, TriConsumer<String, String, ByteBuffer> resourcesConsumer) {
        super(null, classHelper);
        this.javaClassFilterAndAdder = javaClassAdder;
        this.resourceFilterAndAdder = resourceAdder;
        this.resourcesConsumer = resourcesConsumer;
        this.resources = new ConcurrentHashMap<String, FileSystemItem>();
        this.javaClasses = new ConcurrentHashMap<String, JavaClass>();
        fileSystemHelper.scan(FileScanConfig.forPaths(baseClassPaths).toScanConfiguration(this.getMapStorer()));
        if (useAsMasterClassLoader) {
            classHelper.setMasterClassLoader(Thread.currentThread().getContextClassLoader(), (ClassLoader)((Object)this));
        } else {
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this));
        }
    }

    public synchronized void addCompiledClass(String className, ByteBuffer byteCode) {
        super.addCompiledClass(className, byteCode);
    }

    Consumer<FileSystemHelper.Scan.ItemContext> getMapStorer() {
        return scannedItemContext -> {
            String absolutePath = scannedItemContext.getScannedItem().getAbsolutePath();
            this.resources.put(absolutePath, FileSystemItem.ofPath((String)absolutePath));
            if (absolutePath.endsWith(".class")) {
                JavaClass javaClass = JavaClass.create((ByteBuffer)scannedItemContext.getScannedItem().toByteBuffer());
                this.addCompiledClass(javaClass.getName(), javaClass.getByteCode());
                this.javaClasses.put(absolutePath, javaClass);
            }
        };
    }

    protected Collection<JavaClass> consumeClass(String className) {
        return this.consumeClasses(Arrays.asList(className));
    }

    public Collection<JavaClass> consumeClasses(Collection<String> currentNotFoundClasses) {
        LinkedHashSet<JavaClass> javaClassesFound = new LinkedHashSet<JavaClass>();
        for (Map.Entry<String, JavaClass> entry : this.javaClasses.entrySet()) {
            JavaClass javaClass;
            if (!currentNotFoundClasses.contains(entry.getValue().getName()) || !this.javaClassFilterAndAdder.apply(javaClass = entry.getValue()).booleanValue()) continue;
            this.resourcesConsumer.accept((Object)entry.getKey(), (Object)javaClass.getPath(), (Object)javaClass.getByteCode());
            javaClassesFound.add(javaClass);
        }
        return javaClassesFound;
    }

    protected Collection<FileSystemItem> consumeResource(String relativePath, boolean breakWhenFound) {
        LinkedHashSet<FileSystemItem> founds = new LinkedHashSet<FileSystemItem>();
        if (Strings.isNotEmpty((String)relativePath)) {
            for (Map.Entry<String, FileSystemItem> entry : this.resources.entrySet()) {
                if (!entry.getValue().getAbsolutePath().endsWith(relativePath)) continue;
                FileSystemItem fileSystemItem = entry.getValue();
                founds.add(fileSystemItem);
                if (this.resourceFilterAndAdder.apply(fileSystemItem).booleanValue()) {
                    this.resourcesConsumer.accept((Object)entry.getKey(), (Object)relativePath, (Object)fileSystemItem.toByteBuffer());
                }
                if (!breakWhenFound) continue;
                break;
            }
        }
        return founds;
    }

    public void addLoadedCompiledClass(String className, ByteBuffer byteCode) {
        super.addLoadedCompiledClass(className, byteCode);
        this.consumeClass(className);
    }

    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class cls = super.loadClass(className, resolve);
        this.consumeClass(className);
        return cls;
    }

    public URL getResource(String name) {
        Enumeration<URL> urls = this.getResources(name, true);
        if (urls.hasMoreElements()) {
            return urls.nextElement();
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getResources(name, false);
    }

    private Enumeration<URL> getResources(String name, boolean findFirst) {
        return Collections.enumeration(this.consumeResource(name, findFirst).stream().map(fileSystemItem -> {
            this.resourceFilterAndAdder.apply((FileSystemItem)fileSystemItem);
            return fileSystemItem.getURL();
        }).collect(Collectors.toSet()));
    }

    public InputStream getResourceAsStream(String name) {
        FileSystemItem fileSystemItem = this.consumeResource(name, true).stream().findFirst().orElseGet(() -> null);
        if (fileSystemItem != null) {
            return fileSystemItem.toInputStream();
        }
        return this.getLoadedCompiledClassesAsInputStream(name);
    }

    public void close() {
        if (this.mainClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.mainClassLoader);
        }
        this.resources.clear();
        this.javaClasses.clear();
        this.javaClassFilterAndAdder = null;
        this.resourceFilterAndAdder = null;
        this.mainClassLoader = null;
        this.clear();
        this.classHelper.unregister((ClassLoader)((Object)this));
    }
}

