/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.burningwave.tools.net.HostResolutionRequestInterceptor;
import org.burningwave.tools.net.HostResolver;
import org.burningwave.tools.net.IPAddressUtil;

public class MappedHostResolver
implements HostResolver {
    protected Map<String, String> hostAliases;

    @SafeVarargs
    public MappedHostResolver(Supplier<List<Map<String, Object>>> ... hostAliasesYAMLFormatSuppliers) {
        this(Arrays.asList(hostAliasesYAMLFormatSuppliers));
    }

    public MappedHostResolver(Collection<Supplier<List<Map<String, Object>>>> hostAliasesYAMLFormatSuppliers) {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>();
        for (Supplier<List<Map<String, Object>>> hostAliasesYAMLFormatSupplier : hostAliasesYAMLFormatSuppliers) {
            for (Map<String, Object> addressesForIp : hostAliasesYAMLFormatSupplier.get()) {
                String iPAddress = (String)addressesForIp.get("ip");
                Collection hostNames = (Collection)addressesForIp.get("hostnames");
                for (String hostName : hostNames) {
                    hostAliases.put(hostName, iPAddress);
                }
            }
        }
        this.hostAliases = hostAliases;
    }

    public MappedHostResolver(Map<String, String> hostAliases) {
        this.hostAliases = new LinkedHashMap<String, String>(hostAliases);
    }

    @Override
    public Collection<InetAddress> getAllAddressesForHostName(Map<String, Object> argumentsMap) {
        String hostName = (String)this.getMethodArguments(argumentsMap)[0];
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        String iPAddress = this.hostAliases.get(hostName);
        if (iPAddress != null) {
            try {
                addresses.add(InetAddress.getByAddress(hostName, IPAddressUtil.INSTANCE.textToNumericFormat(iPAddress)));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return addresses;
    }

    @Override
    public Collection<String> getAllHostNamesForHostAddress(Map<String, Object> argumentsMap) {
        byte[] address = (byte[])this.getMethodArguments(argumentsMap)[0];
        ArrayList<String> hostNames = new ArrayList<String>();
        String iPAddress = IPAddressUtil.INSTANCE.numericToTextFormat(address);
        for (Map.Entry<String, String> addressForIp : this.hostAliases.entrySet()) {
            if (!addressForIp.getValue().equals(iPAddress)) continue;
            hostNames.add(addressForIp.getKey());
        }
        return hostNames;
    }

    public synchronized MappedHostResolver putHost(String hostname, String iP) {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>(this.hostAliases);
        hostAliases.put(hostname, iP);
        this.hostAliases = hostAliases;
        return this;
    }

    public synchronized MappedHostResolver removeHost(String hostname) {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>(this.hostAliases);
        hostAliases.remove(hostname);
        this.hostAliases = hostAliases;
        return this;
    }

    public synchronized MappedHostResolver removeHostForIP(String iP) {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>(this.hostAliases);
        Iterator hostAliasesIterator = hostAliases.entrySet().iterator();
        while (hostAliasesIterator.hasNext()) {
            Map.Entry host = hostAliasesIterator.next();
            if (!((String)host.getValue()).equals(iP)) continue;
            hostAliasesIterator.remove();
        }
        this.hostAliases = hostAliases;
        return this;
    }

    @Override
    public boolean isReady(HostResolutionRequestInterceptor hostResolverService) {
        return HostResolver.super.isReady(hostResolverService) && this.obtainsResponseForMappedHost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean obtainsResponseForMappedHost() {
        String hostNameForTest = null;
        if (this.hostAliases.isEmpty()) {
            hostNameForTest = UUID.randomUUID().toString();
            this.putHost(hostNameForTest, "127.0.0.1");
        }
        try {
            for (String hostname : this.hostAliases.keySet()) {
                InetAddress.getByName(hostname);
            }
            boolean bl = true;
            return bl;
        }
        catch (UnknownHostException exc) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (hostNameForTest != null) {
                this.removeHost(hostNameForTest);
            }
        }
    }
}

