/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.net;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.FieldCriteria;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.tools.net.DefaultHostResolver;
import org.burningwave.tools.net.HostResolver;
import org.burningwave.tools.net.IPAddressUtil;
import org.burningwave.tools.net.MappedHostResolver;

public class HostResolutionRequestInterceptor {
    public static final HostResolutionRequestInterceptor INSTANCE;
    private static final Function<HostResolutionRequestInterceptor, Object> proxySupplier;
    private static final Function<Collection<InetAddress>, Object> getAllAddressesForHostNameResultConverter;
    private static Object cacheOne;
    private static Object cacheTwo;
    Collection<HostResolver> resolvers;

    private HostResolutionRequestInterceptor() {
    }

    public HostResolutionRequestInterceptor install(HostResolver ... resolvers) {
        return this.install(-1L, 250L, resolvers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostResolutionRequestInterceptor install(long timeout, long sleepingTime, HostResolver ... resolvers) {
        this.resolvers = this.checkResolvers(resolvers);
        List<Object> list = DefaultHostResolver.nameServices;
        synchronized (list) {
            StaticComponentContainer.Fields.setStaticDirect(DefaultHostResolver.nameServiceField, proxySupplier.apply(this));
        }
        this.resolvers.stream().filter(MappedHostResolver.class::isInstance).findFirst().map(MappedHostResolver.class::cast).ifPresent(hostResolver -> {
            Long startTime = System.currentTimeMillis();
            Long expirationTime = startTime + timeout;
            while (!(hostResolver.isReady(this) || timeout >= 0L && expirationTime <= System.currentTimeMillis())) {
                try {
                    Thread.sleep(sleepingTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostResolutionRequestInterceptor uninstall() {
        Object nameServices = Collection.class.isAssignableFrom(DefaultHostResolver.nameServiceFieldClass) ? DefaultHostResolver.nameServices : DefaultHostResolver.nameServices.iterator().next();
        List<Object> list = DefaultHostResolver.nameServices;
        synchronized (list) {
            StaticComponentContainer.Fields.setStaticDirect(DefaultHostResolver.nameServiceField, nameServices);
            this.clearCache();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        List<Object> list = DefaultHostResolver.nameServices;
        synchronized (list) {
            StaticComponentContainer.Methods.invokeDirect(cacheOne, "clear", new Object[0]);
            StaticComponentContainer.Methods.invokeDirect(cacheTwo, "clear", new Object[0]);
        }
    }

    private Collection<HostResolver> checkResolvers(HostResolver[] resolvers) {
        if (resolvers == null || resolvers.length < 1) {
            throw new IllegalArgumentException("Resolvers are required");
        }
        ArrayList<HostResolver> resolverList = new ArrayList<HostResolver>();
        for (int index = 0; index < resolvers.length; ++index) {
            if (resolvers[index] == null) {
                throw new IllegalArgumentException(StaticComponentContainer.Strings.compile("Resolver at index [{}] is null", new Object[]{index}));
            }
            resolverList.add(resolvers[index]);
        }
        return resolverList;
    }

    private List<Object> buildProxies() {
        ArrayList<Object> proxies = new ArrayList<Object>();
        for (HostResolver resolver : this.resolvers) {
            if (resolver instanceof DefaultHostResolver) {
                for (Object nameService : DefaultHostResolver.nameServices) {
                    proxies.add(Proxy.newProxyInstance(DefaultHostResolver.nameServiceClass.getClassLoader(), new Class[]{DefaultHostResolver.nameServiceClass}, this.buildOneToOneInvocationHandler(resolver, nameService)));
                }
                continue;
            }
            proxies.add(Proxy.newProxyInstance(DefaultHostResolver.nameServiceClass.getClassLoader(), new Class[]{DefaultHostResolver.nameServiceClass}, this.buildOneToOneInvocationHandler(resolver, null)));
        }
        return proxies;
    }

    public InvocationHandler buildOneToOneInvocationHandler(HostResolver resolver, Object nameService) {
        Function<Object[], Map> argumentsMapBuilder = nameService != null ? arguments -> {
            Map<String, Object> argumentsMap = this.buildArgumentsMap((Object[])arguments);
            argumentsMap.put("nameServices", Arrays.asList(nameService));
            return argumentsMap;
        } : this::buildArgumentsMap;
        return (proxy, method, arguments) -> {
            String methodName = method.getName();
            if (methodName.equals(DefaultHostResolver.getAllAddressesForHostNameMethod.getName())) {
                return getAllAddressesForHostNameResultConverter.apply(resolver.checkAndGetAllAddressesForHostName((Map)argumentsMapBuilder.apply(arguments)));
            }
            if (methodName.equals(DefaultHostResolver.getAllHostNamesForHostAddressMethod.getName())) {
                return resolver.checkAndGetAllHostNamesForHostAddress((Map)argumentsMapBuilder.apply(arguments)).iterator().next();
            }
            Object toRet = resolver.handle(method, arguments);
            if (toRet != null) {
                return toRet;
            }
            throw new UnsupportedOperationException(method.getName() + " is not supported");
        };
    }

    private Object buildProxy() {
        return Proxy.newProxyInstance(DefaultHostResolver.nameServiceClass.getClassLoader(), new Class[]{DefaultHostResolver.nameServiceClass}, (proxy, method, arguments) -> {
            String methodName = method.getName();
            if (methodName.equals(DefaultHostResolver.getAllAddressesForHostNameMethod.getName())) {
                return this.getAllAddressesForHostName(arguments);
            }
            if (methodName.equals(DefaultHostResolver.getAllHostNamesForHostAddressMethod.getName())) {
                return this.getAllHostNamesForHostAddress(arguments).iterator().next();
            }
            for (HostResolver resolver : this.resolvers) {
                Object toRet = resolver.handle(method, arguments);
                if (toRet == null) continue;
                return toRet;
            }
            throw new UnsupportedOperationException(method.getName() + " is not supported");
        });
    }

    private Object getAllAddressesForHostName(Object ... args) throws Throwable {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Map<String, Object> argumentsMap = this.buildArgumentsMap(args);
        for (HostResolver resolver : this.resolvers) {
            try {
                addresses.addAll(resolver.checkAndGetAllAddressesForHostName(argumentsMap));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        if (addresses.isEmpty()) {
            throw new UnknownHostException((String)args[0]);
        }
        return getAllAddressesForHostNameResultConverter.apply(addresses);
    }

    public Map<String, Object> buildArgumentsMap(Object[] args) {
        LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>();
        arguments.put("methodArguments", args);
        return arguments;
    }

    private Collection<String> getAllHostNamesForHostAddress(Object ... args) throws Throwable {
        ArrayList<String> hostNames = new ArrayList<String>();
        Map<String, Object> argumentsMap = this.buildArgumentsMap(args);
        for (HostResolver resolver : this.resolvers) {
            try {
                hostNames.addAll(resolver.checkAndGetAllHostNamesForHostAddress(argumentsMap));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        if (hostNames.isEmpty()) {
            throw new UnknownHostException(IPAddressUtil.INSTANCE.numericToTextFormat((byte[])args[0]));
        }
        return hostNames;
    }

    static {
        proxySupplier = Collection.class.isAssignableFrom(DefaultHostResolver.nameServiceFieldClass) ? HostResolutionRequestInterceptor::buildProxies : HostResolutionRequestInterceptor::buildProxy;
        Field cacheOneField = (Field)StaticComponentContainer.Fields.findOne((MemberCriteria)((FieldCriteria)FieldCriteria.withoutConsideringParentClasses().name(fieldName -> fieldName.equals("cache") || fieldName.equals("addressCache"))), DefaultHostResolver.inetAddressClass);
        if (cacheOneField.getName().equals("addressCache")) {
            cacheOne = StaticComponentContainer.Fields.getDirect(StaticComponentContainer.Fields.getStaticDirect(cacheOneField), "cache");
            cacheTwo = StaticComponentContainer.Fields.getDirect(StaticComponentContainer.Fields.getStaticDirect(DefaultHostResolver.inetAddressClass, "negativeCache"), "cache");
        } else {
            cacheOne = StaticComponentContainer.Fields.getStaticDirect(DefaultHostResolver.inetAddressClass, "cache");
            cacheTwo = StaticComponentContainer.Fields.getStaticDirect(DefaultHostResolver.inetAddressClass, "expirySet");
        }
        getAllAddressesForHostNameResultConverter = DefaultHostResolver.getAllAddressesForHostNameMethod.getReturnType().equals(InetAddress[].class) ? addresses -> addresses.toArray(new InetAddress[addresses.size()]) : addresses -> addresses.stream();
        INSTANCE = new HostResolutionRequestInterceptor();
    }
}

