/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.ThrowingBiFunction;
import org.burningwave.tools.net.HostResolver;

public class DNSClientHostResolver
implements HostResolver {
    public static final int DEFAULT_PORT = 53;
    private static final String IPV6_DOMAIN = "ip6.arpa.";
    private static final String IPV4_DOMAIN = "in-addr.arpa.";
    private static final short RECORD_TYPE_A = 1;
    private static final short RECORD_TYPE_PTR = 12;
    private static final short RECORD_TYPE_AAAA = 28;
    public static final ThrowingBiFunction<DNSClientHostResolver, String, byte[], IOException> IPV4_RETRIEVER = (dNSServerHostResolver, hostName) -> dNSServerHostResolver.sendRequest((String)hostName, 1);
    public static final ThrowingBiFunction<DNSClientHostResolver, String, byte[], IOException> IPV6_RETRIEVER = (dNSServerHostResolver, hostName) -> dNSServerHostResolver.sendRequest((String)hostName, 28);
    private static final ThrowingBiFunction<DNSClientHostResolver, String, byte[], IOException> PTR_RETRIEVER = (dNSServerHostResolver, hostName) -> dNSServerHostResolver.sendRequest((String)hostName, 12);
    private ThrowingBiFunction<DNSClientHostResolver, String, byte[], IOException>[] resolveHostForNameRequestSenders;
    private static Random requestIdGenerator = new Random();
    private InetAddress dNSServerIP;
    private int dNSServerPort;

    public DNSClientHostResolver(String dNSServerIP) {
        this(dNSServerIP, 53, IPV4_RETRIEVER, IPV6_RETRIEVER);
    }

    public DNSClientHostResolver(String dNSServerIP, int dNSServerPort) {
        this(dNSServerIP, dNSServerPort, IPV4_RETRIEVER, IPV6_RETRIEVER);
    }

    public DNSClientHostResolver(String dNSServerIP, ThrowingBiFunction<DNSClientHostResolver, String, byte[], IOException> ... resolveHostForNameRequestSenders) {
        this(dNSServerIP, 53, resolveHostForNameRequestSenders);
    }

    public DNSClientHostResolver(String dNSServerIP, int dNSServerPort, ThrowingBiFunction<DNSClientHostResolver, String, byte[], IOException> ... resolveHostForNameRequestSenders) {
        try {
            this.dNSServerIP = InetAddress.getByName(dNSServerIP);
        }
        catch (UnknownHostException exc) {
            StaticComponentContainer.Driver.throwException((Throwable)exc);
        }
        this.dNSServerPort = dNSServerPort;
        this.resolveHostForNameRequestSenders = resolveHostForNameRequestSenders;
    }

    @Override
    public Collection<InetAddress> getAllAddressesForHostName(Map<String, Object> argumentsMap) {
        return this.resolveHostForName((String)this.getMethodArguments(argumentsMap)[0]);
    }

    public Collection<InetAddress> resolveHostForName(String hostName) {
        try {
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            byte[][] responses = new byte[this.resolveHostForNameRequestSenders.length][];
            for (int i = 0; i < this.resolveHostForNameRequestSenders.length; ++i) {
                responses[i] = (byte[])this.resolveHostForNameRequestSenders[i].apply((Object)this, (Object)hostName);
            }
            LinkedHashMap<byte[], String> iPToDomainMap = new LinkedHashMap<byte[], String>();
            for (byte[] response : responses) {
                iPToDomainMap.putAll(this.parseResponse(response));
            }
            Object object = iPToDomainMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry iPToDomain = (Map.Entry)object.next();
                addresses.add(InetAddress.getByAddress((String)iPToDomain.getValue(), (byte[])iPToDomain.getKey()));
            }
            return addresses;
        }
        catch (Throwable exc) {
            return (Collection)StaticComponentContainer.Driver.throwException(exc);
        }
    }

    private byte[] sendRequest(String hostName, int recordType) throws IOException {
        short ID = (short)requestIdGenerator.nextInt(Short.MAX_VALUE);
        try (ByteArrayOutputStream requestContentStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream requestWrapper = new DataOutputStream(requestContentStream);){
                byte[] response;
                short requestFlags = Short.parseShort("0000000100000000", 2);
                ByteBuffer byteBuffer = ByteBuffer.allocate(2).putShort(requestFlags);
                byte[] flagsByteArray = byteBuffer.array();
                int QDCOUNT = 1;
                int ANCOUNT = 0;
                int NSCOUNT = 0;
                int ARCOUNT = 0;
                requestWrapper.writeShort(ID);
                requestWrapper.write(flagsByteArray);
                requestWrapper.writeShort(QDCOUNT);
                requestWrapper.writeShort(ANCOUNT);
                requestWrapper.writeShort(NSCOUNT);
                requestWrapper.writeShort(ARCOUNT);
                String[] domainParts = hostName.split("\\.");
                for (int i = 0; i < domainParts.length; ++i) {
                    byte[] domainBytes = domainParts[i].getBytes(StandardCharsets.UTF_8);
                    requestWrapper.writeByte(domainBytes.length);
                    requestWrapper.write(domainBytes);
                }
                requestWrapper.writeByte(0);
                requestWrapper.writeShort(recordType);
                requestWrapper.writeShort(1);
                byte[] dnsFrame = requestContentStream.toByteArray();
                try (DatagramSocket socket = new DatagramSocket();){
                    DatagramPacket dnsReqPacket = new DatagramPacket(dnsFrame, dnsFrame.length, this.dNSServerIP, this.dNSServerPort);
                    socket.send(dnsReqPacket);
                    response = new byte[1024];
                    DatagramPacket packet = new DatagramPacket(response, response.length);
                    socket.receive(packet);
                }
                byArray = response;
            }
            return byArray;
        }
    }

    private Map<byte[], String> parseResponse(byte[] responseContent) throws IOException {
        try (ByteArrayInputStream responseContentStream = new ByteArrayInputStream(responseContent);){
            LinkedHashMap<byte[], String> linkedHashMap;
            try (DataInputStream responseWrapper = new DataInputStream(responseContentStream);){
                int recLen;
                responseWrapper.skip(6L);
                int ANCOUNT = responseWrapper.readShort();
                responseWrapper.skip(4L);
                while ((recLen = responseWrapper.readByte()) > 0) {
                    byte[] record = new byte[recLen];
                    for (int i = 0; i < recLen; ++i) {
                        record[i] = responseWrapper.readByte();
                    }
                }
                responseWrapper.skip(4L);
                byte firstBytes = responseWrapper.readByte();
                int firstTwoBits = (firstBytes & 0xC0) >>> 6;
                LinkedHashMap<byte[], String> valueToDomainMap = new LinkedHashMap<byte[], String>();
                try (ByteArrayOutputStream label = new ByteArrayOutputStream();){
                    for (int i = 0; i < ANCOUNT; ++i) {
                        if (firstTwoBits == 3) {
                            byte currentByte = responseWrapper.readByte();
                            boolean stop = false;
                            byte[] newArray = Arrays.copyOfRange(responseContent, (int)currentByte, responseContent.length);
                            try (ByteArrayInputStream responseSectionContentStream = new ByteArrayInputStream(newArray);
                                 DataInputStream responseSectionWrapper = new DataInputStream(responseSectionContentStream);){
                                int j;
                                ArrayList<Byte> RDATA = new ArrayList<Byte>();
                                ArrayList<String> DOMAINS = new ArrayList<String>();
                                ArrayList<byte[]> labels = new ArrayList<byte[]>();
                                while (!stop) {
                                    int nextByte = responseSectionWrapper.readByte();
                                    if (nextByte != 0) {
                                        byte[] currentLabel = new byte[nextByte];
                                        for (j = 0; j < nextByte; ++j) {
                                            currentLabel[j] = responseSectionWrapper.readByte();
                                        }
                                        label.write(currentLabel);
                                        labels.add(currentLabel);
                                    } else {
                                        stop = true;
                                        responseWrapper.skip(8L);
                                        int RDLENGTH = responseWrapper.readShort();
                                        for (int s = 0; s < RDLENGTH; ++s) {
                                            RDATA.add(responseWrapper.readByte());
                                        }
                                    }
                                    DOMAINS.add(new String(label.toByteArray(), StandardCharsets.UTF_8));
                                    label.reset();
                                }
                                StringBuilder domainSb = new StringBuilder();
                                byte[] address = new byte[RDATA.size()];
                                for (j = 0; j < RDATA.size(); ++j) {
                                    address[j] = (Byte)RDATA.get(j);
                                }
                                for (String domainPart : DOMAINS) {
                                    if (domainPart.equals("")) continue;
                                    domainSb.append(domainPart).append(".");
                                }
                                String domainFinal = domainSb.toString();
                                valueToDomainMap.put(address, domainFinal.substring(0, domainFinal.length() - 1));
                            }
                        }
                        firstBytes = responseWrapper.readByte();
                        firstTwoBits = (firstBytes & 0xC0) >>> 6;
                    }
                }
                linkedHashMap = valueToDomainMap;
            }
            return linkedHashMap;
        }
    }

    @Override
    public Collection<String> getAllHostNamesForHostAddress(Map<String, Object> argumentsMap) {
        try {
            return this.resolveHostForAddress((byte[])this.getMethodArguments(argumentsMap)[0]);
        }
        catch (IOException exc) {
            return (Collection)StaticComponentContainer.Driver.throwException((Throwable)exc);
        }
    }

    public Collection<String> resolveHostForAddress(byte[] addressAsByteArray) throws IOException {
        LinkedHashMap<byte[], String> iPToDomainMap = new LinkedHashMap<byte[], String>();
        iPToDomainMap.putAll(this.parseResponse((byte[])PTR_RETRIEVER.apply((Object)this, (Object)this.iPAddressAsBytesToString(addressAsByteArray))));
        ArrayList<String> domains = new ArrayList<String>();
        iPToDomainMap.forEach((key, value) -> domains.add(this.hostNameAsBytesToString((byte[])key)));
        return domains;
    }

    private String iPAddressAsBytesToString(byte[] iPAddressAsByte) {
        if (iPAddressAsByte.length != 4 && iPAddressAsByte.length != 16) {
            throw new IllegalArgumentException("array must contain 4 or 16 elements");
        }
        StringBuilder sb = new StringBuilder();
        if (iPAddressAsByte.length == 4) {
            for (int i = iPAddressAsByte.length - 1; i >= 0; --i) {
                sb.append(iPAddressAsByte[i] & 0xFF);
                if (i <= 0) continue;
                sb.append(".");
            }
        } else {
            int[] pieces = new int[2];
            for (int i = iPAddressAsByte.length - 1; i >= 0; --i) {
                pieces[0] = (iPAddressAsByte[i] & 0xFF) >> 4;
                pieces[1] = iPAddressAsByte[i] & 0xF;
                for (int j = pieces.length - 1; j >= 0; --j) {
                    sb.append(Integer.toHexString(pieces[j]));
                    if (i <= 0 && j <= 0) continue;
                    sb.append(".");
                }
            }
        }
        if (iPAddressAsByte.length == 4) {
            return sb.toString() + "." + IPV4_DOMAIN;
        }
        return sb.toString() + "." + IPV6_DOMAIN;
    }

    private String hostNameAsBytesToString(byte[] hostNameAsBytes) {
        StringBuilder sb = new StringBuilder();
        int position = 0;
        while (true) {
            byte len = hostNameAsBytes[position++];
            for (int i = position; i < position + len; ++i) {
                int b = hostNameAsBytes[i] & 0xFF;
                if (b <= 32 || b >= 127) {
                    sb.append('\\');
                    if (b < 10) {
                        sb.append("00");
                    } else if (b < 100) {
                        sb.append('0');
                    }
                    sb.append(b);
                    continue;
                }
                if (b == 34 || b == 40 || b == 41 || b == 46 || b == 59 || b == 92 || b == 64 || b == 36) {
                    sb.append('\\');
                    sb.append((char)b);
                    continue;
                }
                sb.append((char)b);
            }
            if ((position += len) >= hostNameAsBytes.length || hostNameAsBytes[position] == 0) break;
            sb.append(".");
        }
        return sb.toString();
    }
}

