/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.net;

import io.github.toolfactory.jvm.function.InitializeException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Stream;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.FieldCriteria;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.core.classes.MethodCriteria;
import org.burningwave.tools.net.HostResolver;

public class DefaultHostResolver
implements HostResolver {
    public static final HostResolver INSTANCE;
    static final Class<?> inetAddressClass;
    static final Field nameServiceField;
    static final Class<?> nameServiceFieldClass;
    static final Class<?> nameServiceClass;
    static final Method getAllAddressesForHostNameMethod;
    static final Method getAllHostNamesForHostAddressMethod;
    static final List<Object> nameServices;
    private static final Function<Object, Stream<InetAddress>> inetAddressSupplier;

    private static Class<?> getNameServiceFieldClass(Field nameServiceField) {
        if (Collection.class.isAssignableFrom(nameServiceField.getType())) {
            ParameterizedType stringListType = (ParameterizedType)nameServiceField.getGenericType();
            return (Class)stringListType.getActualTypeArguments()[0];
        }
        return nameServiceField.getType();
    }

    private static List<Object> getNameServices() {
        try {
            InetAddress.getAllByName("localhost");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        CopyOnWriteArrayList<Object> nameServices = new CopyOnWriteArrayList<Object>();
        if (Collection.class.isAssignableFrom(nameServiceFieldClass)) {
            nameServices.addAll((Collection)StaticComponentContainer.Fields.getStaticDirect(nameServiceField));
        } else {
            Object nameService = StaticComponentContainer.Fields.getStaticDirect(nameServiceField);
            if (nameService != null) {
                nameServices.add(nameService);
            }
        }
        return nameServices;
    }

    @Override
    public Collection<InetAddress> getAllAddressesForHostName(Map<String, Object> argumentsMap) {
        ArrayList<InetAddress> addresses;
        block6: {
            Object[] arguments = this.getMethodArguments(argumentsMap);
            List<Object> nameServices = (List<Object>)argumentsMap.get("nameServices");
            if (nameServices == null) {
                nameServices = DefaultHostResolver.nameServices;
            }
            addresses = new ArrayList<InetAddress>();
            Iterator<Object> iterator = nameServices.iterator();
            while (true) {
                Object nameService;
                if ((nameService = iterator.next()) == null) {
                    continue;
                }
                Object inetAddresses = StaticComponentContainer.Methods.invokeDirect(nameService, getAllAddressesForHostNameMethod.getName(), arguments);
                if (inetAddresses == null) continue;
                inetAddressSupplier.apply(inetAddresses).forEach(addresses::add);
                continue;
                break;
            }
            finally {
                if (!iterator.hasNext()) break block6;
            }
        }
        return addresses;
    }

    @Override
    public Collection<String> getAllHostNamesForHostAddress(Map<String, Object> argumentsMap) {
        ArrayList<String> hostNames;
        block6: {
            Object[] arguments = this.getMethodArguments(argumentsMap);
            List<Object> nameServices = (List<Object>)argumentsMap.get("nameServices");
            if (nameServices == null) {
                nameServices = DefaultHostResolver.nameServices;
            }
            hostNames = new ArrayList<String>();
            Iterator<Object> iterator = nameServices.iterator();
            while (true) {
                Object nameService;
                if ((nameService = iterator.next()) == null) {
                    continue;
                }
                String hostName = (String)StaticComponentContainer.Methods.invokeDirect(nameService, getAllHostNamesForHostAddressMethod.getName(), arguments);
                if (hostName == null) continue;
                hostNames.add(hostName);
                continue;
                break;
            }
            finally {
                if (!iterator.hasNext()) break block6;
            }
        }
        return hostNames;
    }

    @Override
    public Object handle(Method method, Object ... arguments) throws Throwable {
        for (Object nameService : nameServices) {
            Object toRet;
            if (nameService == null || (toRet = StaticComponentContainer.Methods.invokeDirect(nameService, method.getName(), arguments)) == null) continue;
            return toRet;
        }
        return null;
    }

    static {
        inetAddressClass = InetAddress.class;
        nameServiceField = (Field)StaticComponentContainer.Fields.findFirst((MemberCriteria)((FieldCriteria)FieldCriteria.withoutConsideringParentClasses().name(fieldName -> fieldName.equals("nameService") || fieldName.equals("nameServices") || fieldName.equals("resolver"))), inetAddressClass);
        nameServiceFieldClass = nameServiceField.getType();
        nameServiceClass = DefaultHostResolver.getNameServiceFieldClass(nameServiceField);
        getAllAddressesForHostNameMethod = (Method)StaticComponentContainer.Methods.findFirst((MemberCriteria)((MethodCriteria)MethodCriteria.forEntireClassHierarchy().name(methodName -> methodName.equals("lookupAllHostAddr") || methodName.equals("lookupByName"))), nameServiceClass);
        inetAddressSupplier = getAllAddressesForHostNameMethod.getReturnType().equals(InetAddress[].class) ? obj -> Stream.of((InetAddress[])obj) : obj -> (Stream)obj;
        getAllHostNamesForHostAddressMethod = (Method)StaticComponentContainer.Methods.findFirst((MemberCriteria)((MethodCriteria)MethodCriteria.forEntireClassHierarchy().name(methodName -> methodName.equals("getHostByAddr") || methodName.equals("lookupByAddress"))), nameServiceClass);
        nameServices = DefaultHostResolver.getNameServices();
        if (nameServices.isEmpty()) {
            StaticComponentContainer.Driver.throwException((Throwable)new InitializeException(StaticComponentContainer.Strings.compile("No items found for field {}.{}", new Object[]{nameServiceField.getDeclaringClass(), nameServiceField.getName()})));
        }
        INSTANCE = new DefaultHostResolver();
    }
}

