/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dependencies;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.burningwave.core.assembler.ComponentContainer;
import org.burningwave.core.assembler.ComponentSupplier;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ByteCodeHunter;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.SearchConfig;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.function.ThrowingSupplier;
import org.burningwave.core.function.TriConsumer;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.tools.dependencies.Capturer;
import org.burningwave.tools.dependencies.Sniffer;

public class TwoPassCapturer
extends Capturer {
    ClassPathHunter classPathHunter;
    PathHelper pathHelper;

    private TwoPassCapturer(PathHelper pathHelper, ByteCodeHunter byteCodeHunter, ClassPathHunter classPathHunter) {
        super(byteCodeHunter);
        this.pathHelper = pathHelper;
        this.classPathHunter = classPathHunter;
    }

    public static TwoPassCapturer create(ComponentSupplier componentSupplier) {
        return new TwoPassCapturer(componentSupplier.getPathHelper(), componentSupplier.getByteCodeHunter(), componentSupplier.getClassPathHunter());
    }

    public static TwoPassCapturer getInstance() {
        return Holder.getCapturerInstance();
    }

    @Override
    public Result capture(String mainClassName, String[] mainMethodAruments, Collection<String> baseClassPaths, TriConsumer<String, String, ByteBuffer> resourceConsumer, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) {
        return this.capture(mainClassName, mainMethodAruments, baseClassPaths, resourceConsumer, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor, true);
    }

    private Result capture(String mainClassName, String[] mainMethodAruments, Collection<String> baseClassPaths, TriConsumer<String, String, ByteBuffer> resourceConsumer, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor, boolean recursive) {
        Result result = new Result(javaClass -> true, fileSystemItem -> true);
        result.findingTask = (QueuedTaskExecutor.Task)StaticComponentContainer.BackgroundExecutor.createTask(task -> {
            try (Sniffer resourceSniffer = new Sniffer(null).init(!recursive, baseClassPaths, result.javaClassFilter, result.resourceFilter, resourceConsumer);){
                ThrowingSupplier mainClassSupplier = recursive ? () -> Class.forName(mainClassName, false, (ClassLoader)((Object)resourceSniffer)) : () -> Class.forName(mainClassName);
                try {
                    ((Class)mainClassSupplier.get()).getMethod("main", String[].class).invoke(null, new Object[]{mainMethodAruments});
                    if (continueToCaptureAfterSimulatorClassEndExecutionFor != null && continueToCaptureAfterSimulatorClassEndExecutionFor > 0L) {
                        Thread.sleep(continueToCaptureAfterSimulatorClassEndExecutionFor);
                    }
                }
                catch (Throwable exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Exception occurred", exc);
                    StaticComponentContainer.Driver.throwException(exc);
                }
            }
            if (recursive) {
                try {
                    this.launchExternalCapturer(mainClassName, mainMethodAruments, result.getStore().getAbsolutePath(), baseClassPaths, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor);
                }
                catch (IOException | InterruptedException exc) {
                    StaticComponentContainer.Driver.throwException((Throwable)exc);
                }
            }
            if (recursive && !includeMainClass) {
                JavaClass mainJavaClass = result.getJavaClass(javaClass -> javaClass.getName().equals(mainClassName));
                Collection<FileSystemItem> mainJavaClassesFiles = result.getResources(fileSystemItem -> fileSystemItem.getAbsolutePath().endsWith(mainJavaClass.getPath()));
                FileSystemItem store = result.getStore();
                for (FileSystemItem fileSystemItem2 : mainJavaClassesFiles) {
                    StaticComponentContainer.FileSystemHelper.delete(fileSystemItem2.getAbsolutePath());
                    for (fileSystemItem2 = fileSystemItem2.getParent(); fileSystemItem2 != null && !fileSystemItem2.getAbsolutePath().equals(store.getAbsolutePath()) && fileSystemItem2.getChildren().isEmpty(); fileSystemItem2 = fileSystemItem2.getParent()) {
                        StaticComponentContainer.FileSystemHelper.delete(fileSystemItem2.getAbsolutePath());
                    }
                }
            }
        }).submit();
        return result;
    }

    private Result captureAndStore(String mainClassName, String[] mainMethodAruments, Collection<String> baseClassPaths, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor, boolean recursive) {
        Result dependencies = this.capture(mainClassName, mainMethodAruments, baseClassPaths, this.getStoreFunction(destinationPath), includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor, recursive);
        dependencies.store = FileSystemItem.ofPath((String)destinationPath);
        return dependencies;
    }

    private void launchExternalCapturer(String mainClassName, String[] mainMethodAruments, String destinationPath, Collection<String> baseClassPaths, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) throws IOException, InterruptedException {
        Set<String> classPaths = FileSystemItem.ofPath((String)destinationPath).refresh().findInChildren(FileSystemItem.Criteria.forAllFileThat(fileSystemItem -> !fileSystemItem.getAbsolutePath().endsWith("[org.burningwave]") && !fileSystemItem.getAbsolutePath().endsWith("[io.github.toolfactory]"))).stream().map(child -> child.getAbsolutePath()).collect(Collectors.toSet());
        ClassPathHunter.SearchResult searchResult = (ClassPathHunter.SearchResult)this.classPathHunter.findBy(SearchConfig.forPaths((Collection[])new Collection[]{this.pathHelper.getMainClassPaths()}).by(ClassCriteria.create().packageName(packageName -> packageName.startsWith("io.github.toolfactory") || packageName.startsWith("org.burningwave.jvm") || packageName.startsWith("org.burningwave.core") || packageName.startsWith("org.burningwave.tools"))));
        LinkedHashSet<String> classPathsToBeScanned = new LinkedHashSet<String>(baseClassPaths);
        classPathsToBeScanned.remove(destinationPath);
        for (FileSystemItem classPath : searchResult.getClassPaths()) {
            if (classPaths.contains(classPath.getAbsolutePath())) continue;
            classPaths.add(classPath.getAbsolutePath());
        }
        ProcessBuilder processBuilder = System.getProperty("os.name").toLowerCase().contains("windows") ? this.getProcessBuilderForWindows(classPaths, classPathsToBeScanned, mainClassName, mainMethodAruments, destinationPath, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor) : this.getProcessBuilderForUnix(classPaths, classPathsToBeScanned, mainClassName, mainMethodAruments, destinationPath, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor);
        Process process = processBuilder.start();
        process.waitFor();
    }

    private ProcessBuilder getProcessBuilderForWindows(Collection<String> classPaths, Collection<String> classPathsToBeScanned, String mainClassName, String[] mainMethodAruments, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) throws IOException {
        String javaExecutablePath = System.getProperty("java.home") + "/bin/java";
        LinkedList<String> command = new LinkedList<String>();
        command.add(StaticComponentContainer.Paths.clean(javaExecutablePath));
        command.add("-classpath");
        StringBuffer generatedClassPath = new StringBuffer();
        generatedClassPath.append("\"");
        if (!classPaths.isEmpty()) {
            generatedClassPath.append(String.join((CharSequence)File.pathSeparator, classPaths));
        }
        generatedClassPath.append("\"");
        command.add(generatedClassPath.toString());
        command.add(InternalLauncher.class.getName());
        command.add("\"" + String.join((CharSequence)File.pathSeparator, classPathsToBeScanned) + "\"");
        command.add(mainClassName);
        command.add("\"" + destinationPath + "\"");
        command.add(Boolean.valueOf(includeMainClass).toString());
        command.add(continueToCaptureAfterSimulatorClassEndExecutionFor.toString());
        command.addAll(Arrays.asList(mainMethodAruments));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        return processBuilder.inheritIO();
    }

    private ProcessBuilder getProcessBuilderForUnix(Collection<String> classPaths, Collection<String> classPathsToBeScanned, String mainClassName, String[] mainMethodAruments, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) throws IOException {
        LinkedList<String> command = new LinkedList<String>();
        String javaExecutablePath = StaticComponentContainer.Paths.clean(System.getProperty("java.home") + "/bin/java");
        command.add(javaExecutablePath);
        command.add("-classpath");
        StringBuffer generatedClassPath = new StringBuffer();
        if (!classPaths.isEmpty()) {
            generatedClassPath.append(String.join((CharSequence)File.pathSeparator, classPaths));
        }
        command.add(generatedClassPath.toString());
        command.add(InternalLauncher.class.getName());
        command.add(String.join((CharSequence)File.pathSeparator, classPathsToBeScanned));
        command.add(mainClassName);
        command.add(destinationPath);
        command.add(Boolean.valueOf(includeMainClass).toString());
        command.add(continueToCaptureAfterSimulatorClassEndExecutionFor.toString());
        command.addAll(Arrays.asList(mainMethodAruments));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        return processBuilder.inheritIO();
    }

    private void logReceivedParameters(String[] args, long wait, String fileSuffix) {
        try {
            String logs = String.join((CharSequence)"\n\n", "classpath:\n\t" + String.join((CharSequence)"\n\t", new TreeSet<String>(Arrays.asList(System.getProperty("java.class.path").split(File.pathSeparator)))), "path to be scanned:\n\t" + String.join((CharSequence)(File.pathSeparator + "\n\t"), new TreeSet<String>(Arrays.asList(args[0].split(File.pathSeparator)))), "mainClassName: " + args[1], "destinationPath: " + args[2], "includeMainClass: " + args[3], "continueToCaptureAfterSimulatorClassEndExecutionFor: " + args[4], args.length > 5 ? "arguments: " + String.join((CharSequence)", ", Arrays.copyOfRange(args, 5, args.length)) : "");
            Files.write(Paths.get(args[2] + "/params-" + fileSuffix + ".txt", new String[0]), logs.getBytes(), new OpenOption[0]);
            StaticComponentContainer.ManagedLoggerRepository.logDebug(() -> this.getClass().getName(), "\n\n" + logs + "\n\n");
            if (wait > 0L) {
                Thread.sleep(wait);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static class Result
    extends Capturer.Result {
        Function<JavaClass, Boolean> javaClassFilter;
        Function<FileSystemItem, Boolean> resourceFilter;

        Result(Function<JavaClass, Boolean> javaClassFilter, Function<FileSystemItem, Boolean> resourceFilter) {
            this.javaClassFilter = javaClassFilter;
            this.resourceFilter = resourceFilter;
            this.javaClasses = null;
            this.resources = null;
        }

        @Override
        public Collection<JavaClass> getJavaClasses() {
            if (this.javaClasses != null) {
                return this.javaClasses;
            }
            return this.loadResourcesAndJavaClasses().getValue();
        }

        @Override
        public Collection<FileSystemItem> getResources() {
            if (this.resources != null) {
                return this.resources;
            }
            return this.loadResourcesAndJavaClasses().getKey();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map.Entry<Collection<FileSystemItem>, Collection<JavaClass>> loadResourcesAndJavaClasses() {
            Map.Entry<Collection<FileSystemItem>, Collection<JavaClass>> itemsFound = null;
            if (this.findingTask.hasFinished() && this.resources == null) {
                Result result = this;
                synchronized (result) {
                    if (this.resources == null) {
                        itemsFound = this.retrieveResources();
                        this.resources = itemsFound.getKey();
                        this.javaClasses = itemsFound.getValue();
                        return itemsFound;
                    }
                }
            }
            return this.retrieveResources();
        }

        private Map.Entry<Collection<FileSystemItem>, Collection<JavaClass>> retrieveResources() {
            ConcurrentHashMap.KeySetView resources = ConcurrentHashMap.newKeySet();
            ConcurrentHashMap.KeySetView javaClasses = ConcurrentHashMap.newKeySet();
            AbstractMap.SimpleEntry<Collection<FileSystemItem>, Collection<JavaClass>> itemsFound = new AbstractMap.SimpleEntry<Collection<FileSystemItem>, Collection<JavaClass>>(resources, javaClasses);
            for (FileSystemItem fileSystemItem2 : this.store.refresh().findInAllChildren(FileSystemItem.Criteria.forAllFileThat(fileSystemItem -> this.resourceFilter.apply((FileSystemItem)fileSystemItem)))) {
                resources.add(fileSystemItem2);
                if (!"class".equals(fileSystemItem2.getExtension())) continue;
                javaClasses.add(JavaClass.create((ByteBuffer)fileSystemItem2.toByteBuffer()));
            }
            return itemsFound;
        }
    }

    private static class Holder {
        private static final TwoPassCapturer CAPTURER_INSTANCE = TwoPassCapturer.create((ComponentSupplier)ComponentContainer.getInstance());

        private Holder() {
        }

        private static TwoPassCapturer getCapturerInstance() {
            return CAPTURER_INSTANCE;
        }
    }

    private static class InternalLauncher {
        private InternalLauncher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            String[] mainMethodArguments = args.length > 5 ? Arrays.copyOfRange(args, 5, args.length) : new String[]{};
            TwoPassCapturer capturer = TwoPassCapturer.getInstance();
            try {
                List<String> paths = Arrays.asList(args[0].split(File.pathSeparator));
                String mainClassName = args[1];
                String destinationPath = args[2];
                boolean includeMainClass = Boolean.valueOf(args[3]);
                long continueToCaptureAfterSimulatorClassEndExecutionFor = Long.valueOf(args[4]);
                capturer.captureAndStore(mainClassName, mainMethodArguments, paths, destinationPath, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor, false).waitForTaskEnding();
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(() -> TwoPassCapturer.class.getName(), "Exception occurred", exc);
            }
            finally {
                String suffix = UUID.randomUUID().toString();
                capturer.logReceivedParameters(args, 0L, suffix);
                capturer.createExecutor(args[2], args[1], mainMethodArguments, suffix);
            }
        }
    }
}

