/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dependencies;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.burningwave.Throwables;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.Strings;
import org.burningwave.core.assembler.ComponentContainer;
import org.burningwave.core.assembler.ComponentSupplier;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassHelper;
import org.burningwave.core.classes.Classes;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.hunter.ByteCodeHunter;
import org.burningwave.core.classes.hunter.CacheableSearchConfig;
import org.burningwave.core.classes.hunter.ClassPathHunter;
import org.burningwave.core.classes.hunter.SearchConfig;
import org.burningwave.core.function.TriConsumer;
import org.burningwave.core.io.FileScanConfig;
import org.burningwave.core.io.FileSystemHelper;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.tools.dependencies.Capturer;
import org.burningwave.tools.dependencies.Sniffer;

public class TwoPassCapturer
extends Capturer {
    ClassPathHunter classPathHunter;

    private TwoPassCapturer(FileSystemHelper fileSystemHelper, PathHelper pathHelper, ByteCodeHunter byteCodeHunter, ClassPathHunter classPathHunter, ClassHelper classHelper) {
        super(fileSystemHelper, pathHelper, byteCodeHunter, classHelper);
        this.classPathHunter = classPathHunter;
    }

    public static TwoPassCapturer create(ComponentContainer componentSupplier) {
        return new TwoPassCapturer(componentSupplier.getFileSystemHelper(), componentSupplier.getPathHelper(), componentSupplier.getByteCodeHunter(), componentSupplier.getClassPathHunter(), componentSupplier.getClassHelper());
    }

    public static TwoPassCapturer getInstance() {
        return LazyHolder.getCapturerInstance();
    }

    @Override
    public Result capture(Class<?> mainClass, Collection<String> baseClassPaths, TriConsumer<String, String, ByteBuffer> resourceConsumer, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) {
        return this.capture(mainClass, baseClassPaths, resourceConsumer, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor, true);
    }

    public Result capture(Class<?> mainClass, Collection<String> _baseClassPaths, TriConsumer<String, String, ByteBuffer> resourceConsumer, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor, boolean recursive) {
        Result result = new Result(this.fileSystemHelper, javaClass -> true, fileSystemItem -> true);
        LinkedHashSet<String> baseClassPaths = new LinkedHashSet<String>(_baseClassPaths);
        baseClassPaths.addAll(this.additionalClassPaths);
        AtomicBoolean recursiveFlagWrapper = new AtomicBoolean(recursive);
        result.findingTask = CompletableFuture.runAsync(() -> {
            block24: {
                try (Sniffer resourceSniffer = new Sniffer(null).init(!recursiveFlagWrapper.get(), this.fileSystemHelper, this.classHelper, baseClassPaths, result.javaClassFilter, result.resourceFilter, resourceConsumer);){
                    if (!recursiveFlagWrapper.get()) {
                        Throwable resourceNotFoundException = null;
                        do {
                            try {
                                mainClass.getMethod("main", String[].class).invoke(null, new Object[]{new String[0]});
                                resourceNotFoundException = null;
                                if (continueToCaptureAfterSimulatorClassEndExecutionFor == null || continueToCaptureAfterSimulatorClassEndExecutionFor <= 0L) continue;
                                Thread.sleep(continueToCaptureAfterSimulatorClassEndExecutionFor);
                            }
                            catch (Throwable exc) {
                                Collection penultimateNotFoundClasses = resourceNotFoundException != null ? Classes.retrieveNames(resourceNotFoundException) : new LinkedHashSet();
                                resourceNotFoundException = exc;
                                Collection currentNotFoundClass = Classes.retrieveNames((Throwable)resourceNotFoundException);
                                if (!currentNotFoundClass.isEmpty()) {
                                    if (!currentNotFoundClass.containsAll(penultimateNotFoundClasses)) {
                                        try {
                                            for (JavaClass javaClass2 : resourceSniffer.consumeClasses(currentNotFoundClass)) {
                                                this.logDebug("Searching for {}", new Object[]{currentNotFoundClass});
                                                this.classHelper.loadOrUploadClass(javaClass2, resourceSniffer.mainClassLoader);
                                            }
                                            continue;
                                        }
                                        catch (Throwable exc2) {
                                            this.logError("Exception occurred", exc2);
                                            throw Throwables.toRuntimeException((Object)exc2);
                                        }
                                    }
                                    recursiveFlagWrapper.set(true);
                                    resourceNotFoundException = null;
                                    continue;
                                }
                                this.logError("Exception occurred", exc);
                                throw Throwables.toRuntimeException((Object)exc);
                            }
                        } while (resourceNotFoundException != null);
                        break block24;
                    }
                    try {
                        Class cls = this.classHelper.loadOrUploadClass(mainClass, (ClassLoader)((Object)resourceSniffer));
                        cls.getMethod("main", String[].class).invoke(null, new Object[]{new String[0]});
                        if (continueToCaptureAfterSimulatorClassEndExecutionFor != null && continueToCaptureAfterSimulatorClassEndExecutionFor > 0L) {
                            Thread.sleep(continueToCaptureAfterSimulatorClassEndExecutionFor);
                        }
                    }
                    catch (Throwable exc) {
                        this.logError("Exception occurred", exc);
                        throw Throwables.toRuntimeException((Object)exc);
                    }
                }
            }
            if (recursiveFlagWrapper.get()) {
                try {
                    this.launchExternalCapturer(mainClass, result.getStore().getAbsolutePath(), baseClassPaths, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor);
                }
                catch (IOException | InterruptedException exc) {
                    throw Throwables.toRuntimeException((Object)exc);
                }
            }
            if (recursive && !includeMainClass) {
                JavaClass mainJavaClass = result.getJavaClass(javaClass -> javaClass.getName().equals(mainClass.getName()));
                Collection<FileSystemItem> mainJavaClassesFiles = result.getResources(fileSystemItem -> fileSystemItem.getAbsolutePath().endsWith(mainJavaClass.getPath()));
                FileSystemItem store = result.getStore();
                for (FileSystemItem fileSystemItem2 : mainJavaClassesFiles) {
                    FileSystemHelper.delete((String)fileSystemItem2.getAbsolutePath());
                    for (fileSystemItem2 = fileSystemItem2.getParent(); fileSystemItem2 != null && !fileSystemItem2.getAbsolutePath().equals(store.getAbsolutePath()) && fileSystemItem2.getChildren().isEmpty(); fileSystemItem2 = fileSystemItem2.getParent()) {
                        FileSystemHelper.delete((String)fileSystemItem2.getAbsolutePath());
                    }
                }
            }
        });
        return result;
    }

    private Result captureAndStore(Class<?> mainClass, Collection<String> baseClassPaths, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor, boolean recursive) {
        Result dependencies = this.capture(mainClass, baseClassPaths, this.getStoreFunction(destinationPath), includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor, recursive);
        dependencies.store = FileSystemItem.ofPath((String)destinationPath);
        return dependencies;
    }

    private void launchExternalCapturer(Class<?> mainClass, String destinationPath, Collection<String> baseClassPaths, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) throws IOException, InterruptedException {
        String javaExecutablePath = System.getProperty("java.home") + "/bin/java";
        LinkedList<String> command = new LinkedList<String>();
        command.add(Strings.Paths.clean((String)javaExecutablePath));
        command.add("-classpath");
        StringBuffer generatedClassPath = new StringBuffer("\"");
        LinkedHashSet<String> classPathsToBeScanned = new LinkedHashSet<String>(baseClassPaths);
        classPathsToBeScanned.remove(destinationPath);
        Set classPaths = FileSystemItem.ofPath((String)destinationPath).getChildren().stream().map(child -> child.getAbsolutePath()).collect(Collectors.toSet());
        generatedClassPath.append(String.join((CharSequence)System.getProperty("path.separator"), classPaths));
        ClassPathHunter.SearchResult searchResult = (ClassPathHunter.SearchResult)this.classPathHunter.findBy((CacheableSearchConfig)SearchConfig.forPaths((Collection)this.pathHelper.getMainClassPaths()).by(ClassCriteria.create().className(clsName -> clsName.equals(this.getClass().getName()) || clsName.equals(ComponentSupplier.class.getName()))));
        for (FileSystemItem classPath : searchResult.getClassPaths()) {
            if (generatedClassPath.toString().contains(classPath.getAbsolutePath())) continue;
            generatedClassPath.append(System.getProperty("path.separator"));
            generatedClassPath.append(classPath.getAbsolutePath());
            classPathsToBeScanned.remove(classPath.getAbsolutePath());
        }
        generatedClassPath.append("\"");
        command.add(generatedClassPath.toString());
        command.add(this.getClass().getName());
        String classPathsToBeScannedParam = "\"" + String.join((CharSequence)System.getProperty("path.separator"), classPathsToBeScanned);
        classPathsToBeScannedParam = classPathsToBeScannedParam + "\"";
        command.add(classPathsToBeScannedParam);
        command.add(mainClass.getName());
        command.add("\"" + destinationPath + "\"");
        command.add(Boolean.valueOf(includeMainClass).toString());
        command.add(continueToCaptureAfterSimulatorClassEndExecutionFor.toString());
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = processBuilder.inheritIO().start();
        process.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ClassNotFoundException {
        try {
            List<String> paths = Arrays.asList(args[0].split(System.getProperty("path.separator")));
            String mainClassName = args[1];
            String destinationPath = args[2];
            boolean includeMainClass = Boolean.valueOf(args[3]);
            long continueToCaptureAfterSimulatorClassEndExecutionFor = Long.valueOf(args[4]);
            Class<?> mainClass = Class.forName(mainClassName);
            TwoPassCapturer.getInstance().captureAndStore(mainClass, paths, destinationPath, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor, false).waitForTaskEnding();
        }
        catch (Throwable exc) {
            ManagedLogger.Repository.getInstance().logError(TwoPassCapturer.class, "Exception occurred", exc);
        }
        finally {
            TwoPassCapturer.logReceivedParameters(args, 0L);
        }
    }

    private static void logReceivedParameters(String[] args, long wait) {
        try {
            String logs = "classpath: " + System.getProperty("java.class.path") + "\npath to be scanned: " + String.join((CharSequence)";", Arrays.asList(args[0].split(System.getProperty("path.separator")))) + "\nmainClassName: " + args[1] + "\ndestinationPath: " + args[2] + "\nincludeMainClass: " + args[3] + "\ncontinueToCaptureAfterSimulatorClassEndExecutionFor: " + args[4];
            Files.write(Paths.get(args[2] + "\\params-" + UUID.randomUUID().toString() + ".txt", new String[0]), logs.getBytes(), new OpenOption[0]);
            ManagedLogger.Repository.getInstance().logDebug(TwoPassCapturer.class, "\n\n" + logs + "\n\n");
            String externalExecutor = FileSystemItem.ofPath((String)System.getProperty("java.home")).getAbsolutePath() + "/bin/java -classpath \"" + String.join((CharSequence)";", FileSystemItem.ofPath((String)args[2]).getChildren().stream().map(fileSystemItem -> fileSystemItem.getAbsolutePath()).collect(Collectors.toList())) + "\" " + args[1];
            Files.write(Paths.get(args[2] + "\\executor-" + UUID.randomUUID().toString() + ".cmd", new String[0]), externalExecutor.getBytes(), new OpenOption[0]);
            if (wait > 0L) {
                Thread.sleep(wait);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static class LazyHolder {
        private static final TwoPassCapturer CAPTURER_INSTANCE = TwoPassCapturer.create(ComponentContainer.getInstance());

        private LazyHolder() {
        }

        private static TwoPassCapturer getCapturerInstance() {
            return CAPTURER_INSTANCE;
        }
    }

    private static class Result
    extends Capturer.Result {
        FileSystemHelper fileSystemHelper;
        Function<JavaClass, Boolean> javaClassFilter;
        Function<FileSystemItem, Boolean> resourceFilter;

        Result(FileSystemHelper fileSystemHelper, Function<JavaClass, Boolean> javaClassFilter, Function<FileSystemItem, Boolean> resourceFilter) {
            this.fileSystemHelper = fileSystemHelper;
            this.javaClassFilter = javaClassFilter;
            this.resourceFilter = resourceFilter;
            this.javaClasses = null;
            this.resources = null;
        }

        Consumer<FileSystemHelper.Scan.ItemContext> getResourceRetriever(Collection<FileSystemItem> resources) {
            return scannedItemContext -> {
                FileSystemItem fileSystemItem = FileSystemItem.ofPath((String)scannedItemContext.getScannedItem().getAbsolutePath());
                if (this.resourceFilter.apply(fileSystemItem).booleanValue()) {
                    resources.add(fileSystemItem);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<JavaClass> getJavaClasses() {
            if (this.findingTask.isDone()) {
                if (this.javaClasses == null) {
                    String string = this.toString() + "_javaClasses";
                    synchronized (string) {
                        if (this.javaClasses == null) {
                            this.javaClasses = this.retrieveJavaClasses();
                            return this.javaClasses;
                        }
                    }
                }
                return this.javaClasses;
            }
            return this.retrieveJavaClasses();
        }

        private Collection<JavaClass> retrieveJavaClasses() {
            Collection<FileSystemItem> resources = this.getResources();
            return resources.stream().filter(resource -> resource.getExtension().equals("class")).map(javaClassResource -> JavaClass.create((ByteBuffer)javaClassResource.toByteBuffer())).filter(javaClass -> this.javaClassFilter.apply((JavaClass)javaClass)).collect(Collectors.toCollection(ConcurrentHashMap::newKeySet));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<FileSystemItem> getResources() {
            if (this.findingTask.isDone()) {
                if (this.resources == null) {
                    String string = this.toString() + "_resources";
                    synchronized (string) {
                        if (this.resources == null) {
                            this.resources = this.retrieveResources();
                            return this.resources;
                        }
                    }
                }
                return this.resources;
            }
            return this.retrieveResources();
        }

        private Collection<FileSystemItem> retrieveResources() {
            CopyOnWriteArrayList<FileSystemItem> resources = new CopyOnWriteArrayList<FileSystemItem>();
            this.fileSystemHelper.scan(FileScanConfig.forPaths((String[])new String[]{this.store.getAbsolutePath()}).toScanConfiguration(this.getResourceRetriever(resources)));
            return resources;
        }
    }
}

