/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.loader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.loader.URLClassPath;

public class ClassLoaderDelegate
extends BuiltinClassLoader {
    private ClassLoader classLoader;
    private Method loadClassMethod;

    ClassLoaderDelegate(String string, BuiltinClassLoader builtinClassLoader, URLClassPath uRLClassPath) {
        super(string, builtinClassLoader, uRLClassPath);
    }

    public void init(ClassLoader classLoader) {
        this.classLoader = classLoader;
        for (Class<?> clazz = classLoader.getClass(); this.loadClassMethod == null && clazz != ClassLoader.class.getSuperclass(); clazz = clazz.getSuperclass()) {
            try {
                this.loadClassMethod = clazz.getDeclaredMethod("loadClass", String.class, Boolean.TYPE);
                this.loadClassMethod.setAccessible(true);
                continue;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected Class<?> loadClassOrNull(String string, boolean bl) {
        try {
            return (Class)this.loadClassMethod.invoke((Object)this.classLoader, string, bl);
        }
        catch (Throwable throwable) {
            System.out.println("Class " + string + " not found");
            return null;
        }
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        try {
            return (Class)this.loadClassMethod.invoke((Object)this.classLoader, string, bl);
        }
        catch (Throwable throwable) {
            System.out.println("Class " + string + " not found");
            return null;
        }
    }

    @Override
    public URL getResource(String string) {
        return this.classLoader.getResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        return this.classLoader.getResources(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        return this.classLoader.getResourceAsStream(string);
    }
}

