/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.jvm;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.function.Supplier;
import org.burningwave.Throwables;
import org.burningwave.core.assembler.ComponentSupplier;
import org.burningwave.core.classes.ClassFactory;
import org.burningwave.core.classes.ClassHelper;
import org.burningwave.core.classes.FieldCriteria;
import org.burningwave.core.classes.MemberFinder;
import org.burningwave.core.io.ByteBufferOutputStream;
import org.burningwave.core.io.StreamHelper;
import org.burningwave.core.io.Streams;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.jvm.JVMChecker;

public class LowLevelObjectsHandler
extends org.burningwave.core.jvm.LowLevelObjectsHandler {
    protected LowLevelObjectsHandler(JVMChecker jVMChecker, StreamHelper streamHelper, Supplier<ClassFactory> classFactorySupplier, Supplier<ClassHelper> classHelperSupplier, MemberFinder memberFinder, IterableObjectHelper iterableObjectHelper) {
        super(jVMChecker, streamHelper, classFactorySupplier, classHelperSupplier, memberFinder, iterableObjectHelper);
    }

    public static LowLevelObjectsHandler create(ComponentSupplier componentSupplier) {
        return new LowLevelObjectsHandler(componentSupplier.getJVMChecker(), componentSupplier.getStreamHelper(), () -> componentSupplier.getClassFactory(), () -> componentSupplier.getClassHelper(), componentSupplier.getMemberFinder(), componentSupplier.getIterableObjectHelper());
    }

    public Function<Boolean, ClassLoader> setAsMasterClassLoader(ClassLoader classLoader) {
        ClassLoader masterClassLoader = this.getMasterClassLoader(Thread.currentThread().getContextClassLoader());
        return this.setAsParentClassLoader(masterClassLoader, classLoader, false);
    }

    public Function<Boolean, ClassLoader> setAsParentClassLoader(ClassLoader classLoader, ClassLoader futureParent, boolean mantainHierarchy) {
        Class<ClassLoader> classLoaderBaseClass;
        block15: {
            classLoaderBaseClass = this.retrieveBuiltinClassLoaderClass();
            if (classLoaderBaseClass != null && classLoaderBaseClass.isAssignableFrom(classLoader.getClass())) {
                try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("jdk/internal/loader/ClassLoaderDelegate.class");
                     ByteBufferOutputStream bBOS = new ByteBufferOutputStream();){
                    Streams.copy((InputStream)inputStream, (OutputStream)bBOS);
                    Class classLoaderDelegateClass = this.getClassHelper().loadOrUploadClass(bBOS.toByteBuffer(), ClassLoader.getSystemClassLoader());
                    Object classLoaderDelegate = LowLevelObjectsHandler.getUnsafe().allocateInstance(classLoaderDelegateClass);
                    classLoaderDelegateClass.getDeclaredMethod("init", ClassLoader.class).invoke(classLoaderDelegate, futureParent);
                    futureParent = (ClassLoader)classLoaderDelegate;
                    break block15;
                }
                catch (Throwable exc) {
                    throw Throwables.toRuntimeException((Object)exc);
                }
            }
            classLoaderBaseClass = ClassLoader.class;
        }
        Field parentClassLoaderField = (Field)this.memberFinder.findOne(FieldCriteria.byScanUpTo(classLoaderBaseClass).name("parent"::equals), classLoaderBaseClass);
        Long offset = LowLevelObjectsHandler.getUnsafe().objectFieldOffset(parentClassLoaderField);
        ClassLoader exParent = (ClassLoader)LowLevelObjectsHandler.getUnsafe().getObject(classLoader, offset);
        LowLevelObjectsHandler.getUnsafe().putObject(classLoader, offset, futureParent);
        if (mantainHierarchy) {
            LowLevelObjectsHandler.getUnsafe().putObject(futureParent, offset, exParent);
        }
        return reset -> {
            if (reset.booleanValue()) {
                LowLevelObjectsHandler.getUnsafe().putObject(classLoader, offset, exParent);
            }
            return exParent;
        };
    }

    public ClassLoader getMasterClassLoader(ClassLoader classLoader) {
        ClassLoader child = classLoader;
        while (child.getParent() != null) {
            child = child.getParent();
        }
        return child;
    }
}

