/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dependencies;

import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.burningwave.Throwables;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.ComponentContainer;
import org.burningwave.core.assembler.ComponentSupplier;
import org.burningwave.core.classes.ClassHelper;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.hunter.ByteCodeHunter;
import org.burningwave.core.function.TriConsumer;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.FileSystemScanner;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.io.Streams;
import org.burningwave.core.jvm.LowLevelObjectsHandler;
import org.burningwave.tools.dependencies.Sniffer;

public class Capturer
implements Component {
    protected static final String ADDITIONAL_RESOURCES_PATH = "dependencies-capturer.additional-resources-path";
    ByteCodeHunter byteCodeHunter;
    PathHelper pathHelper;
    ClassHelper classHelper;
    FileSystemScanner fileSystemScanner;
    Collection<String> additionalClassPaths;
    LowLevelObjectsHandler lowLevelObjectsHandler;

    Capturer(FileSystemScanner fileSystemScanner, PathHelper pathHelper, ByteCodeHunter byteCodeHunter, ClassHelper classHelper) {
        this.fileSystemScanner = fileSystemScanner;
        this.byteCodeHunter = byteCodeHunter;
        this.pathHelper = pathHelper;
        this.classHelper = classHelper;
        this.additionalClassPaths = pathHelper.getPaths(new String[]{PathHelper.MAIN_CLASS_PATHS_EXTENSION, ADDITIONAL_RESOURCES_PATH});
    }

    public static Capturer create(ComponentSupplier componentSupplier) {
        return new Capturer(componentSupplier.getFileSystemScanner(), componentSupplier.getPathHelper(), componentSupplier.getByteCodeHunter(), componentSupplier.getClassHelper());
    }

    public static Capturer getInstance() {
        return LazyHolder.getCapturerInstance();
    }

    public Result capture(String mainClassName, Collection<String> _baseClassPaths, TriConsumer<String, String, ByteBuffer> resourceConsumer, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) {
        LinkedHashSet<String> baseClassPaths = new LinkedHashSet<String>(_baseClassPaths);
        baseClassPaths.addAll(this.additionalClassPaths);
        Result result = new Result();
        Function<JavaClass, Boolean> javaClassAdder = includeMainClass ? javaClass -> {
            result.put((JavaClass)javaClass);
            return true;
        } : javaClass -> {
            if (!javaClass.getName().equals(mainClassName)) {
                result.put((JavaClass)javaClass);
                return true;
            }
            return false;
        };
        result.findingTask = CompletableFuture.runAsync(() -> {
            try (Sniffer resourceSniffer = new Sniffer(null).init(false, this.fileSystemScanner, this.classHelper, baseClassPaths, javaClassAdder, fileSystemItem -> {
                result.putResource((FileSystemItem)fileSystemItem);
                return true;
            }, resourceConsumer);){
                try {
                    Class<?> cls = Class.forName(mainClassName, false, (ClassLoader)((Object)resourceSniffer));
                    cls.getMethod("main", String[].class).invoke(null, new Object[]{new String[0]});
                    if (continueToCaptureAfterSimulatorClassEndExecutionFor != null && continueToCaptureAfterSimulatorClassEndExecutionFor > 0L) {
                        Thread.sleep(continueToCaptureAfterSimulatorClassEndExecutionFor);
                    }
                }
                catch (Throwable exc) {
                    throw Throwables.toRuntimeException((Object)exc);
                }
                finally {
                    Capturer.createExecutor(result.getStore().getAbsolutePath(), mainClassName);
                }
            }
        });
        return result;
    }

    public Result captureAndStore(String mainClassName, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) {
        return this.captureAndStore(mainClassName, this.pathHelper.getMainClassPaths(), destinationPath, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor);
    }

    public Result captureAndStore(String mainClassName, Collection<String> baseClassPaths, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) {
        Result dependencies = this.capture(mainClassName, baseClassPaths, this.getStoreFunction(destinationPath), includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor);
        dependencies.store = FileSystemItem.ofPath((String)destinationPath);
        return dependencies;
    }

    TriConsumer<String, String, ByteBuffer> getStoreFunction(String destinationPath) {
        return (resourceAbsolutePath, resourceRelativePath, resourceContent) -> {
            String finalPath = this.getStoreEntryBasePath(destinationPath, (String)resourceAbsolutePath, (String)resourceRelativePath);
            FileSystemItem fileSystemItem = FileSystemItem.ofPath((String)(finalPath + "/" + resourceRelativePath));
            if (!fileSystemItem.exists()) {
                Streams.store((String)fileSystemItem.getAbsolutePath(), (ByteBuffer)resourceContent);
                this.logDebug("Resource {} has been stored to CLASSPATH {}", new Object[]{resourceRelativePath, fileSystemItem.getAbsolutePath()});
            }
        };
    }

    String getStoreEntryBasePath(String storeBasePath, String itemAbsolutePath, String ItemRelativePath) {
        String finalPath = itemAbsolutePath;
        if (finalPath.chars().filter(ch -> ch == 47).count() > 1L) {
            finalPath = finalPath.substring(0, finalPath.lastIndexOf(ItemRelativePath) - 1).substring(finalPath.indexOf("/") + 1);
            finalPath = "[" + finalPath.replace("/", "][") + "]";
        } else {
            finalPath = finalPath.replace("/", "");
        }
        return storeBasePath + "/" + this.getReducedPath(finalPath);
    }

    private String getReducedPath(String path) {
        String temp = path.substring(0, path.lastIndexOf("["));
        temp = temp.substring(0, temp.lastIndexOf("["));
        return path.substring(temp.lastIndexOf("["));
    }

    static void createExecutor(String destinationPath, String mainClassName) {
        try {
            String externalExecutor = FileSystemItem.ofPath((String)System.getProperty("java.home")).getAbsolutePath() + "/bin/java -classpath \"" + String.join((CharSequence)";", FileSystemItem.ofPath((String)destinationPath).getChildren().stream().map(fileSystemItem -> fileSystemItem.getAbsolutePath()).collect(Collectors.toList())) + "\" " + mainClassName;
            Files.write(Paths.get(destinationPath + "\\executor-" + UUID.randomUUID().toString() + ".cmd", new String[0]), externalExecutor.getBytes(), new OpenOption[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static class LazyHolder {
        static final Capturer CAPTURER_INSTANCE = Capturer.create((ComponentSupplier)ComponentContainer.getInstance());

        LazyHolder() {
        }

        static Capturer getCapturerInstance() {
            return CAPTURER_INSTANCE;
        }
    }

    public static class Result
    implements Component {
        CompletableFuture<Void> findingTask;
        Collection<FileSystemItem> resources;
        Collection<JavaClass> javaClasses = new CopyOnWriteArrayList<JavaClass>();
        FileSystemItem store;

        Result() {
            this.resources = new CopyOnWriteArrayList<FileSystemItem>();
        }

        public void putResource(FileSystemItem fileSystemItem) {
            this.resources.add(fileSystemItem);
        }

        JavaClass put(JavaClass javaClass) {
            this.javaClasses.add(javaClass);
            return javaClass;
        }

        public Collection<JavaClass> getJavaClasses() {
            return this.javaClasses;
        }

        public Collection<FileSystemItem> getResources() {
            return this.resources;
        }

        public JavaClass getJavaClass(Predicate<JavaClass> predicate) {
            return this.getJavaClasses().stream().filter(predicate).findFirst().orElseGet(() -> null);
        }

        public Collection<FileSystemItem> getResources(Predicate<FileSystemItem> predicate) {
            return this.getResources().stream().filter(predicate).collect(Collectors.toSet());
        }

        public CompletableFuture<Void> getFindingTask() {
            return this.findingTask;
        }

        public void waitForTaskEnding() {
            this.findingTask.join();
        }

        public FileSystemItem getStore() {
            return this.store;
        }

        public void close() {
            this.findingTask.cancel(true);
            this.findingTask = null;
            this.resources.clear();
            this.resources = null;
            this.javaClasses.clear();
            this.javaClasses = null;
            this.store = null;
        }
    }
}

