/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.tools.dependencies;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.burningwave.core.assembler.ComponentContainer;
import org.burningwave.core.assembler.ComponentSupplier;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ByteCodeHunter;
import org.burningwave.core.classes.CacheableSearchConfig;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.Classes;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.SearchConfig;
import org.burningwave.core.function.ThrowingSupplier;
import org.burningwave.core.function.TriConsumer;
import org.burningwave.core.io.FileScanConfig;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.FileSystemScanner;
import org.burningwave.core.io.PathHelper;
import org.burningwave.tools.dependencies.Capturer;
import org.burningwave.tools.dependencies.Sniffer;

public class TwoPassCapturer
extends Capturer {
    ClassPathHunter classPathHunter;
    PathHelper pathHelper;

    private TwoPassCapturer(FileSystemScanner fileSystemScanner, PathHelper pathHelper, ByteCodeHunter byteCodeHunter, ClassPathHunter classPathHunter, Classes.Loaders classesLoaders) {
        super(fileSystemScanner, byteCodeHunter, classesLoaders);
        this.pathHelper = pathHelper;
        this.classPathHunter = classPathHunter;
    }

    public static TwoPassCapturer create(ComponentSupplier componentSupplier) {
        return new TwoPassCapturer(componentSupplier.getFileSystemScanner(), componentSupplier.getPathHelper(), componentSupplier.getByteCodeHunter(), componentSupplier.getClassPathHunter(), componentSupplier.getClassesLoaders());
    }

    public static TwoPassCapturer getInstance() {
        return LazyHolder.getCapturerInstance();
    }

    @Override
    public Result capture(String mainClassName, Collection<String> baseClassPaths, TriConsumer<String, String, ByteBuffer> resourceConsumer, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) {
        return this.capture(mainClassName, baseClassPaths, resourceConsumer, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor, true);
    }

    public Result capture(String mainClassName, Collection<String> baseClassPaths, TriConsumer<String, String, ByteBuffer> resourceConsumer, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor, boolean recursive) {
        StaticComponentContainer.LowLevelObjectsHandler.disableIllegalAccessLogger();
        Result result = new Result(this.fileSystemScanner, javaClass -> true, fileSystemItem -> true);
        result.findingTask = CompletableFuture.runAsync(() -> {
            try (Sniffer resourceSniffer = new Sniffer(null).init(!recursive, this.fileSystemScanner, this.classesLoaders, baseClassPaths, result.javaClassFilter, result.resourceFilter, resourceConsumer);){
                ThrowingSupplier mainClassSupplier = recursive ? () -> Class.forName(mainClassName, false, (ClassLoader)((Object)resourceSniffer)) : () -> Class.forName(mainClassName);
                try {
                    ((Class)mainClassSupplier.get()).getMethod("main", String[].class).invoke(null, new Object[]{new String[0]});
                    if (continueToCaptureAfterSimulatorClassEndExecutionFor != null && continueToCaptureAfterSimulatorClassEndExecutionFor > 0L) {
                        Thread.sleep(continueToCaptureAfterSimulatorClassEndExecutionFor);
                    }
                }
                catch (Throwable exc) {
                    this.logError("Exception occurred", exc);
                    throw StaticComponentContainer.Throwables.toRuntimeException((Object)exc);
                }
            }
            if (recursive) {
                try {
                    this.launchExternalCapturer(mainClassName, result.getStore().getAbsolutePath(), baseClassPaths, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor);
                }
                catch (IOException | InterruptedException exc) {
                    throw StaticComponentContainer.Throwables.toRuntimeException((Object)exc);
                }
            }
            if (recursive && !includeMainClass) {
                JavaClass mainJavaClass = result.getJavaClass(javaClass -> javaClass.getName().equals(mainClassName));
                Collection<FileSystemItem> mainJavaClassesFiles = result.getResources(fileSystemItem -> fileSystemItem.getAbsolutePath().endsWith(mainJavaClass.getPath()));
                FileSystemItem store = result.getStore();
                for (FileSystemItem fileSystemItem2 : mainJavaClassesFiles) {
                    StaticComponentContainer.FileSystemHelper.delete(fileSystemItem2.getAbsolutePath());
                    for (fileSystemItem2 = fileSystemItem2.getParent(); fileSystemItem2 != null && !fileSystemItem2.getAbsolutePath().equals(store.getAbsolutePath()) && fileSystemItem2.getChildren().isEmpty(); fileSystemItem2 = fileSystemItem2.getParent()) {
                        StaticComponentContainer.FileSystemHelper.delete(fileSystemItem2.getAbsolutePath());
                    }
                }
            }
            StaticComponentContainer.LowLevelObjectsHandler.enableIllegalAccessLogger();
        });
        return result;
    }

    private Result captureAndStore(String mainClassName, Collection<String> baseClassPaths, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor, boolean recursive) {
        Result dependencies = this.capture(mainClassName, baseClassPaths, this.getStoreFunction(destinationPath), includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor, recursive);
        dependencies.store = FileSystemItem.ofPath((String)destinationPath);
        return dependencies;
    }

    private void launchExternalCapturer(String mainClassName, String destinationPath, Collection<String> baseClassPaths, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) throws IOException, InterruptedException {
        Set<String> classPaths = FileSystemItem.ofPath((String)destinationPath).getChildren(fileSystemItem -> !fileSystemItem.getAbsolutePath().endsWith("[org.burningwave]")).stream().map(child -> child.getAbsolutePath()).collect(Collectors.toSet());
        ClassPathHunter.SearchResult searchResult = (ClassPathHunter.SearchResult)this.classPathHunter.findBy((CacheableSearchConfig)SearchConfig.forPaths((Collection)this.pathHelper.getMainClassPaths()).by(ClassCriteria.create().className(clsName -> clsName.equals(this.getClass().getName()) || clsName.equals(ComponentSupplier.class.getName()))));
        LinkedHashSet<String> classPathsToBeScanned = new LinkedHashSet<String>(baseClassPaths);
        classPathsToBeScanned.remove(destinationPath);
        for (FileSystemItem classPath : searchResult.getClassPaths()) {
            if (classPaths.contains(classPath.getAbsolutePath())) continue;
            classPaths.add(classPath.getAbsolutePath());
        }
        ProcessBuilder processBuilder = System.getProperty("os.name").toLowerCase().contains("windows") ? this.getProcessBuilderForWindows(classPaths, classPathsToBeScanned, mainClassName, destinationPath, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor) : this.getProcessBuilderForUnix(classPaths, classPathsToBeScanned, mainClassName, destinationPath, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor);
        Process process = processBuilder.start();
        process.waitFor();
    }

    private ProcessBuilder getProcessBuilderForWindows(Collection<String> classPaths, Collection<String> classPathsToBeScanned, String mainClassName, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) throws IOException {
        String javaExecutablePath = System.getProperty("java.home") + "/bin/java";
        LinkedList<String> command = new LinkedList<String>();
        command.add(StaticComponentContainer.Paths.clean(javaExecutablePath));
        command.add("-classpath");
        StringBuffer generatedClassPath = new StringBuffer();
        generatedClassPath.append("\"");
        if (!classPaths.isEmpty()) {
            generatedClassPath.append(String.join((CharSequence)System.getProperty("path.separator"), classPaths));
        }
        generatedClassPath.append("\"");
        command.add(generatedClassPath.toString());
        command.add(this.getClass().getName());
        command.add("\"" + String.join((CharSequence)System.getProperty("path.separator"), classPathsToBeScanned) + "\"");
        command.add(mainClassName);
        command.add("\"" + destinationPath + "\"");
        command.add(Boolean.valueOf(includeMainClass).toString());
        command.add(continueToCaptureAfterSimulatorClassEndExecutionFor.toString());
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        return processBuilder.inheritIO();
    }

    private ProcessBuilder getProcessBuilderForUnix(Collection<String> classPaths, Collection<String> classPathsToBeScanned, String mainClassName, String destinationPath, boolean includeMainClass, Long continueToCaptureAfterSimulatorClassEndExecutionFor) throws IOException {
        String javaExecutablePath = System.getProperty("java.home") + "/bin/java";
        LinkedList<String> command = new LinkedList<String>();
        command.add(StaticComponentContainer.Paths.clean(javaExecutablePath));
        command.add("-classpath");
        StringBuffer generatedClassPath = new StringBuffer();
        if (!classPaths.isEmpty()) {
            generatedClassPath.append(String.join((CharSequence)System.getProperty("path.separator"), classPaths));
        }
        command.add(generatedClassPath.toString());
        command.add(this.getClass().getName());
        command.add(String.join((CharSequence)System.getProperty("path.separator"), classPathsToBeScanned));
        command.add(mainClassName);
        command.add(destinationPath);
        command.add(Boolean.valueOf(includeMainClass).toString());
        command.add(continueToCaptureAfterSimulatorClassEndExecutionFor.toString());
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        return processBuilder.inheritIO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ClassNotFoundException {
        TwoPassCapturer capturer = TwoPassCapturer.getInstance();
        try {
            List<String> paths = Arrays.asList(args[0].split(System.getProperty("path.separator")));
            String mainClassName = args[1];
            String destinationPath = args[2];
            boolean includeMainClass = Boolean.valueOf(args[3]);
            long continueToCaptureAfterSimulatorClassEndExecutionFor = Long.valueOf(args[4]);
            capturer.captureAndStore(mainClassName, paths, destinationPath, includeMainClass, continueToCaptureAfterSimulatorClassEndExecutionFor, false).waitForTaskEnding();
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggersRepository.logError(TwoPassCapturer.class, "Exception occurred", exc);
        }
        finally {
            String suffix = UUID.randomUUID().toString();
            capturer.logReceivedParameters(args, 0L, suffix);
            capturer.createExecutor(args[2], args[1], suffix);
        }
    }

    private void logReceivedParameters(String[] args, long wait, String fileSuffix) {
        try {
            String logs = "classpath: " + System.getProperty("java.class.path") + "\npath to be scanned: " + String.join((CharSequence)System.getProperty("path.separator"), Arrays.asList(args[0].split(System.getProperty("path.separator")))) + "\nmainClassName: " + args[1] + "\ndestinationPath: " + args[2] + "\nincludeMainClass: " + args[3] + "\ncontinueToCaptureAfterSimulatorClassEndExecutionFor: " + args[4];
            Files.write(Paths.get(args[2] + "/params-" + fileSuffix + ".txt", new String[0]), logs.getBytes(), new OpenOption[0]);
            StaticComponentContainer.ManagedLoggersRepository.logDebug(TwoPassCapturer.class, "\n\n" + logs + "\n\n");
            if (wait > 0L) {
                Thread.sleep(wait);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static class LazyHolder {
        private static final TwoPassCapturer CAPTURER_INSTANCE = TwoPassCapturer.create((ComponentSupplier)ComponentContainer.getInstance());

        private LazyHolder() {
        }

        private static TwoPassCapturer getCapturerInstance() {
            return CAPTURER_INSTANCE;
        }
    }

    private static class Result
    extends Capturer.Result {
        FileSystemScanner fileSystemScanner;
        Function<JavaClass, Boolean> javaClassFilter;
        Function<FileSystemItem, Boolean> resourceFilter;

        Result(FileSystemScanner fileSystemScanner, Function<JavaClass, Boolean> javaClassFilter, Function<FileSystemItem, Boolean> resourceFilter) {
            this.fileSystemScanner = fileSystemScanner;
            this.javaClassFilter = javaClassFilter;
            this.resourceFilter = resourceFilter;
            this.javaClasses = null;
            this.resources = null;
        }

        @Override
        public Collection<JavaClass> getJavaClasses() {
            if (this.javaClasses != null) {
                return this.javaClasses;
            }
            return this.loadResourcesAndJavaClasses().getValue();
        }

        @Override
        public Collection<FileSystemItem> getResources() {
            if (this.resources != null) {
                return this.resources;
            }
            return this.loadResourcesAndJavaClasses().getKey();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map.Entry<Collection<FileSystemItem>, Collection<JavaClass>> loadResourcesAndJavaClasses() {
            Map.Entry<Collection<FileSystemItem>, Collection<JavaClass>> itemsFound = null;
            if (this.findingTask.isDone() && this.resources == null) {
                String string = this.toString() + "_resources";
                synchronized (string) {
                    if (this.resources == null) {
                        itemsFound = this.retrieveResources();
                        this.resources = itemsFound.getKey();
                        this.javaClasses = itemsFound.getValue();
                        return itemsFound;
                    }
                }
            }
            return this.retrieveResources();
        }

        private Map.Entry<Collection<FileSystemItem>, Collection<JavaClass>> retrieveResources() {
            ConcurrentHashMap.KeySetView resources = ConcurrentHashMap.newKeySet();
            ConcurrentHashMap.KeySetView javaClasses = ConcurrentHashMap.newKeySet();
            AbstractMap.SimpleEntry<Collection<FileSystemItem>, Collection<JavaClass>> itemsFound = new AbstractMap.SimpleEntry<Collection<FileSystemItem>, Collection<JavaClass>>(resources, javaClasses);
            this.fileSystemScanner.scan(FileScanConfig.forPaths((Collection)this.store.getChildren().stream().filter(fileSystemItem -> fileSystemItem.isFolder()).map(fileSystemItem -> fileSystemItem.getAbsolutePath()).collect(Collectors.toSet())).toScanConfiguration(FileSystemItem.getFilteredConsumerForFileSystemScanner(fileSystemItem -> this.resourceFilter.apply((FileSystemItem)fileSystemItem), fileSystemItem -> {
                resources.add(fileSystemItem);
                if (fileSystemItem.getExtension().equals("class")) {
                    javaClasses.add(JavaClass.create((ByteBuffer)fileSystemItem.toByteBuffer()));
                }
            })));
            return itemsFound;
        }
    }
}

