/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.annotation.AbstractProxySubscriber;
import org.bushe.swing.event.annotation.ReferenceStrength;

public class BaseProxySubscriber
extends AbstractProxySubscriber
implements EventSubscriber {
    private Class subscriptionClass;

    public BaseProxySubscriber(Object proxiedSubscriber, Method subscriptionMethod, ReferenceStrength referenceStrength, EventService es, Class subscription) {
        this(proxiedSubscriber, subscriptionMethod, referenceStrength, 0, es, subscription);
    }

    public BaseProxySubscriber(Object proxiedSubscriber, Method subscriptionMethod, ReferenceStrength referenceStrength, int priority, EventService es, Class subscription) {
        super(proxiedSubscriber, subscriptionMethod, referenceStrength, priority, es);
        this.subscriptionClass = subscription;
        Class<?>[] params = subscriptionMethod.getParameterTypes();
        if (params == null || params.length != 1 || params[0].isPrimitive()) {
            throw new IllegalArgumentException("The subscriptionMethod must have a single non-primitive parameter.");
        }
    }

    public void onEvent(Object event) {
        Object[] args = new Object[]{event};
        Method subscriptionMethod = null;
        Object obj = null;
        try {
            obj = this.getProxiedSubscriber();
            if (obj == null) {
                return;
            }
            subscriptionMethod = this.getSubscriptionMethod();
            subscriptionMethod.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            String message = "Exception when invoking annotated method from EventService publication.  Event class:" + event.getClass() + ", Event:" + event + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod();
            this.retryReflectiveCallUsingAccessibleObject(args, subscriptionMethod, obj, e, message);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("InvocationTargetException when invoking annotated method from EventService publication.  Event class:" + event.getClass() + ", Event:" + event + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod(), e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseProxySubscriber) {
            if (!super.equals(obj)) {
                return false;
            }
            BaseProxySubscriber bps = (BaseProxySubscriber)obj;
            if (this.subscriptionClass != bps.subscriptionClass) {
                if (this.subscriptionClass == null) {
                    return false;
                }
                if (!this.subscriptionClass.equals(bps.subscriptionClass)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "BaseProxySubscriber{subscription=" + this.subscriptionClass + "realSubscriber=" + this.getProxiedSubscriber() + ", subscriptionMethod=" + this.getSubscriptionMethod() + ", referenceStrength=" + (Object)((Object)this.getReferenceStrength()) + ", eventService=" + this.getEventService() + '}';
    }
}

