///<reference path="../../node_modules/trivial-components/dist/js/bundle/trivial-components-global.d.ts"/>
///<reference path="../../node_modules/@types/mustache/index.d.ts"/>
var ButterFaces;
(function (ButterFaces) {
    function createTrivialTagComponent($input, options) {
        return new TrivialComponents.TrivialTagComboBox($input, {
            autoComplete: options.autoComplete,
            allowFreeText: true,
            showTrigger: options.showTrigger,
            distinct: options.distinct,
            editingMode: options.editingMode,
            matchingOptions: {
                matchingMode: "contains",
                ignoreCase: true,
                maxLevenshteinDistance: 0
            },
            maxSelectedEntries: options.maxSelectedEntries,
            selectedEntries: options.selectedEntries,
            freeTextSeparators: options.freeTextSeparators,
            entries: options.entries,
            valueFunction: function (entries) {
                return entries
                    .map(function (entry) { return entry.id != null ? entry.id : entry.title; })
                    .join(",");
            },
            freeTextEntryFactory: function (freeText) {
                return { title: escapeHtml(freeText) };
            },
            entryRenderingFunction: function (entry) { return "<div>" + entry.title + "</div>"; },
        });
        function escapeHtml(source) {
            /* tslint:disable */
            var entityMap = {
                "&": "&amp;",
                "<": "&lt;",
                ">": "&gt;",
                '"': "&quot;",
                "'": "&#39;",
                "/": "&#x2F;"
            };
            /* tslint:enable */
            return source.replace(/[&<>"'\/]/g, function (s) { return entityMap[s]; });
        }
    }
    ButterFaces.createTrivialTagComponent = createTrivialTagComponent;
    function createTrivialTreeComponent($input, options) {
        return new TrivialComponents.TrivialTree($input, {
            searchBarMode: options.searchBarMode,
            selectedEntryId: options.selectedEntryId,
            performanceOptimizationSettings: options.performanceOptimizationSettings,
            entryRenderingFunction: function (entry, depth) { return Mustache.render(options.templates[Math.min(options.templates.length - 1, depth)], entry); },
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries,
            queryFunction: TrivialComponents.customTreeQueryFunctionFactory(options.entries, "children", "expanded", function (entry, queryString, nodeDepth) {
                // TODO remove null parameter after trivial component is fixed
                var titleMatches = entry.title && TrivialComponents.trivialMatch(entry.title, queryString, null).length > 0;
                var descriptionMatches = entry.description && TrivialComponents.trivialMatch(entry.description, queryString, null).length > 0;
                return titleMatches || descriptionMatches;
            })
        });
    }
    ButterFaces.createTrivialTreeComponent = createTrivialTreeComponent;
    function createTrivialComboBox($input, options) {
        return new TrivialComponents.TrivialComboBox($input, {
            allowFreeText: false,
            entryToEditorTextFunction: function (entry) { return entry[options.inputTextProperty]; },
            entryRenderingFunction: function (entry) {
                return Mustache.render(options.template, entry);
            },
            selectedEntryRenderingFunction: function (entry) {
                if (!entry || entry._isEmptyEntry) {
                    return options.emptyEntryTemplate || "";
                }
                else if (options.selectedEntryTemplate) {
                    return Mustache.render(options.selectedEntryTemplate, entry);
                }
                else {
                    return Mustache.render(options.template, entry);
                }
            },
            editingMode: options.editingMode,
            showClearButton: options.showClearButton,
            selectedEntry: options.selectedEntry,
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries
        });
    }
    ButterFaces.createTrivialComboBox = createTrivialComboBox;
    function createTrivialTreeComboBox($input, options) {
        return new TrivialComponents.TrivialTreeComboBox($input, {
            allowFreeText: false,
            entryToEditorTextFunction: function (entry) { return entry[options.inputTextProperty]; },
            entryRenderingFunction: function (entry, depth) { return Mustache.render(options.templates[Math.min(options.templates.length - 1, depth)], entry); },
            selectedEntryRenderingFunction: function (entry) {
                if (!entry || entry._isEmptyEntry) {
                    return options.emptyEntryTemplate || "";
                }
                else if (options.selectedEntryTemplate) {
                    return Mustache.render(options.selectedEntryTemplate, entry);
                }
                else {
                    return Mustache.render(options.templates[0], entry);
                }
            },
            editingMode: options.editingMode,
            showClearButton: options.showClearButton,
            selectedEntry: options.selectedEntry,
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries,
            queryFunction: TrivialComponents.customTreeQueryFunctionFactory(options.entries, "children", "expanded", function (entry, queryString, nodeDepth) {
                // TODO remove null parameter after trivial component is fixed
                var titleMatches = entry.title && TrivialComponents.trivialMatch(entry.title, queryString, null).length > 0;
                var descriptionMatches = entry.description && TrivialComponents.trivialMatch(entry.description, queryString, null).length > 0;
                return titleMatches || descriptionMatches;
            })
        });
    }
    ButterFaces.createTrivialTreeComboBox = createTrivialTreeComboBox;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
