/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.html.HtmlCheckBox;
import org.butterfaces.component.html.HtmlInputComponent;
import org.butterfaces.component.partrenderer.CheckBoxReadonlyPartRenderer;
import org.butterfaces.component.partrenderer.InnerComponentCheckBoxWrapperPartRenderer;
import org.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import org.butterfaces.util.StringJoiner;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.component.renderkit.html_basic.CheckBoxRenderer")
public class CheckBoxRenderer
extends AbstractHtmlTagRenderer<HtmlCheckBox> {
    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.encodeBegin(context, component, "butter-component-checkbox");
    }

    @Override
    protected void encodeEndInnerWrapper(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlCheckBox checkBox = (HtmlCheckBox)component;
        if (checkBox.isSwitch() && !checkBox.isReadonly()) {
            writer.startElement("label", component);
            writer.writeAttribute("class", (Object)"custom-control-label", "styleClass");
            writer.writeAttribute("for", (Object)this.createInputClientId(FacesContext.getCurrentInstance(), component), "for");
            writer.endElement("label");
        }
        new InnerComponentCheckBoxWrapperPartRenderer().renderInnerWrapperEnd(checkBox, writer);
    }

    @Override
    protected void encodeBeginInnerWrapper(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlCheckBox checkBox = (HtmlCheckBox)component;
        new InnerComponentCheckBoxWrapperPartRenderer().renderInnerWrapperBegin(checkBox, writer);
    }

    @Override
    protected void renderInputStyleClass(HtmlInputComponent component, ResponseWriter writer) throws IOException {
        String validationMarkerClass = !component.isValid() ? "butter-component-invalid is-invalid" : null;
        String switchClass = ((HtmlCheckBox)component).isSwitch() ? "custom-control-input" : null;
        String styleClass = StringJoiner.on(" ").join("butter-input-component").join("mt-1 mr-2").join(switchClass).join(validationMarkerClass).toString();
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (!(component instanceof HtmlCheckBox)) {
            return;
        }
        HtmlCheckBox checkBox = (HtmlCheckBox)component;
        if (!component.isRendered() || checkBox.isReadonly()) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        this.setSubmittedValue(component, CheckBoxRenderer.isChecked((String)requestMap.get(clientId)));
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return submittedValue instanceof Boolean ? submittedValue : Boolean.valueOf(submittedValue.toString());
    }

    @Override
    protected void encodeTagType(UIComponent component, ResponseWriter writer) throws IOException {
        writer.writeAttribute("type", (Object)"checkbox", "type");
    }

    @Override
    protected void encodeReadonly(HtmlCheckBox htmlComponent, ResponseWriter writer) throws IOException {
        if (this.encodeReadonly()) {
            new CheckBoxReadonlyPartRenderer().renderReadonly(htmlComponent, writer);
        }
    }

    @Override
    protected void encodeAdditionalTagAttributes(UIComponent component, ResponseWriter writer, String currentValue) throws IOException {
        if (Boolean.valueOf(currentValue).booleanValue()) {
            writer.writeAttribute("checked", (Object)Boolean.TRUE, "value");
        }
    }

    private static boolean isChecked(String value) {
        return "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }
}

