///<reference path="../type-definition/jsf-ajax/index.d.ts"/>
///<reference path="butterfaces-overlay.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Ajax = /** @class */ (function () {
        function Ajax() {
        }
        Ajax.sendRequest = function (clientId, event, renderIds, /*optional string */ params, disableRenderIds) {
            jsf.ajax.request(clientId, event, {
                "javax.faces.behavior.event": event,
                render: renderIds.join(", "),
                params: params,
                "butterfaces.params": params,
                onevent: (function (data) {
                    // console.log(data);
                    if (disableRenderIds) {
                        ButterFaces.Ajax.disableElementsOnRequest(data, renderIds);
                    }
                })
            });
        };
        Ajax.disableElementsOnRequest = function (data, ids) {
            var status = data.status;
            // console.log(data);
            // console.log(ids);
            switch (status) {
                case "begin": // Before the ajax request is sent.
                    // console.log('ajax request begin');
                    for (var i = 0; i < ids.length; i++) {
                        var $elementToDisable = $(document.getElementById(ids[i]));
                        if ($elementToDisable.length !== 0) {
                            // console.log('disable ' + ids[i]);
                            new ButterFaces.Overlay(0, false, document.getElementById(ids[i])).show();
                            // console.log('disablee ' + ids[i]);
                        }
                    }
                    break;
                case "complete": // After the ajax response is arrived.
                    // console.log('ajax request complete');
                    break;
                case "success": // After update of HTML DOM based on ajax response..
                    // console.log('ajax request success');
                    for (var i = 0; i < ids.length; i++) {
                        var $elementToEmable = $(document.getElementById(ids[i]));
                        if ($elementToEmable.length !== 0) {
                            // console.log('enable ' + ids[i]);
                            new ButterFaces.Overlay(0, false, document.getElementById(ids[i])).hide();
                            // console.log('enabled ' + ids[i]);
                        }
                    }
                    break;
            }
        };
        return Ajax;
    }());
    ButterFaces.Ajax = Ajax;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/**
 * jQuery-Plugin "Expanded TextAreas" for expandable text areas. It is used for the JSF-Component "b:textarea".
 * Works with at least jQuery 1.7.
 *
 * How to use:
 * jQuery("#someTextAreaSelector").butterExpandable();
 */
(function ($) {
    // you have to extend jQuery with the fn["pluginName"] notation because in Typescript you can't extend
    // the existing typing interface with fn.pluginName!
    $.fn["butterExpandable"] = function () {
        return this.each(function (index, element) {
            var rootElement = $(element);
            if (rootElement.find("textarea").length > 0) {
                new ButterFaces.TextareaExpandable(rootElement);
            }
            else {
                new ButterFaces.DivExpandable(rootElement);
            }
        });
    };
})(jQuery);
var ButterFaces;
(function (ButterFaces) {
    var EXPAND_HEIGHT = 250; //in px
    var EXPAND_WIDTH = 500; //in px
    var ANIMATION_DURATION = 200; //in ms
    var REPOSITION_INTERVAL = 500; //in ms
    var EASING = "swing";
    var KEYCODE_ESCAPE = 27;
    var AbstractExpandable = /** @class */ (function () {
        function AbstractExpandable(rootElement) {
            this.rootElement = rootElement;
        }
        AbstractExpandable.prototype.expandElement = function (event) {
            var _this = this;
            if (this.isExpansionEventIgnored(event)) {
                return;
            }
            this.initialHeight = this.originalElement.outerHeight();
            this.initialWidth = this.originalElement.outerWidth();
            this.initialOffset = this.originalElement.offset();
            //create a ghost element that be animated on gets the focus
            this.ghostElement = this.createGhostElement();
            this.transferValueToGhostElement();
            this.ghostElement.css("width", this.initialWidth)
                .css("height", this.initialHeight)
                .css("position", "absolute")
                .css("top", this.initialOffset.top)
                .css("left", this.initialOffset.left)
                .css("z-index", 2000)
                .css("box-shadow", "5px 5px 5px 0 #999")
                .addClass("butter-component-expandable-ghost")
                .appendTo($("body"))
                .animate({
                height: EXPAND_HEIGHT,
                width: this.initialWidth > EXPAND_WIDTH ? this.initialWidth : EXPAND_WIDTH
            }, ANIMATION_DURATION, EASING, function () {
                $(document)
                    .on("click.expandable", function (event) {
                    _this.handleMouseClick(event);
                })
                    .on("keydown.expandable", function (event) {
                    _this.handleEscapeKey(event);
                });
                $(window).on("resize.expandable", function () {
                    _this.repositionGhostElement();
                });
                //keep track of the orginal element"s position
                _this.positionTriggerInterval = window.setInterval(function () { return _this.repositionGhostElement; }, REPOSITION_INTERVAL);
            });
            //make original invisible
            this.originalElement
                .css("visibility", "hidden")
                .siblings()
                .css("visibility", "hidden");
            this.onGhostElementCreated();
        };
        /**
         * Collapses the ghost element and sets the value if not isCancelled
         * @param isCancelled
         */
        AbstractExpandable.prototype.collapseElement = function (cancelled) {
            // "cancelled" can be an event object
            var isCancelled = typeof cancelled === "boolean" && cancelled;
            $(document)
                .off("click.expandable")
                .off("keydown.expandable");
            //make original visible again
            this.originalElement
                .css("visibility", "visible")
                .siblings()
                .css("visibility", "visible");
            var self = this;
            this.ghostElement.animate({
                height: self.initialHeight,
                width: self.initialWidth
            }, ANIMATION_DURATION, EASING, function () {
                //on animation complete
                self.onGhostElementCollapsed(isCancelled);
                //delete the ghost element
                self.ghostElement.remove();
                self.ghostElement = null;
                //delete position trigger timeout and resize listener
                window.clearInterval(self.positionTriggerInterval);
                $(window).off("resize.expandable");
            });
        };
        AbstractExpandable.prototype.handleMouseClick = function (event) {
            // collapse ghost element if user clicks beside it
            if (!$(event.target).is(".butter-component-expandable-ghost")) {
                this.collapseElement(false);
            }
        };
        AbstractExpandable.prototype.handleEscapeKey = function (event) {
            if (event.which === KEYCODE_ESCAPE) {
                this.collapseElement(true);
            }
        };
        AbstractExpandable.prototype.repositionGhostElement = function () {
            //keep track of window resizing and reposition the ghost element
            if (this.ghostElement !== undefined && this.ghostElement != null) {
                this.initialOffset = this.originalElement.offset();
                this.ghostElement
                    .css("top", this.initialOffset.top)
                    .css("left", this.initialOffset.left);
            }
        };
        return AbstractExpandable;
    }());
    var DivExpandable = /** @class */ (function (_super) {
        __extends(DivExpandable, _super);
        function DivExpandable(rootElement) {
            var _this = _super.call(this, rootElement) || this;
            _this.originalElement = _this.rootElement.find(".butter-component-value-readonly");
            _this.rearrangeOriginalElementStructure();
            return _this;
        }
        DivExpandable.prototype.rearrangeOriginalElementStructure = function () {
            var _this = this;
            var _label = this.rootElement.find(".butter-component-label");
            this.originalElement
                .addClass("butter-component-expandable-original")
                .click(function (event) {
                _this.expandElement(event);
            })
                .detach();
            var _container = $("<div>")
                .addClass("butter-component-expandable-readonly-container")
                .insertAfter(_label);
            var _icon = $("<span>").addClass("input-group-text glyphicon glyphicon-resize-full");
            this.originalElement.appendTo(_container);
            $("<div>")
                .addClass("butter-component-expandable-readonly-icon")
                .append(_icon)
                .appendTo(_container);
        };
        DivExpandable.prototype.createGhostElement = function () {
            return $("<div>");
        };
        DivExpandable.prototype.isExpansionEventIgnored = function (event) {
            return false;
        };
        DivExpandable.prototype.onGhostElementCreated = function () {
            // do nothing
        };
        DivExpandable.prototype.onGhostElementCollapsed = function (isCancelled) {
            // do nothing
        };
        DivExpandable.prototype.transferValueToGhostElement = function () {
            $("<div>")
                .html(this.originalElement.html())
                .addClass("butter-component-expandable-ghost-readonlyContent")
                .appendTo(this.ghostElement);
        };
        return DivExpandable;
    }(AbstractExpandable));
    ButterFaces.DivExpandable = DivExpandable;
    var TextareaExpandable = /** @class */ (function (_super) {
        __extends(TextareaExpandable, _super);
        function TextareaExpandable(rootElement) {
            var _this = _super.call(this, rootElement) || this;
            _this.blockFocusEventOnOriginal = false;
            _this.blockBlurEventOnOriginal = false;
            _this.originalElement = _this.rootElement.find("textarea");
            _this.originalElement.addClass("butter-component-expandable-original");
            _this.originalElement.focus(function (event) {
                _this.expandElement(event);
            });
            _this.originalElement.blur(function (event) {
                _this.handleBlurEvent(event);
            });
            _this.addInputGroupAddon();
            return _this;
        }
        TextareaExpandable.prototype.addInputGroupAddon = function () {
            this.originalElement
                .addClass("form-control")
                .parent()
                .addClass("input-group");
            $("<span class=\"input-group-append\"><span class=\"input-group-text glyphicon glyphicon-resize-full\"></span></span>")
                .insertAfter(this.originalElement);
        };
        TextareaExpandable.prototype.handleBlurEvent = function (event) {
            if (this.blockBlurEventOnOriginal) {
                // prevent blur event bubbling, so it will not be triggered in jsf
                event.preventDefault();
            }
        };
        TextareaExpandable.prototype.createGhostElement = function () {
            return $("<textarea>");
        };
        TextareaExpandable.prototype.isExpansionEventIgnored = function (event) {
            this.blockBlurEventOnOriginal = true;
            if (this.blockFocusEventOnOriginal) {
                event.preventDefault();
                return true;
            }
            else {
                return false;
            }
        };
        TextareaExpandable.prototype.onGhostElementCreated = function () {
            var _this = this;
            this.ghostElement
                .blur(function (event) {
                _this.collapseElement(event);
            })
                .focus();
            this.moveCaretToEnd(this.ghostElement);
        };
        TextareaExpandable.prototype.onGhostElementCollapsed = function (isCancelled) {
            var _this = this;
            if (!isCancelled) {
                //transfer value back from ghost to original
                this.originalElement.val(this.ghostElement.val());
                // trigger blur and keyup event on original textarea and don"t block
                // it for jsf
                this.blockBlurEventOnOriginal = false;
                this.blockFocusEventOnOriginal = true;
                // defer the events a little bit, look at
                // (http://stackoverflow.com/questions/8380759/why-isnt-this-textarea-focusing-with-focus#8380785)
                window.setTimeout(function () {
                    _this.originalElement.trigger("keyup");
                    _this.originalElement.trigger("change");
                    _this.originalElement.trigger("blur");
                    _this.blockFocusEventOnOriginal = false;
                }, 50);
            }
            else {
                this.blockBlurEventOnOriginal = true;
                this.blockFocusEventOnOriginal = false;
            }
        };
        TextareaExpandable.prototype.transferValueToGhostElement = function () {
            this.ghostElement.val(this.originalElement.val());
        };
        TextareaExpandable.prototype.moveCaretToEnd = function (element) {
            if (typeof element.selectionStart === "number") {
                element.selectionStart = element.selectionEnd = element.value.length;
            }
            else if (typeof element.createTextRange !== "undefined") {
                var range = element.createTextRange();
                range.collapse(false);
                range.select();
            }
            else {
                var strLength = this.ghostElement.val().length * 2;
                this.ghostElement.get(0).setSelectionRange(strLength, strLength);
            }
        };
        return TextareaExpandable;
    }(AbstractExpandable));
    ButterFaces.TextareaExpandable = TextareaExpandable;
})(ButterFaces || (ButterFaces = {}));

var ButterFaces;
(function (ButterFaces) {
    var Guid = /** @class */ (function () {
        function Guid() {
        }
        Guid.newGuid = function () {
            var d = new Date().getTime();
            if (typeof performance !== "undefined" && typeof performance.now === "function") {
                d += performance.now(); //use high-precision timer if available
            }
            return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (c) {
                var r = (d + Math.random() * 16) % 16 | 0;
                d = Math.floor(d / 16);
                return (c === "x" ? r : (r & 0x3 | 0x8)).toString(16);
            });
        };
        return Guid;
    }());
    ButterFaces.Guid = Guid;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var CommandLink = /** @class */ (function () {
        function CommandLink() {
        }
        CommandLink.disableOnClick = function (data, showDots, linkText, linkProcessingText, linkGlyphicon, linkProcessingGlyphicon, hideGlyphicon, disableRenderRegionsIds) {
            var status = data.type === "error" ? "error" : data.status;
            // console.log(data.source.id);
            var $commandLink = $(document.getElementById(data.source.id));
            switch (status) {
                case "begin": // Before the ajax request is sent.
                    // console.log('ajax request begin');
                    $commandLink.addClass("disabled");
                    var $glyphicon = $commandLink.find(".butter-component-glyphicon");
                    if (hideGlyphicon) {
                        $glyphicon.hide();
                    }
                    if (linkProcessingGlyphicon.length > 0) {
                        $glyphicon.removeAttr("class");
                        $glyphicon.addClass("butter-component-glyphicon butter-component-processing-spinner");
                        $glyphicon.addClass(linkProcessingGlyphicon);
                        if (linkProcessingText.length > 0 && linkGlyphicon.length === 0) {
                            // glyphicon only appears on ajax request
                            $glyphicon.addClass("butter-component-glyphicon-width-margin");
                        }
                    }
                    else {
                        $glyphicon.removeAttr("class");
                        $glyphicon.addClass("butter-component-spinner tiny butter-component-processing-spinner");
                    }
                    if (showDots) {
                        $commandLink.find(".butter-component-glyphicon-processing").startDots();
                        $commandLink.find(".butter-component-glyphicon-processing").css("display", "inline-block");
                        $commandLink.find(".butter-component-glyphicon-text").html(linkProcessingText);
                    }
                    if (disableRenderRegionsIds !== "undefined") {
                        // console.log('Disable field');
                        new ButterFaces.Overlay(0, false, disableRenderRegionsIds.replace(/[:]/g, "\:")).show();
                    }
                    break;
                case "complete": // After the ajax response is arrived.
                    // console.log('ajax request complete');
                    break;
                case "success": // After update of HTML DOM based on ajax response..
                case "error": // After update of HTML DOM based on ajax response..
                    // console.log('ajax request success');
                    $commandLink.removeClass("disabled");
                    if (showDots) {
                        $commandLink.find(".butter-component-glyphicon-processing").stopDots();
                        $commandLink.find(".butter-component-glyphicon-processing").css("display", "none");
                        $commandLink.find(".butter-component-glyphicon-text").html(linkText ? linkText : "");
                    }
                    var $glyphiconError = $commandLink.find(".butter-component-processing-spinner");
                    $glyphiconError.removeAttr("class");
                    $glyphiconError.addClass("butter-component-glyphicon");
                    if (hideGlyphicon) {
                        $glyphiconError.show();
                    }
                    if (linkGlyphicon.length > 0) {
                        $glyphiconError.addClass(linkGlyphicon);
                    }
                    if (disableRenderRegionsIds !== "undefined") {
                        // console.log('Enable field');
                        new ButterFaces.Overlay(0, false, disableRenderRegionsIds.replace(/[:]/g, "\:")).hide();
                    }
                    break;
            }
        };
        /**
         * Submit given form.
         * @param formId the target form id to submit
         * @param params a list of params to be added to form as hidden input fields
         * @param target the target of the form submission
         */
        CommandLink.submitForm = function (formId, params, target) {
            var form = document.getElementById(formId);
            ButterFaces.CommandLink.addParametersAsHiddenFieldsToForm(form, params);
            var oldFormTarget = ButterFaces.CommandLink.setFormTarget(form, target);
            if (form.onsubmit) {
                var result = form.onsubmit();
                if (ButterFaces.ObjectStatics.isNullOrUndefined(result) || result) {
                    form.submit();
                }
            }
            else {
                form.submit();
            }
            form.target = oldFormTarget;
            ButterFaces.CommandLink.removeHiddenFieldsFromForm(form);
        };
        CommandLink.addParametersAsHiddenFieldsToForm = function (form, params) {
            var bfHiddenInputFields = [];
            form.bfHiddenInputFields = bfHiddenInputFields;
            var i = 0;
            for (var k in params) {
                if (params.hasOwnProperty(k)) {
                    var p = document.createElement("input");
                    p.type = "hidden";
                    p.name = k;
                    p.value = params[k];
                    form.appendChild(p);
                    bfHiddenInputFields[i++] = p;
                }
            }
        };
        CommandLink.removeHiddenFieldsFromForm = function (form) {
            var bfHiddenInputFields = form.bfHiddenInputFields;
            if (bfHiddenInputFields !== null) {
                for (var i = 0; i < bfHiddenInputFields.length; i++) {
                    form.removeChild(bfHiddenInputFields[i]);
                }
            }
        };
        /**
         * Updates form target (if exists) and returns previous form target
         * @param form the torm to add the new target to
         * @param target the target to add (if not null)
         * @return the previous form target
         */
        CommandLink.setFormTarget = function (form, target) {
            var previousTarget = form.target;
            if (target) {
                form.target = target;
            }
            return previousTarget;
        };
        return CommandLink;
    }());
    ButterFaces.CommandLink = CommandLink;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-util-string.ts"/>
///<reference path="butterfaces-util-object.ts"/>
(function ($) {
    // you have to extend jQuery with the fn["pluginName"] notation because in Typescript you can't extend
    // the existing typing interface with fn.pluginName!
    $.fn["butterMaxLength"] = function (options) {
        return this.each(function (index, element) {
            new ButterFaces.MaxLengthIndicator($(element), options);
        });
    };
})(jQuery);
var ButterFaces;
(function (ButterFaces) {
    var ERROR_STYLE_CLASS = "has-error";
    var INVALID_STYLE_CLASS = "is-invalid";
    var MaxLengthIndicator = /** @class */ (function () {
        function MaxLengthIndicator(rootElement, options) {
            this.rootElement = rootElement;
            this.options = options;
            this.valueElement = this.rootElement.find("textarea");
            this.maxLengthElement = $("<div>").addClass("butter-component-maxlength-counter");
            this.maxLengthElement.insertAfter(this.valueElement);
            this.initializeComponent();
        }
        MaxLengthIndicator.prototype.initializeComponent = function () {
            void 0;
            this.hasInitialValidationError = this.rootElement.hasClass(ERROR_STYLE_CLASS);
            void 0;
            var that = this;
            this.valueElement.on("focus blur keyup cut paste", function () {
                that.checkValue();
            });
            // initial check
            this.checkValue();
        };
        MaxLengthIndicator.prototype.checkValue = function () {
            var value = this.valueElement.val();
            if (!ButterFaces.ObjectStatics.isNullOrUndefined(value)) {
                void 0;
                var freeLetterCount = this.options.maxLength - value.length;
                var formatted = ButterFaces.String.format(this.options.maxLengthText, [freeLetterCount, this.options.maxLength]);
                this.maxLengthElement.text(formatted);
                if (!this.hasInitialValidationError) {
                    if (freeLetterCount < 0) {
                        this.rootElement.addClass(ERROR_STYLE_CLASS);
                        this.valueElement.addClass(INVALID_STYLE_CLASS);
                    }
                    else {
                        this.rootElement.removeClass(ERROR_STYLE_CLASS);
                        this.valueElement.removeClass(INVALID_STYLE_CLASS);
                    }
                }
            }
        };
        return MaxLengthIndicator;
    }());
    ButterFaces.MaxLengthIndicator = MaxLengthIndicator;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
(function ($) {
    // extend jQuery --------------------------------------------------------------------
    $.fn.multilinePlaceholder = function () {
        return this.each(function () {
            var $originalElement = $(this);
            var $textarea = $originalElement.find("textarea");
            var placeholder = $textarea.attr("placeholder");
            var multilinePlaceholder = placeholder.replace(/\\n/g, "\n");
            $textarea.attr("placeholder", multilinePlaceholder);
        });
    };
}(jQuery));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-guid.ts"/>
///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Overlay = /** @class */ (function () {
        function Overlay(delay, isTransparentBlockingOverlayActive, selector) {
            if (delay === void 0) { delay = 500; }
            if (isTransparentBlockingOverlayActive === void 0) { isTransparentBlockingOverlayActive = true; }
            if (selector === void 0) { selector = "body"; }
            this.isHiding = true;
            this.delay = delay;
            this.isTransparentBlockingOverlayActive = isTransparentBlockingOverlayActive;
            this.selector = selector;
            void 0;
        }
        Overlay.prototype.show = function () {
            var _this = this;
            var $elementsToDisable = $(this.selector);
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                _this.isHiding = false;
                if (!ButterFaces.ObjectStatics.isNullOrUndefined($elementToDisable.attr("data-overlay-uuid"))) {
                    if (ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid")).length > 0) {
                        void 0;
                        return;
                    }
                    else {
                        $elementToDisable.removeAttr("data-overlay-uuid");
                    }
                }
                void 0;
                var uuid = ButterFaces.Guid.newGuid();
                var $overlay = $("<div class='butter-component-overlay' data-overlay-uuid='" + uuid + "'><div class='" + _this.calcOverlaySpinnerClass($elementToDisable) + "'></div></div>");
                $elementToDisable.attr("data-overlay-uuid", uuid);
                if (_this.selector === "body") {
                    $overlay.addClass("overlay-body");
                }
                else {
                    // TODO if blockpage is true set it to max size
                    $overlay.offset($elementToDisable.offset())
                        .width($elementToDisable.outerWidth())
                        .height($elementToDisable.outerHeight())
                        .addClass("overlay-body-child")
                        .css({ "position": "absolute" }); // IE overrides css position so set it here
                }
                $("body").append($overlay);
                if (_this.isTransparentBlockingOverlayActive) {
                    void 0;
                    $overlay.show();
                }
                window.setTimeout(function () {
                    if (!_this.isHiding && !_this.isTransparentBlockingOverlayActive) {
                        void 0;
                        $overlay.show();
                    }
                    if (!_this.isHiding) {
                        void 0;
                        $overlay
                            .stop(true)
                            .animate({
                            opacity: 1
                        }, 300, function () {
                            void 0;
                        });
                    }
                }, _this.delay);
            });
        };
        Overlay.prototype.hide = function () {
            void 0;
            var $elementsToDisable = $(this.selector);
            this.isHiding = true;
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                var overlayUuid = $elementToDisable.attr("data-overlay-uuid");
                if (!ButterFaces.ObjectStatics.isNullOrUndefined(overlayUuid) && ButterFaces.Overlay.findOverlay(overlayUuid).length > 0) {
                    var $overlay = ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid"));
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.prototype.calcOverlaySpinnerClass = function (element) {
            if (element.outerHeight() < 55) {
                return "butter-component-spinner tiny";
            }
            if (element.outerHeight() < 105) {
                return "butter-component-spinner small";
            }
            return "butter-component-spinner";
        };
        Overlay.hideAll = function () {
            void 0;
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            ButterFaces.Overlay.fadeOutAttachtedOverlays();
        };
        Overlay.fadeOutDetachtedOverlays = function () {
            // remove unbinded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                if ($("[data-overlay-uuid=" + uuidToCheck + "]").length === 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.fadeOutAttachtedOverlays = function () {
            // remove binded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                var elements = $("[data-overlay-uuid=" + uuidToCheck + "]");
                if (elements.length > 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                    elements.each(function (index, element) {
                        var $element = $(element);
                        $element.removeAttr("data-overlay-uuid");
                    });
                }
            });
        };
        Overlay.fadeOutOverlay = function ($overlay) {
            $overlay
                .stop(true)
                .animate({
                opacity: 0
            }, 300, function () {
                $overlay.remove();
                void 0;
            });
        };
        Overlay.findOverlay = function (uuid) {
            return $("body .butter-component-overlay[data-overlay-uuid='" + uuid + "']");
        };
        return Overlay;
    }());
    ButterFaces.Overlay = Overlay;
})(ButterFaces || (ButterFaces = {}));

var ButterFaces;
(function (ButterFaces) {
    var RadioBox = /** @class */ (function () {
        function RadioBox() {
        }
        RadioBox.addStyleClassClickEvent = function (radioBoxId) {
            var radioBox = document.getElementById(radioBoxId);
            radioBox.addEventListener("change", function (event) {
                void 0;
                [].forEach.call(document.querySelectorAll(".radio"), function (el) {
                    void 0;
                    el.classList.remove("butter-radio-item-selected");
                });
                void 0;
                event.target.parentNode.classList.add("butter-radio-item-selected");
            });
        };
        return RadioBox;
    }());
    ButterFaces.RadioBox = RadioBox;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-ajax.ts"/>
(function ($) {
    $.fn.selectTableRow = function (data) {
        return this.each(function () {
            var $originalElement = $(this);
            void 0;
            void 0;
            $originalElement.find("tr").removeClass("butter-table-row-selected");
            var listItems = $originalElement.find("tr[rowindex=" + data.rowIndex + "]");
            $(listItems[listItems.length - 1]).addClass("butter-table-row-selected");
        });
    };
}(jQuery));
(function ($) {
    $.fn.sortTableRow = function (renderIds, disableRenderIds, columnNumber) {
        return this.each(function () {
            var $table = $(this);
            // let rows = $table.find("tbody > tr").length;
            // let columns = $table.find("thead th").length;
            ButterFaces.Ajax.sendRequest($table.attr("id"), "sort_" + columnNumber, renderIds, columnNumber, disableRenderIds);
        });
    };
}(jQuery));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Tooltip = /** @class */ (function () {
        function Tooltip(popoverMaxWidthByBootstrap, popoverMaxHeightByButterFaces) {
            if (popoverMaxWidthByBootstrap === void 0) { popoverMaxWidthByBootstrap = 276; }
            if (popoverMaxHeightByButterFaces === void 0) { popoverMaxHeightByButterFaces = 110; }
            this.popoverMaxWidthByBootstrap = popoverMaxWidthByBootstrap;
            this.popoverMaxHeightByButterFaces = popoverMaxHeightByButterFaces;
            void 0;
        }
        Tooltip.prototype.calculateTooltipPosition = function (popover, source) {
            var offsetBottom = $(window).height() - $(source).offset().top - $(source).outerHeight();
            var offsetRight = $(window).width() - $(source).offset().left - $(source).outerWidth();
            void 0;
            void 0;
            if (offsetBottom < this.popoverMaxHeightByButterFaces) {
                if (offsetRight < this.popoverMaxWidthByBootstrap) {
                    void 0;
                    if ($(source).offset().left < this.popoverMaxWidthByBootstrap) {
                        void 0;
                        return "top";
                    }
                    void 0;
                    return "left";
                }
                void 0;
                return "right";
            }
            void 0;
            return "bottom";
        };
        return Tooltip;
    }());
    ButterFaces.Tooltip = Tooltip;
})(ButterFaces || (ButterFaces = {}));

var ButterFaces;
(function (ButterFaces) {
    var TreeBox = /** @class */ (function () {
        function TreeBox() {
        }
        TreeBox.removeTrivialTreeDropDown = function (treeBoxId) {
            this.removeTrivialTreeDropDownById(treeBoxId);
            this.removeUnAssociatedTrivialTreeDropDowns();
        };
        TreeBox.removeUnAssociatedTrivialTreeDropDowns = function () {
            var dropdowns = document.querySelectorAll(".tr-dropdown[data-tree-box-id]");
            Array.prototype.slice.call(dropdowns, 0).forEach(function (dropdown) {
                var dropdownId = dropdown.getAttribute("data-tree-box-id");
                if (document.querySelectorAll(".butter-component-treebox[data-tree-box-id=" + dropdownId + "]").length === 0) {
                    dropdown.parentNode.removeChild(dropdown);
                }
            });
        };
        TreeBox.removeTrivialTreeDropDownById = function (treeBoxId) {
            // in jQuery: $(".tr-dropdown[data-tree-box-id=" + treeBoxId + "]").remove();
            // plain javascript:
            var dropdowns = document.querySelectorAll(".tr-dropdown[data-tree-box-id=" + treeBoxId + "]");
            Array.prototype.slice.call(dropdowns, 0).forEach(function (dropdown) {
                dropdown.parentNode.removeChild(dropdown);
            });
        };
        return TreeBox;
    }());
    ButterFaces.TreeBox = TreeBox;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/trivial-components/dist/js/bundle/trivial-components-global.d.ts"/>
///<reference path="../../node_modules/@types/mustache/index.d.ts"/>
var ButterFaces;
(function (ButterFaces) {
    function createTrivialTagComponent($input, options) {
        return new TrivialComponents.TrivialTagComboBox($input, {
            autoComplete: options.autoComplete,
            allowFreeText: true,
            showTrigger: options.showTrigger,
            distinct: options.distinct,
            editingMode: options.editingMode,
            matchingOptions: {
                matchingMode: "contains",
                ignoreCase: true,
                maxLevenshteinDistance: 0
            },
            maxSelectedEntries: options.maxSelectedEntries,
            selectedEntries: options.selectedEntries,
            freeTextSeparators: options.freeTextSeparators,
            entries: options.entries,
            valueFunction: function (entries) {
                return entries
                    .map(function (entry) { return entry.id != null ? entry.id : entry.title; })
                    .join(",");
            },
            freeTextEntryFactory: function (freeText) {
                return { title: escapeHtml(freeText) };
            },
            entryRenderingFunction: function (entry) { return "<div>" + entry.title + "</div>"; },
        });
        function escapeHtml(source) {
            /* tslint:disable */
            var entityMap = {
                "&": "&amp;",
                "<": "&lt;",
                ">": "&gt;",
                '"': "&quot;",
                "'": "&#39;",
                "/": "&#x2F;"
            };
            /* tslint:enable */
            return source.replace(/[&<>"'\/]/g, function (s) { return entityMap[s]; });
        }
    }
    ButterFaces.createTrivialTagComponent = createTrivialTagComponent;
    function createTrivialTreeComponent($input, options) {
        return new TrivialComponents.TrivialTree($input, {
            searchBarMode: options.searchBarMode,
            selectedEntryId: options.selectedEntryId,
            performanceOptimizationSettings: options.performanceOptimizationSettings,
            entryRenderingFunction: function (entry, depth) { return Mustache.render(options.templates[Math.min(options.templates.length - 1, depth)], entry); },
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries,
            queryFunction: TrivialComponents.customTreeQueryFunctionFactory(options.entries, "children", "expanded", function (entry, queryString, nodeDepth) {
                // TODO remove null parameter after trivial component is fixed
                var titleMatches = entry.title && TrivialComponents.trivialMatch(entry.title, queryString, null).length > 0;
                var descriptionMatches = entry.description && TrivialComponents.trivialMatch(entry.description, queryString, null).length > 0;
                return titleMatches || descriptionMatches;
            })
        });
    }
    ButterFaces.createTrivialTreeComponent = createTrivialTreeComponent;
    function createTrivialComboBox($input, options) {
        return new TrivialComponents.TrivialComboBox($input, {
            allowFreeText: false,
            entryToEditorTextFunction: function (entry) { return entry[options.inputTextProperty]; },
            entryRenderingFunction: function (entry) {
                return Mustache.render(options.template, entry);
            },
            selectedEntryRenderingFunction: function (entry) {
                if (!entry || entry._isEmptyEntry) {
                    return options.emptyEntryTemplate || "";
                }
                else if (options.selectedEntryTemplate) {
                    return Mustache.render(options.selectedEntryTemplate, entry);
                }
                else {
                    return Mustache.render(options.template, entry);
                }
            },
            editingMode: options.editingMode,
            showClearButton: options.showClearButton,
            selectedEntry: options.selectedEntry,
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries
        });
    }
    ButterFaces.createTrivialComboBox = createTrivialComboBox;
    function createTrivialTreeComboBox($input, options) {
        return new TrivialComponents.TrivialTreeComboBox($input, {
            allowFreeText: false,
            entryToEditorTextFunction: function (entry) { return entry[options.inputTextProperty]; },
            entryRenderingFunction: function (entry, depth) { return Mustache.render(options.templates[Math.min(options.templates.length - 1, depth)], entry); },
            selectedEntryRenderingFunction: function (entry) {
                if (!entry || entry._isEmptyEntry) {
                    return options.emptyEntryTemplate || "";
                }
                else if (options.selectedEntryTemplate) {
                    return Mustache.render(options.selectedEntryTemplate, entry);
                }
                else {
                    return Mustache.render(options.templates[0], entry);
                }
            },
            editingMode: options.editingMode,
            showClearButton: options.showClearButton,
            selectedEntry: options.selectedEntry,
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries,
            queryFunction: TrivialComponents.customTreeQueryFunctionFactory(options.entries, "children", "expanded", function (entry, queryString, nodeDepth) {
                // TODO remove null parameter after trivial component is fixed
                var titleMatches = entry.title && TrivialComponents.trivialMatch(entry.title, queryString, null).length > 0;
                var descriptionMatches = entry.description && TrivialComponents.trivialMatch(entry.description, queryString, null).length > 0;
                return titleMatches || descriptionMatches;
            })
        });
    }
    ButterFaces.createTrivialTreeComboBox = createTrivialTreeComboBox;
})(ButterFaces || (ButterFaces = {}));

var ButterFaces;
(function (ButterFaces) {
    var ObjectStatics = /** @class */ (function () {
        function ObjectStatics() {
        }
        ObjectStatics.isNullOrUndefined = function (value) {
            return typeof value === "undefined" || value === null;
        };
        return ObjectStatics;
    }());
    ButterFaces.ObjectStatics = ObjectStatics;
})(ButterFaces || (ButterFaces = {}));

///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var String = /** @class */ (function () {
        function String() {
        }
        String.format = function (format, params) {
            return format.replace(/{(\d+)}/g, function (match, num) {
                return ButterFaces.ObjectStatics.isNullOrUndefined(params[num]) ? match : params[num];
            });
        };
        return String;
    }());
    ButterFaces.String = String;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-overlay.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var WaitingPanel = /** @class */ (function () {
        function WaitingPanel(overlay) {
            this.overlay = overlay;
        }
        WaitingPanel.prototype.processAjaxUpdate = function () {
            var _this = this;
            var ajaxRequestsRunning = 0;
            return function (_a) {
                var status = _a.status;
                void 0;
                if (status === "begin") {
                    ajaxRequestsRunning++;
                }
                else if (status === "success") {
                    ajaxRequestsRunning--;
                }
                if (ajaxRequestsRunning > 0) {
                    void 0;
                    _this.overlay.show();
                }
                else {
                    void 0;
                    _this.overlay.hide();
                }
            };
        };
        WaitingPanel.prototype.processOnError = function (data) {
            if (data) {
                void 0;
                ButterFaces.Overlay.hideAll();
            }
        };
        return WaitingPanel;
    }());
    ButterFaces.WaitingPanel = WaitingPanel;
})(ButterFaces || (ButterFaces = {}));
(function ($) {
    // extend jQuery --------------------------------------------------------------------
    var eventRegistered = false;
    var overlay;
    $.fn.waitingPanel = function (_a) {
        var waitingPanelDelay = _a.waitingPanelDelay, blockpage = _a.blockpage;
        return this.each(function () {
            // I found no way to remove event listener from jsf js.
            // I tried to register a callback once and change it on render waiting panel but after this
            // no waiting panel appears anymore.
            // Actually on each rendering of this component a new callback is put on event listener collection.
            if (!eventRegistered) {
                // console.log("waitingPanel - register: " + _elementId);
                overlay = new ButterFaces.Overlay(waitingPanelDelay, blockpage);
                var waitingPanel = new ButterFaces.WaitingPanel(overlay);
                jsf.ajax.addOnEvent(waitingPanel.processAjaxUpdate());
                jsf.ajax.addOnError(waitingPanel.processOnError);
                eventRegistered = true;
            }
            overlay.delay = waitingPanelDelay;
            overlay.isTransparentBlockingOverlayActive = blockpage;
        });
    };
}(jQuery));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
