/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.showcase.calendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.butterfaces.component.html.text.HtmlCalendarViewMode;
import org.butterfaces.component.showcase.AbstractInputShowcase;
import org.butterfaces.component.showcase.calendar.CalendarIconType;
import org.butterfaces.component.showcase.calendar.CalendarShowcase;
import org.butterfaces.component.showcase.example.AbstractCodeExample;
import org.butterfaces.component.showcase.example.XhtmlCodeExample;
import org.butterfaces.component.showcase.type.Locale;
import org.butterfaces.component.showcase.type.StyleClass;
import org.butterfaces.model.tree.EnumTreeBoxWrapper;
import org.butterfaces.util.StringUtils;

@Named
@ViewScoped
public class CalendarShowcase
extends AbstractInputShowcase
implements Serializable {
    private CalendarIconType selectedIconType = CalendarIconType.DEFAULT;
    private String iconDate = null;
    private String iconTime = null;
    private String iconUp = null;
    private String iconDown = null;
    private String placeholder = "Enter date or click icon...";
    private boolean autoFocus;
    private boolean pickDate = true;
    private boolean pickTime = true;
    private boolean sideBySide = false;
    private Locale locale = null;
    private String format = null;
    private HtmlCalendarViewMode viewMode = null;

    protected Object initValue() {
        return null;
    }

    public String getReadableValue() {
        return (String)this.getValue();
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        boolean useFontAwesome = this.selectedIconType == CalendarIconType.AWESOME;
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(useFontAwesome);
        xhtmlCodeExample.appendInnerContent("        <b:calendar id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                    label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    hideLabel=\"" + this.isHideLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                    pickDate=\"" + this.pickDate + "\"");
        xhtmlCodeExample.appendInnerContent("                    pickTime=\"" + this.pickTime + "\"");
        xhtmlCodeExample.appendInnerContent("                    sideBySide=\"" + this.sideBySide + "\"");
        if (this.locale != null) {
            xhtmlCodeExample.appendInnerContent("                    locale=\"" + this.locale.value + "\"");
        }
        if (StringUtils.isNotEmpty((String)this.format)) {
            xhtmlCodeExample.appendInnerContent("                    format=\"" + this.format + "\"");
        }
        if (this.viewMode != null) {
            xhtmlCodeExample.appendInnerContent("                    viewMode=\"" + this.viewMode.getValue() + "\"");
        }
        if (StringUtils.isNotEmpty((String)this.iconDate)) {
            xhtmlCodeExample.appendInnerContent("                    iconDate=\"" + this.iconDate + "\"");
        }
        if (StringUtils.isNotEmpty((String)this.iconTime)) {
            xhtmlCodeExample.appendInnerContent("                    iconTime=\"" + this.iconTime + "\"");
        }
        if (StringUtils.isNotEmpty((String)this.iconUp)) {
            xhtmlCodeExample.appendInnerContent("                    iconUp=\"" + this.iconUp + "\"");
        }
        if (StringUtils.isNotEmpty((String)this.iconDown)) {
            xhtmlCodeExample.appendInnerContent("                    iconDown=\"" + this.iconDown + "\"");
        }
        if (StringUtils.isNotEmpty((String)this.getPlaceholder())) {
            xhtmlCodeExample.appendInnerContent("                    placeholder=\"" + this.getPlaceholder() + "\"");
        }
        if (this.getStyleClass() == StyleClass.BIG_LABEL) {
            xhtmlCodeExample.appendInnerContent("                    styleClass=\"" + this.getSelectedStyleClass() + "\"");
        }
        xhtmlCodeExample.appendInnerContent("                    readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                    required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                    disabled=\"" + this.isDisabled() + "\"");
        xhtmlCodeExample.appendInnerContent("                    autoFocus=\"" + this.isAutoFocus() + "\"");
        xhtmlCodeExample.appendInnerContent("                    rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "change");
        if (this.isValidation()) {
            xhtmlCodeExample.appendInnerContent("            <f:validateLength minimum=\"2\" maximum=\"10\"/>");
        }
        if (StringUtils.isNotEmpty((String)this.getTooltip())) {
            xhtmlCodeExample.appendInnerContent("            <b:tooltip>");
            xhtmlCodeExample.appendInnerContent("                " + this.getTooltip());
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:calendar>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        this.generateDemoCSS(codeExamples);
    }

    public List<EnumTreeBoxWrapper> getCalendarIconTypes() {
        ArrayList<EnumTreeBoxWrapper> items = new ArrayList<EnumTreeBoxWrapper>();
        for (CalendarIconType type : CalendarIconType.values()) {
            items.add(new EnumTreeBoxWrapper((Enum)type, type.label));
        }
        return items;
    }

    public List<EnumTreeBoxWrapper> getLocaleExamples() {
        ArrayList<EnumTreeBoxWrapper> items = new ArrayList<EnumTreeBoxWrapper>();
        for (Locale type : Locale.values()) {
            items.add(new EnumTreeBoxWrapper((Enum)type, type.label));
        }
        return items;
    }

    public List<HtmlCalendarViewMode> getViewModes() {
        return Arrays.asList(HtmlCalendarViewMode.values());
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public boolean isPickDate() {
        return this.pickDate;
    }

    public void setPickDate(boolean pickDate) {
        this.pickDate = pickDate;
    }

    public boolean isPickTime() {
        return this.pickTime;
    }

    public void setPickTime(boolean pickTime) {
        this.pickTime = pickTime;
    }

    public String getSelectedLocale() {
        return this.locale == null ? null : this.locale.value;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public HtmlCalendarViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(HtmlCalendarViewMode viewMode) {
        this.viewMode = viewMode;
    }

    public CalendarIconType getSelectedIconType() {
        return this.selectedIconType;
    }

    public void setSelectedIconType(CalendarIconType selectedIconType) {
        this.selectedIconType = selectedIconType;
        switch (1.$SwitchMap$org$butterfaces$component$showcase$calendar$CalendarIconType[selectedIconType.ordinal()]) {
            case 1: {
                this.iconDate = null;
                this.iconTime = null;
                this.iconUp = null;
                this.iconDown = null;
                break;
            }
            case 2: {
                this.iconDate = "fa fa-calendar";
                this.iconTime = "fa fa-clock-o";
                this.iconUp = "fa fa-chevron-up";
                this.iconDown = "fa fa-chevron-down";
            }
        }
    }

    public String getIconTime() {
        return this.iconTime;
    }

    public String getIconDate() {
        return this.iconDate;
    }

    public String getIconUp() {
        return this.iconUp;
    }

    public String getIconDown() {
        return this.iconDown;
    }

    public boolean isSideBySide() {
        return this.sideBySide;
    }

    public void setSideBySide(boolean sideBySide) {
        this.sideBySide = sideBySide;
    }
}

