/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.showcase.tooltip;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.butterfaces.component.showcase.AbstractCodeShowcase;
import org.butterfaces.component.showcase.example.AbstractCodeExample;
import org.butterfaces.component.showcase.example.XhtmlCodeExample;
import org.butterfaces.component.showcase.tooltip.TooltipType;
import org.butterfaces.model.tree.EnumTreeBoxWrapper;

@Named
@ViewScoped
public class TooltipShowcase
extends AbstractCodeShowcase
implements Serializable {
    private TooltipType selectedTooltTipType = TooltipType.A;
    private String title = "custom title";
    private String trigger = "hover";
    private String viewport = "body";
    private String placement;
    private String textFieldValue;

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        if (this.selectedTooltTipType == TooltipType.A) {
            xhtmlCodeExample.setWrappedByForm(false);
            xhtmlCodeExample.appendInnerContent("        <a id=\"btn\" class=\"btn btn-outline-secondary\">" + this.trigger + " me!</a>");
            xhtmlCodeExample.appendInnerContent("        <b:tooltip id=\"input\"");
            xhtmlCodeExample.appendInnerContent("                   for=\"#btn\"");
            xhtmlCodeExample.appendInnerContent("                   title=\"" + this.title + "\"");
            xhtmlCodeExample.appendInnerContent("                   trigger=\"" + this.trigger + "\"");
            xhtmlCodeExample.appendInnerContent("                   placement=\"" + this.placement + "\"");
            xhtmlCodeExample.appendInnerContent("                   viewport=\"" + this.viewport + "\"");
            xhtmlCodeExample.appendInnerContent("                   rendered=\"" + this.isRendered() + "\">");
            xhtmlCodeExample.appendInnerContent("            <strong>some text stuff</strong>");
            xhtmlCodeExample.appendInnerContent("            <br />");
            xhtmlCodeExample.appendInnerContent("            <h:panelGroup>");
            xhtmlCodeExample.appendInnerContent("                Lorem ipsum dolor sit amet, consectetuer ...");
            xhtmlCodeExample.appendInnerContent("            </h:panelGroup>");
            xhtmlCodeExample.appendInnerContent("        </b:tooltip>", false);
        } else if (this.selectedTooltTipType == TooltipType.COMMAND_LINK) {
            xhtmlCodeExample.appendInnerContent("        <b:commandLink value=\"" + this.trigger + " me!\"");
            xhtmlCodeExample.appendInnerContent("                       styleClass=\"btn btn-outline-secondary\">");
            xhtmlCodeExample.appendInnerContent("            <b:tooltip title=\"" + this.title + "\"");
            xhtmlCodeExample.appendInnerContent("                       trigger=\"" + this.trigger + "\"");
            xhtmlCodeExample.appendInnerContent("                       placement=\"" + this.placement + "\"");
            xhtmlCodeExample.appendInnerContent("                       viewport=\"" + this.viewport + "\"");
            xhtmlCodeExample.appendInnerContent("                       rendered=\"" + this.isRendered() + "\">");
            xhtmlCodeExample.appendInnerContent("                <strong>some text stuff</strong>");
            xhtmlCodeExample.appendInnerContent("                <br />");
            xhtmlCodeExample.appendInnerContent("                <h:panelGroup>");
            xhtmlCodeExample.appendInnerContent("                    Lorem ipsum dolor sit amet, consectetuer ...");
            xhtmlCodeExample.appendInnerContent("                </h:panelGroup>");
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
            xhtmlCodeExample.appendInnerContent("        </b:commandLink>", false);
        } else if (this.selectedTooltTipType == TooltipType.READONLY_TEXT) {
            xhtmlCodeExample.appendInnerContent("        <b:text value=\"short text\"");
            xhtmlCodeExample.appendInnerContent("                label=\"" + this.trigger + " me!\"");
            xhtmlCodeExample.appendInnerContent("                readonly=\"true\">");
            xhtmlCodeExample.appendInnerContent("            <f:ajax event=\"blur\"");
            xhtmlCodeExample.appendInnerContent("                    execute=\"@this\"");
            xhtmlCodeExample.appendInnerContent("                    render=\"@this\" />");
            xhtmlCodeExample.appendInnerContent("            <f:validateLength minimum=\"2\"");
            xhtmlCodeExample.appendInnerContent("                              maximum=\"10\" />");
            xhtmlCodeExample.appendInnerContent("            <b:tooltip title=\"" + this.title + "\"");
            xhtmlCodeExample.appendInnerContent("                       trigger=\"" + this.trigger + "\"");
            xhtmlCodeExample.appendInnerContent("                       placement=\"" + this.placement + "\"");
            xhtmlCodeExample.appendInnerContent("                       viewport=\"" + this.viewport + "\"");
            xhtmlCodeExample.appendInnerContent("                       rendered=\"" + this.isRendered() + "\">");
            xhtmlCodeExample.appendInnerContent("                <strong>some text stuff</strong>");
            xhtmlCodeExample.appendInnerContent("                <br />");
            xhtmlCodeExample.appendInnerContent("                <h:panelGroup>");
            xhtmlCodeExample.appendInnerContent("                    Lorem ipsum dolor sit amet, consectetuer ...");
            xhtmlCodeExample.appendInnerContent("                </h:panelGroup>");
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
            xhtmlCodeExample.appendInnerContent("        </b:text>", false);
        } else {
            xhtmlCodeExample.appendInnerContent("        <b:text value=\"#{myBean.value}\"");
            xhtmlCodeExample.appendInnerContent("                label=\"" + this.trigger + " me!\"");
            xhtmlCodeExample.appendInnerContent("                placeholder=\"Insert text and blur me...\">");
            xhtmlCodeExample.appendInnerContent("            <f:ajax event=\"blur\"");
            xhtmlCodeExample.appendInnerContent("                    execute=\"@this\"");
            xhtmlCodeExample.appendInnerContent("                    render=\"@this\" />");
            xhtmlCodeExample.appendInnerContent("            <f:validateLength minimum=\"2\"");
            xhtmlCodeExample.appendInnerContent("                              maximum=\"10\" />");
            xhtmlCodeExample.appendInnerContent("            <b:tooltip title=\"" + this.title + "\"");
            xhtmlCodeExample.appendInnerContent("                       trigger=\"" + this.trigger + "\"");
            xhtmlCodeExample.appendInnerContent("                       placement=\"" + this.placement + "\"");
            xhtmlCodeExample.appendInnerContent("                       viewport=\"" + this.viewport + "\"");
            xhtmlCodeExample.appendInnerContent("                       rendered=\"" + this.isRendered() + "\">");
            xhtmlCodeExample.appendInnerContent("                <strong>some text stuff</strong>");
            xhtmlCodeExample.appendInnerContent("                <br />");
            xhtmlCodeExample.appendInnerContent("                <h:panelGroup>");
            xhtmlCodeExample.appendInnerContent("                    Lorem ipsum dolor sit amet, consectetuer ...");
            xhtmlCodeExample.appendInnerContent("                </h:panelGroup>");
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
            xhtmlCodeExample.appendInnerContent("        </b:text>", false);
        }
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
    }

    public List<EnumTreeBoxWrapper> getTooltipTypes() {
        ArrayList<EnumTreeBoxWrapper> items = new ArrayList<EnumTreeBoxWrapper>();
        for (TooltipType type : TooltipType.values()) {
            items.add(new EnumTreeBoxWrapper((Enum)type, type.label));
        }
        return items;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public String getPlacement() {
        return this.placement;
    }

    public void setPlacement(String placement) {
        this.placement = placement;
    }

    public TooltipType getSelectedTooltTipType() {
        return this.selectedTooltTipType;
    }

    public void setSelectedTooltTipType(TooltipType selectedTooltTipType) {
        this.selectedTooltTipType = selectedTooltTipType;
    }

    public String getTextFieldValue() {
        return this.textFieldValue;
    }

    public void setTextFieldValue(String textFieldValue) {
        this.textFieldValue = textFieldValue;
    }

    public String getViewport() {
        return this.viewport;
    }

    public void setViewport(String viewport) {
        this.viewport = viewport;
    }
}

