/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.showcase.example;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.butterfaces.component.showcase.example.AbstractCodeExample;
import org.butterfaces.util.StringUtils;

public class EnumCodeExample
extends AbstractCodeExample {
    private final StringBuilder innerContent = new StringBuilder();
    private final List<String> imports = new ArrayList();
    private final List<String> interfaces = new ArrayList();
    private final String subPackage;
    private final String className;
    private final String classAnnotation;

    public EnumCodeExample(String tabName, String tabId, String subPackage, String className, String classAnnotation) {
        super(tabName, tabId);
        this.subPackage = subPackage;
        this.className = className;
        this.classAnnotation = classAnnotation;
    }

    public String getPrettyPrintLang() {
        return "lang-java";
    }

    public boolean addImport(String anImport) {
        return this.imports.add(anImport);
    }

    public boolean addInterfaces(String anInterface) {
        return this.interfaces.add(" " + anInterface);
    }

    public StringBuilder appendInnerContent(String content) {
        return this.appendInnerContent(content, true);
    }

    public StringBuilder appendInnerContent(String content, boolean lineBreak) {
        if (lineBreak) {
            return this.innerContent.append(content).append("\n");
        }
        return this.innerContent.append(content);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildPackage(stringBuilder);
        this.buildImports(stringBuilder);
        this.buildClassAnnotations(stringBuilder);
        this.buildClassDefinition(stringBuilder);
        stringBuilder.append(this.innerContent.toString());
        stringBuilder.append("\n}");
        return stringBuilder.toString();
    }

    private void buildClassDefinition(StringBuilder stringBuilder) {
        stringBuilder.append("public enum ");
        stringBuilder.append(this.className);
        if (!this.interfaces.isEmpty()) {
            stringBuilder.append(" implements");
        }
        stringBuilder.append(StringUtils.joinWithCommaSeparator((Collection)this.interfaces));
        stringBuilder.append(" {\n\n");
    }

    private void buildClassAnnotations(StringBuilder stringBuilder) {
        if (this.classAnnotation != null) {
            stringBuilder.append(this.classAnnotation + "\n");
        }
    }

    private void buildImports(StringBuilder stringBuilder) {
        for (String anImport : this.imports) {
            if (StringUtils.isEmpty((String)anImport)) {
                stringBuilder.append("\n");
                continue;
            }
            stringBuilder.append("import ");
            stringBuilder.append(anImport);
            stringBuilder.append(";\n");
        }
        if (!this.imports.isEmpty()) {
            stringBuilder.append("\n");
        }
    }

    private void buildPackage(StringBuilder stringBuilder) {
        stringBuilder.append("package org.butterfaces.");
        stringBuilder.append(this.subPackage);
        stringBuilder.append(";\n\n");
    }
}

