/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.filter.ClassFilters;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.modules.AbstractSingleModuleFinder;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.util.BootstrapUtil;
import org.wildfly.swarm.bootstrap.util.JarFileManager;
import org.wildfly.swarm.bootstrap.util.TempFileManager;

public class ApplicationModuleFinder
extends AbstractSingleModuleFinder {
    public static final String MODULE_NAME = "thorntail.application";
    private static final BootstrapLogger LOG = BootstrapLogger.logger("org.wildfly.swarm.modules.application");

    public ApplicationModuleFinder() {
        super(MODULE_NAME);
    }

    protected ApplicationModuleFinder(String slot) {
        super("thorntail.application: " + slot);
    }

    @Override
    public void buildModule(ModuleSpec.Builder builder, ModuleLoader delegateLoader) throws ModuleLoadException {
        ApplicationEnvironment env = ApplicationEnvironment.get();
        env.bootstrapModules().forEach(module -> builder.addDependency(DependencySpec.createModuleDependencySpec(PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), null, module, false)));
        try {
            this.addAsset(builder, env);
        }
        catch (IOException e) {
            throw new ModuleLoadException(e);
        }
        this.addDependencies(builder, env);
        try {
            this.addClasspathJars(builder);
        }
        catch (IOException e) {
            throw new ModuleLoadException(e);
        }
        builder.addDependency(DependencySpec.createModuleDependencySpec("org.jboss.modules"));
        builder.addDependency(DependencySpec.createModuleDependencySpec("org.jboss.shrinkwrap"));
        builder.addDependency(DependencySpec.createModuleDependencySpec("org.wildfly.swarm.configuration", false, true));
        builder.addDependency(DependencySpec.createModuleDependencySpec("sun.jdk", false, true));
        builder.addDependency(DependencySpec.createModuleDependencySpec(PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), null, "org.wildfly.swarm.container:api", true));
        builder.addDependency(DependencySpec.createLocalDependencySpec());
    }

    protected void addAsset(ModuleSpec.Builder builder, ApplicationEnvironment env) throws IOException {
        String path = env.getAsset();
        if (path == null) {
            return;
        }
        int slashLoc = path.lastIndexOf(47);
        String name = path;
        if (slashLoc > 0) {
            name = path.substring(slashLoc + 1);
        }
        String ext = ".jar";
        int dotLoc = name.lastIndexOf(46);
        if (dotLoc > 0) {
            ext = name.substring(dotLoc);
            name = name.substring(0, dotLoc);
        }
        File tmp = TempFileManager.INSTANCE.newTempFile(name, ext);
        try (InputStream artifactIn = this.getClass().getClassLoader().getResourceAsStream(path);){
            Files.copy(artifactIn, tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        String jarName = tmp.getName().toString();
        JarFile jarFile = new JarFile(tmp);
        File tmpDir = TempFileManager.INSTANCE.newTempDirectory(name, ext);
        BootstrapUtil.explodeJar(jarFile, tmpDir.getAbsolutePath());
        TempFileManager.INSTANCE.setExplodedApplicationArtifact(tmpDir);
        jarFile.close();
        tmp.delete();
        ResourceLoader jarLoader = ResourceLoaders.createFileResourceLoader(jarName, tmpDir);
        builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(jarLoader));
        if (".war".equalsIgnoreCase(ext)) {
            ResourceLoader warLoader = ResourceLoaders.createFileResourceLoader(jarName + "WEBINF", new File(tmpDir.getAbsolutePath() + File.separator + "WEB-INF" + File.separator + "classes"));
            builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(warLoader));
        }
    }

    protected void addDependencies(ModuleSpec.Builder builder, ApplicationEnvironment env) {
        env.getDependencies().forEach(dep -> {
            String[] parts = dep.split(":");
            ArtifactCoordinates coords = null;
            if (!parts[2].equals("jar")) {
                return;
            }
            if (parts.length == 4) {
                coords = new ArtifactCoordinates(parts[0], parts[1], parts[3]);
            } else if (parts.length == 5) {
                coords = new ArtifactCoordinates(parts[0], parts[1], parts[4], parts[3]);
            }
            try {
                File artifact = MavenResolvers.get().resolveJarArtifact(coords);
                if (artifact == null) {
                    LOG.error("Unable to find artifact for " + coords);
                    return;
                }
                JarFile jar = JarFileManager.INSTANCE.addJarFile(artifact);
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createJarResourceLoader(artifact.getName(), jar)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void addClasspathJars(ModuleSpec.Builder builder) throws IOException {
        String driversList = System.getProperty("thorntail.classpath");
        if (driversList != null && driversList.trim().length() > 0) {
            String[] drivers;
            for (String driver : drivers = driversList.split(";")) {
                File driverFile = new File(driver);
                if (!driverFile.exists()) continue;
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createJarResourceLoader(driverFile.getName(), new JarFile(driverFile))));
            }
        }
    }
}

