/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.xml.ModuleXmlParser;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.modules.NestedJarResourceLoader;
import org.wildfly.swarm.bootstrap.performance.Performance;

public class ClasspathModuleFinder
implements ModuleFinder {
    private static final char MODULE_SEPARATOR = '/';
    private static final BootstrapLogger LOG = BootstrapLogger.logger("org.wildfly.swarm.modules.classpath");

    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModuleSpec findModule(String identifier, ModuleLoader delegateLoader) throws ModuleLoadException {
        String simpleIdentifier = identifier;
        if (!identifier.contains(":")) {
            identifier = identifier + ":main";
        }
        try {
            Throwable throwable = null;
            try (AutoCloseable handle = Performance.accumulate("module: Classpath");){
                URL url;
                String path;
                block36: {
                    String[] nameAndSlot = identifier.split("\\:", 2);
                    path = "modules/" + nameAndSlot[0].replace('.', '/') + '/' + nameAndSlot[1] + "/module.xml";
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("attempt:" + identifier);
                    }
                    try {
                        ClassLoader cl = ApplicationEnvironment.get().getBootstrapClassLoader();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("classloader: " + cl);
                            LOG.trace("path: " + path);
                        }
                        if ((url = ClasspathModuleFinder.findResourceInClassLoader(cl, path)) == null && cl != ClasspathModuleFinder.class.getClassLoader()) {
                            url = ClasspathModuleFinder.findResourceInClassLoader(ClasspathModuleFinder.class.getClassLoader(), path);
                        }
                        if (url != null) break block36;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("not found: " + identifier);
                        }
                        ModuleSpec moduleSpec = null;
                        return moduleSpec;
                    }
                    catch (IOException e) {
                        try {
                            throw new ModuleLoadException(e);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                }
                URL base = new URL(url, "./");
                if (LOG.isTraceEnabled()) {
                    LOG.trace("base of " + identifier + ": " + base);
                }
                InputStream in = url.openStream();
                Path explodedJar = NestedJarResourceLoader.explodedJar(base);
                ModuleSpec moduleSpec = null;
                try {
                    moduleSpec = ModuleXmlParser.parseModuleXml((rootPath, loaderPath, loaderName) -> NestedJarResourceLoader.loaderFor(base, rootPath, loaderPath, loaderName), MavenResolvers.get(), explodedJar == null ? "/" : explodedJar.toAbsolutePath().toString(), in, path.toString(), delegateLoader, simpleIdentifier);
                }
                catch (IOException e) {
                    throw new ModuleLoadException(e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new ModuleLoadException(e);
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Loaded ModuleSpec: " + moduleSpec.getName());
                }
                ModuleSpec moduleSpec2 = moduleSpec;
                return moduleSpec2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static URL findResourceInClassLoader(ClassLoader cl, String path) throws IOException {
        Enumeration<URL> resources = cl.getResources(path);
        while (resources.hasMoreElements()) {
            URL candidate = resources.nextElement();
            if (!candidate.toString().contains("redhat-")) continue;
            return candidate;
        }
        return cl.getResource(path);
    }
}

