/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.security.CodeSource;
import java.util.Collections;
import java.util.jar.JarFile;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaders;
import org.wildfly.swarm.jdk.specific.JarFiles;

public class Environment {
    public static FileSystem getFileSystem() {
        return Holder.FILE_SYSTEM;
    }

    public static ResourceLoader getModuleResourceLoader(String rootPath, String loaderPath, String loaderName) {
        if (Holder.JAR_FILE != null) {
            return new JarFileResourceLoader(loaderName, Holder.JAR_FILE, Holder.FILE_SYSTEM.getPath(rootPath, loaderPath).toString());
        }
        return ResourceLoaders.createFileResourceLoader(loaderPath, new File(rootPath));
    }

    private static final class Holder {
        static final FileSystem FILE_SYSTEM;
        static final JarFile JAR_FILE;

        private Holder() {
        }

        static {
            URI pathUri;
            ClassLoader cl = Environment.class.getClassLoader();
            URL pathUrl = cl.getResource(Environment.class.getName().replace('.', '/') + ".class");
            if (pathUrl == null) {
                throw new RuntimeException("Could not discover the file system needed for the environment");
            }
            try {
                pathUri = pathUrl.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not create FileSystem for " + pathUrl, e);
            }
            if (pathUrl.getProtocol().startsWith("jar")) {
                try {
                    FILE_SYSTEM = FileSystems.newFileSystem(pathUri, Collections.emptyMap(), cl);
                    Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                FILE_SYSTEM.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }));
                    CodeSource codeSource = Environment.class.getProtectionDomain().getCodeSource();
                    if (codeSource == null) {
                        throw new RuntimeException("The code source could not be determine.");
                    }
                    JAR_FILE = JarFiles.create(new File(codeSource.getLocation().toURI()));
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException("Could not create FileSystem for " + pathUrl, e);
                }
            } else {
                JAR_FILE = null;
                FILE_SYSTEM = FileSystems.getDefault();
            }
        }
    }
}

