/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.showcase.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.butterfaces.component.showcase.AbstractCodeShowcase;
import org.butterfaces.component.showcase.container.RepeatExampleType;
import org.butterfaces.component.showcase.container.examples.NestedRepeatBeanCodeExample;
import org.butterfaces.component.showcase.container.examples.NestedRepeatListXhtmlCodeExample;
import org.butterfaces.component.showcase.container.examples.SimpleRepeatBeanCodeExample;
import org.butterfaces.component.showcase.container.examples.SimpleRepeatListXhtmlCodeExample;
import org.butterfaces.component.showcase.container.examples.StargateRepeatBeanCodeExample;
import org.butterfaces.component.showcase.container.examples.StargateRepeatListCssCodeExample;
import org.butterfaces.component.showcase.container.examples.StargateRepeatListXhtmlCodeExample;
import org.butterfaces.component.showcase.example.AbstractCodeExample;
import org.butterfaces.component.showcase.example.CssCodeExample;
import org.butterfaces.component.showcase.table.DemoPojo;
import org.butterfaces.component.showcase.table.example.DemoPojoCodeExample;
import org.butterfaces.component.showcase.tree.Episode;
import org.butterfaces.component.showcase.tree.Episodes;
import org.butterfaces.component.showcase.tree.examples.stargate.TreeBoxEpisodesJavaExample;
import org.butterfaces.model.tree.EnumTreeBoxWrapper;

@Named
@ViewScoped
public class RepeatShowcase
extends AbstractCodeShowcase
implements Serializable {
    private RepeatExampleType selectedExampleType = RepeatExampleType.STARGATE;
    private final List<DemoPojo> values = new ArrayList();

    public RepeatShowcase() {
        for (int i = 0; i < 123; ++i) {
            this.values.add(new DemoPojo((long)i, "a" + i, "b" + i));
        }
    }

    public void play() {
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        if (this.selectedExampleType == RepeatExampleType.SIMPLE) {
            codeExamples.add((AbstractCodeExample)new SimpleRepeatListXhtmlCodeExample(this.isRendered()));
            codeExamples.add((AbstractCodeExample)new SimpleRepeatBeanCodeExample());
            codeExamples.add((AbstractCodeExample)new DemoPojoCodeExample("repeat.demo"));
            CssCodeExample cssCodeExample = new CssCodeExample();
            cssCodeExample.addCss(".repeat-simple-list", new String[]{"max-height: 400px", "overflow: auto"});
            codeExamples.add((AbstractCodeExample)cssCodeExample);
        } else if (this.selectedExampleType == RepeatExampleType.STARGATE) {
            codeExamples.add((AbstractCodeExample)new StargateRepeatListXhtmlCodeExample(this.isRendered()));
            codeExamples.add((AbstractCodeExample)new StargateRepeatBeanCodeExample());
            codeExamples.add((AbstractCodeExample)new TreeBoxEpisodesJavaExample("repeat.demo"));
            codeExamples.add((AbstractCodeExample)new StargateRepeatListCssCodeExample());
        } else {
            codeExamples.add((AbstractCodeExample)new NestedRepeatListXhtmlCodeExample());
            codeExamples.add((AbstractCodeExample)new NestedRepeatBeanCodeExample());
        }
    }

    public List<Episode> getValues() {
        return Episodes.EPISODES;
    }

    public List<DemoPojo> getDemoPojos() {
        return this.values;
    }

    public List<String> getNestedOuterValues() {
        return Arrays.asList("A", "B", "C");
    }

    public List<String> getNestedInnerValueForOuterValue(String outerValue) {
        return Arrays.asList(outerValue + "1", outerValue + "2", outerValue + "3");
    }

    public List<EnumTreeBoxWrapper> getExampleTypes() {
        ArrayList<EnumTreeBoxWrapper> items = new ArrayList<EnumTreeBoxWrapper>();
        for (RepeatExampleType type : RepeatExampleType.values()) {
            items.add(new EnumTreeBoxWrapper((Enum)type, type.label));
        }
        return items;
    }

    public RepeatExampleType getSelectedExampleType() {
        return this.selectedExampleType;
    }

    public void setSelectedExampleType(RepeatExampleType selectedExampleType) {
        this.selectedExampleType = selectedExampleType;
    }
}

