/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.modules.AbstractSingleModuleFinder;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.bootstrap.util.JarFileManager;

public class BootstrapModuleFinder
extends AbstractSingleModuleFinder {
    public static final String MODULE_NAME = "org.wildfly.swarm.bootstrap";
    private static final BootstrapLogger LOG = BootstrapLogger.logger("org.wildfly.swarm.modules.bootstrap");

    public BootstrapModuleFinder() {
        super(MODULE_NAME);
    }

    @Override
    public void buildModule(ModuleSpec.Builder builder, ModuleLoader delegateLoader) throws ModuleLoadException {
        try (AutoCloseable handle = Performance.accumulate("module: Bootstrap");){
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading module");
            }
            ApplicationEnvironment env = ApplicationEnvironment.get();
            PathFilter filter = new PathFilter(){

                @Override
                public boolean accept(String path) {
                    return path.endsWith("/module.xml");
                }
            };
            env.bootstrapArtifactsAsCoordinates().forEach(coords -> {
                try {
                    File artifact = MavenResolvers.get().resolveJarArtifact((ArtifactCoordinates)coords);
                    if (artifact == null) {
                        throw new RuntimeException("Unable to resolve artifact from coordinates: " + coords);
                    }
                    JarFile jar = JarFileManager.INSTANCE.addJarFile(artifact);
                    IterableResourceLoader originaloader = ResourceLoaders.createJarResourceLoader(artifact.getName(), jar);
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createFilteredResourceLoader(filter, (ResourceLoader)originaloader)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            builder.addDependency(DependencySpec.createLocalDependencySpec());
            builder.addDependency(new ModuleDependencySpecBuilder().setName("org.jboss.modules").build());
            builder.addDependency(new ModuleDependencySpecBuilder().setName("org.jboss.shrinkwrap").build());
            builder.addDependency(new ModuleDependencySpecBuilder().setName("org.yaml.snakeyaml").build());
            HashSet<String> paths = new HashSet<String>();
            paths.add("org/wildfly/swarm/bootstrap/env");
            paths.add("org/wildfly/swarm/bootstrap/logging");
            paths.add("org/wildfly/swarm/bootstrap/modules");
            paths.add("org/wildfly/swarm/bootstrap/performance");
            paths.add("org/wildfly/swarm/bootstrap/util");
            builder.addDependency(DependencySpec.createSystemDependencySpec(paths, true));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

