/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.showcase.tags;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.butterfaces.component.showcase.AbstractInputShowcase;
import org.butterfaces.component.showcase.example.AbstractCodeExample;
import org.butterfaces.component.showcase.example.XhtmlCodeExample;
import org.butterfaces.component.showcase.tags.TagsExampleType;
import org.butterfaces.component.showcase.tree.Episodes;
import org.butterfaces.component.showcase.type.StyleClass;
import org.butterfaces.model.tree.EnumTreeBoxWrapper;
import org.butterfaces.util.StringUtils;

@Named
@ViewScoped
public class TagsShowcase
extends AbstractInputShowcase
implements Serializable {
    private TagsExampleType selectedTagsExampleType = TagsExampleType.STRINGS;
    private String placeholder = "Enter text...";
    private String confirmKeys;
    private boolean autoFocus;
    private boolean distinct = true;
    private Integer maxTags;

    protected Object initValue() {
        return null;
    }

    public String getReadableValue() {
        return (String)this.getValue();
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:tags id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                hideLabel=\"" + this.isHideLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                distinct=\"" + this.distinct + "\"");
        xhtmlCodeExample.appendInnerContent("                maxTags=\"" + this.maxTags + "\"");
        xhtmlCodeExample.appendInnerContent("                confirmKeys=\"" + StringUtils.getNotNullValue((String)this.confirmKeys, (String)"") + "\"");
        xhtmlCodeExample.appendInnerContent("                placeholder=\"" + this.getPlaceholder() + "\"");
        if (this.getStyleClass() == StyleClass.BIG_LABEL) {
            xhtmlCodeExample.appendInnerContent("                styleClass=\"" + this.getSelectedStyleClass() + "\"");
        }
        xhtmlCodeExample.appendInnerContent("                readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                disabled=\"" + this.isDisabled() + "\"");
        xhtmlCodeExample.appendInnerContent("                required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                autoFocus=\"" + this.isAutoFocus() + "\"");
        xhtmlCodeExample.appendInnerContent("                rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "change");
        if (this.isValidation()) {
            xhtmlCodeExample.appendInnerContent("            <f:validateLength minimum=\"2\" maximum=\"10\"/>");
        }
        if (StringUtils.isNotEmpty((String)this.getTooltip())) {
            xhtmlCodeExample.appendInnerContent("            <b:tooltip>");
            xhtmlCodeExample.appendInnerContent("                " + this.getTooltip());
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:tags>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        this.generateDemoCSS(codeExamples);
    }

    public List<EnumTreeBoxWrapper> getTagsExampleTypes() {
        ArrayList<EnumTreeBoxWrapper> items = new ArrayList<EnumTreeBoxWrapper>();
        for (TagsExampleType type : TagsExampleType.values()) {
            items.add(new EnumTreeBoxWrapper((Enum)type, type.label));
        }
        return items;
    }

    public List getEntries() {
        if (this.selectedTagsExampleType == TagsExampleType.EXPERIMENTAL) {
            return Episodes.EPISODES;
        }
        return null;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public Integer getMaxTags() {
        return this.maxTags;
    }

    public void setMaxTags(Integer maxTags) {
        this.maxTags = maxTags;
    }

    public String getConfirmKeys() {
        return this.confirmKeys;
    }

    public void setConfirmKeys(String confirmKeys) {
        this.confirmKeys = confirmKeys;
    }

    public TagsExampleType getSelectedTagsExampleType() {
        return this.selectedTagsExampleType;
    }

    public void setSelectedTagsExampleType(TagsExampleType selectedTagsExampleType) {
        this.selectedTagsExampleType = selectedTagsExampleType;
    }
}

