/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class BootstrapUtil {
    private BootstrapUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void explodeJar(JarFile jarFile, String destDir) throws IOException {
        Enumeration<JarEntry> enu = jarFile.entries();
        while (enu.hasMoreElements()) {
            JarEntry je = enu.nextElement();
            File fl = new File(destDir, je.getName());
            if (!fl.exists()) {
                fl.getParentFile().mkdirs();
                fl = new File(destDir, je.getName());
            }
            if (je.isDirectory()) continue;
            InputStream is = null;
            try {
                is = jarFile.getInputStream(je);
                Files.copy(is, fl.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    public static void convertSwarmSystemPropertiesToThorntail() {
        for (String systemProperty : System.getProperties().stringPropertyNames()) {
            String corresponding;
            if (!systemProperty.startsWith("swarm.") || System.getProperty(corresponding = systemProperty.replaceFirst("^swarm\\.", "thorntail.")) != null) continue;
            System.setProperty(corresponding, System.getProperty(systemProperty));
        }
    }
}

