/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.showcase.text;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import org.apache.commons.validator.routines.UrlValidator;
import org.butterfaces.component.showcase.text.URLBookmark;

@FacesConverter(value="urlConverter")
public class UrlConverter
implements Converter {
    public static final String HTTP = "http://";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        StringBuilder url = new StringBuilder();
        this.appendHttpIfNecessary(value, url);
        if (!new UrlValidator().isValid(url.toString())) {
            FacesMessage msg = new FacesMessage("URL Conversion error.", "Invalid URL format.");
            msg.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ConverterException(msg);
        }
        return new URLBookmark(url.toString());
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        return value.toString();
    }

    private void appendHttpIfNecessary(String value, StringBuilder url) {
        if (!value.startsWith(HTTP, 0)) {
            url.append(HTTP);
        }
        url.append(value);
    }
}

