// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.ale;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.ale.global.ale.*;


/**
  @author  Bradford W. Mott
  @version $Id: Event.hxx,v 1.28 2007/01/30 17:13:07 stephena Exp $
*/
@NoOffset @Properties(inherit = org.bytedeco.ale.presets.ale.class)
public class Event extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Event(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Event(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Event position(long position) {
        return (Event)super.position(position);
    }

    /**
      Enumeration of all possible events in Stella, including both
      console and controller event types as well as events that aren't
      technically part of the emulation core
    */
    /** enum Event::Type */
    public static final int
      NoType = 0,
      ConsoleOn = 1, ConsoleOff = 2, ConsoleColor = 3, ConsoleBlackWhite = 4,
      ConsoleLeftDifficultyA = 5, ConsoleLeftDifficultyB = 6,
      ConsoleRightDifficultyA = 7, ConsoleRightDifficultyB = 8,
      ConsoleSelect = 9, ConsoleReset = 10,

      JoystickZeroUp = 11, JoystickZeroDown = 12, JoystickZeroLeft = 13,
      JoystickZeroRight = 14, JoystickZeroFire = 15,
      JoystickOneUp = 16, JoystickOneDown = 17, JoystickOneLeft = 18,
      JoystickOneRight = 19, JoystickOneFire = 20,

      BoosterGripZeroTrigger = 21, BoosterGripZeroBooster = 22,
      BoosterGripOneTrigger = 23, BoosterGripOneBooster = 24,

      PaddleZeroResistance = 25, PaddleZeroFire = 26,
        PaddleZeroDecrease = 27, PaddleZeroIncrease = 28, PaddleZeroAnalog = 29,
      PaddleOneResistance = 30, PaddleOneFire = 31,
        PaddleOneDecrease = 32, PaddleOneIncrease = 33, PaddleOneAnalog = 34,
      PaddleTwoResistance = 35, PaddleTwoFire = 36,
        PaddleTwoDecrease = 37, PaddleTwoIncrease = 38, PaddleTwoAnalog = 39,
      PaddleThreeResistance = 40, PaddleThreeFire = 41,
        PaddleThreeDecrease = 42, PaddleThreeIncrease = 43, PaddleThreeAnalog = 44,

      KeyboardZero1 = 45, KeyboardZero2 = 46, KeyboardZero3 = 47,
      KeyboardZero4 = 48, KeyboardZero5 = 49, KeyboardZero6 = 50,
      KeyboardZero7 = 51, KeyboardZero8 = 52, KeyboardZero9 = 53,
      KeyboardZeroStar = 54, KeyboardZero0 = 55, KeyboardZeroPound = 56,

      KeyboardOne1 = 57, KeyboardOne2 = 58, KeyboardOne3 = 59,
      KeyboardOne4 = 60, KeyboardOne5 = 61, KeyboardOne6 = 62,
      KeyboardOne7 = 63, KeyboardOne8 = 64, KeyboardOne9 = 65,
      KeyboardOneStar = 66, KeyboardOne0 = 67, KeyboardOnePound = 68,

      DrivingZeroClockwise = 69, DrivingZeroCounterClockwise = 70, DrivingZeroValue = 71, 
      DrivingZeroFire = 72,
      DrivingOneClockwise = 73, DrivingOneCounterClockwise = 74, DrivingOneValue = 75,
      DrivingOneFire = 76,
      
      ChangeState = 77, LoadState = 78, SaveState = 79, TakeSnapshot = 80, Quit = 81,
      PauseMode = 82, MenuMode = 83, CmdMenuMode = 84, DebuggerMode = 85, LauncherMode = 86,
      Fry = 87, VolumeDecrease = 88, VolumeIncrease = 89,

      UIUp = 90, UIDown = 91, UILeft = 92, UIRight = 93, UIHome = 94, UIEnd = 95, UIPgUp = 96, UIPgDown = 97,
      UISelect = 98, UINavPrev = 99, UINavNext = 100, UIOK = 101, UICancel = 102,

      LastType = 103;
    /**
      Create a new event object and use the given eventstreamer
    */
    public Event() { super((Pointer)null); allocate(); }
    private native void allocate();
 
    /**
      Destructor
    */
    /**
      Get the value associated with the event of the specified type
    */
    public native @Cast("Int32") int get(@Cast("Event::Type") int type);

    /**
      Set the value associated with the event of the specified type
    */
    public native void set(@Cast("Event::Type") int type, @Cast("Int32") int value);

    /**
      Clears the event array (resets to initial state)
    */
    public native void clear();
}
