// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.ale;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ale.global.ale.*;


@NoOffset @Properties(inherit = org.bytedeco.ale.presets.ale.class)
public class ColourPalette extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ColourPalette(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ColourPalette(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ColourPalette position(long position) {
        return (ColourPalette)super.position(position);
    }
    @Override public ColourPalette getPointer(long i) {
        return new ColourPalette(this).position(position + i);
    }


        public ColourPalette() { super((Pointer)null); allocate(); }
        private native void allocate();

        /** Converts a given palette value in range [0, 255] into its RGB components. */ 
        public native void getRGB(int val, @ByRef IntPointer r, @ByRef IntPointer g, @ByRef IntPointer b);
        public native void getRGB(int val, @ByRef IntBuffer r, @ByRef IntBuffer g, @ByRef IntBuffer b);
        public native void getRGB(int val, @ByRef int[] r, @ByRef int[] g, @ByRef int[] b); 
        
        /** Converts a given palette value into packed RGB (format 0x00RRGGBB). */
        public native @Cast("uInt32") int getRGB(int val);

        /** Returns the byte-sized grayscale value for this palette index. */ 
        public native @Cast("uInt8") byte getGrayscale(int val); 

        /**
            Applies the current RGB palette to the src_buffer and returns the results in dst_buffer
            For each byte in src_buffer, three bytes are returned in dst_buffer
            8 bits => 24 bits
         */
        public native void applyPaletteRGB(@Cast("uInt8*") BytePointer dst_buffer, @Cast("uInt8*") BytePointer src_buffer, @Cast("size_t") long src_size);
        public native void applyPaletteRGB(@Cast("uInt8*") ByteBuffer dst_buffer, @Cast("uInt8*") ByteBuffer src_buffer, @Cast("size_t") long src_size);
        public native void applyPaletteRGB(@Cast("uInt8*") byte[] dst_buffer, @Cast("uInt8*") byte[] src_buffer, @Cast("size_t") long src_size);

        /**
            Applies the current grayscale palette to the src_buffer and returns the results in dst_buffer
            For each byte in src_buffer, a single byte is returned in dst_buffer
            8 bits => 8 bits
         */
        public native void applyPaletteGrayscale(@Cast("uInt8*") BytePointer dst_buffer, @Cast("uInt8*") BytePointer src_buffer, @Cast("size_t") long src_size);
        public native void applyPaletteGrayscale(@Cast("uInt8*") ByteBuffer dst_buffer, @Cast("uInt8*") ByteBuffer src_buffer, @Cast("size_t") long src_size);
        public native void applyPaletteGrayscale(@Cast("uInt8*") byte[] dst_buffer, @Cast("uInt8*") byte[] src_buffer, @Cast("size_t") long src_size);

        /**
          Loads all defined palettes with PAL color-loss data depending
          on 'state'.
          Sets the palette according to the given palette name.
          <p>
          @param type  The palette type = {standard, z26, user}
          @param displayFormat The display format = { NTSC, PAL, SECAM }
        */
        public native void setPalette(@StdString BytePointer type,
                                @StdString BytePointer displayFormat);
        public native void setPalette(@StdString String type,
                                @StdString String displayFormat);

        /**
            Loads a user-defined palette file (from OSystem::paletteFile), filling the
            appropriate user-defined palette arrays.
        */
        public native void loadUserPalette(@StdString BytePointer paletteFile);
        public native void loadUserPalette(@StdString String paletteFile);
}
