// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.ale;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ale.global.ale.*;


/**
   This class interfaces ALE with external code for controlling agents.
 */
@NoOffset @Properties(inherit = org.bytedeco.ale.presets.ale.class)
public class ALEInterface extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ALEInterface(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ALEInterface(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ALEInterface position(long position) {
        return (ALEInterface)super.position(position);
    }
    @Override public ALEInterface getPointer(long i) {
        return new ALEInterface((Pointer)this).offsetAddress(i);
    }

  public ALEInterface() { super((Pointer)null); allocate(); }
  private native void allocate();
  // Legacy constructor
  public ALEInterface(@Cast("bool") boolean display_screen) { super((Pointer)null); allocate(display_screen); }
  private native void allocate(@Cast("bool") boolean display_screen);

  // Get the value of a setting.
  public native @StdString BytePointer getString(@StdString BytePointer key);
  public native @StdString String getString(@StdString String key);
  public native int getInt(@StdString BytePointer key);
  public native int getInt(@StdString String key);
  public native @Cast("bool") boolean getBool(@StdString BytePointer key);
  public native @Cast("bool") boolean getBool(@StdString String key);
  public native float getFloat(@StdString BytePointer key);
  public native float getFloat(@StdString String key);

  // Set the value of a setting. loadRom() must be called before the
  // setting will take effect.
  public native void setString(@StdString BytePointer key, @StdString BytePointer value);
  public native void setString(@StdString String key, @StdString String value);
  public native void setInt(@StdString BytePointer key, int value);
  public native void setInt(@StdString String key, int value);
  public native void setBool(@StdString BytePointer key, @Cast("const bool") boolean value);
  public native void setBool(@StdString String key, @Cast("const bool") boolean value);
  public native void setFloat(@StdString BytePointer key, float value);
  public native void setFloat(@StdString String key, float value);

  // Resets the Atari and loads a game. After this call the game
  // should be ready to play. This is necessary after changing a
  // setting for the setting to take effect.
  public native void loadROM(@StdString BytePointer rom_file);
  public native void loadROM(@StdString String rom_file);

  // Applies an action to the game and returns the reward. It is the
  // user's responsibility to check if the game has ended and reset
  // when necessary - this method will keep pressing buttons on the
  // game over screen.
  public native @Cast("reward_t") int act(@Cast("Action") int action);

  // Indicates if the game has ended.
  public native @Cast("bool") boolean game_over();

  // Resets the game, but not the full system.
  public native void reset_game();

  // Returns the vector of modes available for the current game.
  // This should be called only after the rom is loaded.
  public native @Cast("game_mode_t*") @StdVector IntPointer getAvailableModes();

  // Sets the mode of the game.
  // The mode must be an available mode (otherwise it throws an exception).
  // This should be called only after the rom is loaded.
  public native void setMode(@Cast("game_mode_t") int m);

  //Returns the vector of difficulties available for the current game.
  //This should be called only after the rom is loaded. Notice
  // that there are 2 levers, the right and left switches. They
  // are not tied to any specific player. In Venture, for example,
  // we have the following interpretation for the difficulties:
  // Skill          Switch
  // Level          Setting
  //   1         left B/right B
  //   2         left B/right A
  //   3         left A/right B
  //   4         left A/right A
  public native @Cast("difficulty_t*") @StdVector IntPointer getAvailableDifficulties();

  // Sets the difficulty of the game.
  // The difficulty must be an available mode (otherwise it throws an exception).
  // This should be called only after the rom is loaded.
  public native void setDifficulty(@Cast("difficulty_t") int m);

  // Returns the vector of legal actions. This should be called only
  // after the rom is loaded.
  public native @Cast("Action*") @StdVector IntPointer getLegalActionSet();

  // Returns the vector of the minimal set of actions needed to play
  // the game.
  public native @Cast("Action*") @StdVector IntPointer getMinimalActionSet();

  // Returns the frame number since the loading of the ROM
  public native int getFrameNumber();

  // The remaining number of lives.
  public native int lives();

  // Returns the frame number since the start of the current episode
  public native int getEpisodeFrameNumber();

  // Returns the current game screen
  public native @Const @ByRef ALEScreen getScreen();

  //This method should receive an empty vector to fill it with
  //the grayscale colours
  public native void getScreenGrayscale(@Cast("unsigned char*") @StdVector BytePointer grayscale_output_buffer);
  public native void getScreenGrayscale(@Cast("unsigned char*") @StdVector ByteBuffer grayscale_output_buffer);
  public native void getScreenGrayscale(@Cast("unsigned char*") @StdVector byte[] grayscale_output_buffer);

  //This method should receive a vector to fill it with
  //the RGB colours. The first positions contain the red colours,
  //followed by the green colours and then the blue colours
  public native void getScreenRGB(@Cast("unsigned char*") @StdVector BytePointer output_rgb_buffer);
  public native void getScreenRGB(@Cast("unsigned char*") @StdVector ByteBuffer output_rgb_buffer);
  public native void getScreenRGB(@Cast("unsigned char*") @StdVector byte[] output_rgb_buffer);

  // Returns the current RAM content
  public native @Const @ByRef ALERAM getRAM();

  // Saves the state of the system
  public native void saveState();

  // Loads the state of the system
  public native void loadState();

  // This makes a copy of the environment state. This copy does *not* include pseudorandomness,
  // making it suitable for planning purposes. By contrast, see cloneSystemState.
  public native @ByVal ALEState cloneState();

  // Reverse operation of cloneState(). This does not restore pseudorandomness, so that repeated
  // calls to restoreState() in the stochastic controls setting will not lead to the same outcomes.
  // By contrast, see restoreSystemState.
  public native void restoreState(@Const @ByRef ALEState state);

  // This makes a copy of the system & environment state, suitable for serialization. This includes
  // pseudorandomness and so is *not* suitable for planning purposes.
  public native @ByVal ALEState cloneSystemState();

  // Reverse operation of cloneSystemState.
  public native void restoreSystemState(@Const @ByRef ALEState state);

  // Save the current screen as a png file
  public native void saveScreenPNG(@StdString BytePointer filename);
  public native void saveScreenPNG(@StdString String filename);

  // Creates a ScreenExporter object which can be used to save a sequence of frames. Ownership 
  // said object is passed to the caller. Frames are saved in the directory 'path', which needs
  // to exists. 
  public native ScreenExporter createScreenExporter(@StdString BytePointer path);
  public native ScreenExporter createScreenExporter(@StdString String path);
  public native @Name("theOSystem.get") OSystem theOSystem();
  public native @Name("theSettings.get") Settings theSettings();
  public native @Name("romSettings.get") RomSettings romSettings();
  public native @Name("environment.get") StellaEnvironment environment();
  public native int max_num_frames(); public native ALEInterface max_num_frames(int setter);
  // Display ALE welcome message
  public static native @StdString BytePointer welcomeMessage();
  public static native void disableBufferedIO();
  public static native void createOSystem(@UniquePtr OSystem theOSystem,
                              @UniquePtr Settings theSettings);
  public static native void loadSettings(@StdString BytePointer romfile,
                             @UniquePtr OSystem theOSystem);
  public static native void loadSettings(@StdString String romfile,
                             @UniquePtr OSystem theOSystem);
}
