// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.ale;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ale.global.ale.*;


/**
  @author  Bradford W. Mott
  @version $Id: Event.hxx,v 1.28 2007/01/30 17:13:07 stephena Exp $
*/
@Namespace("ale::stella") @NoOffset @Properties(inherit = org.bytedeco.ale.presets.ale.class)
public class Event extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Event(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Event(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Event position(long position) {
        return (Event)super.position(position);
    }
    @Override public Event getPointer(long i) {
        return new Event((Pointer)this).offsetAddress(i);
    }

    /**
      Enumeration of all possible events in Stella, including both
      console and controller event types as well as events that aren't
      technically part of the emulation core
    */
    /** enum ale::stella::Event::Type */
    public static final int
      ConsoleColor = 0, ConsoleBlackWhite = 1,
      ConsoleLeftDifficultyA = 2, ConsoleLeftDifficultyB = 3,
      ConsoleRightDifficultyA = 4, ConsoleRightDifficultyB = 5,
      ConsoleSelect = 6, ConsoleReset = 7,

      JoystickZeroUp = 8, JoystickZeroDown = 9, JoystickZeroLeft = 10,
      JoystickZeroRight = 11, JoystickZeroFire = 12,
      JoystickOneUp = 13, JoystickOneDown = 14, JoystickOneLeft = 15,
      JoystickOneRight = 16, JoystickOneFire = 17,

      PaddleZeroResistance = 18, PaddleZeroFire = 19,
        PaddleZeroDecrease = 20, PaddleZeroIncrease = 21, PaddleZeroAnalog = 22,
      PaddleOneResistance = 23, PaddleOneFire = 24,
        PaddleOneDecrease = 25, PaddleOneIncrease = 26, PaddleOneAnalog = 27,
      PaddleTwoResistance = 28, PaddleTwoFire = 29,
        PaddleTwoDecrease = 30, PaddleTwoIncrease = 31, PaddleTwoAnalog = 32,
      PaddleThreeResistance = 33, PaddleThreeFire = 34,
        PaddleThreeDecrease = 35, PaddleThreeIncrease = 36, PaddleThreeAnalog = 37,

      LastType = 38;
    /**
      Create a new event object and use the given eventstreamer
    */
    public Event() { super((Pointer)null); allocate(); }
    private native void allocate();

    /**
      Destructor
    */
    /**
      Get the value associated with the event of the specified type
    */
    public native int get(@Cast("ale::stella::Event::Type") int type);

    /**
      Set the value associated with the event of the specified type
    */
    public native void set(@Cast("ale::stella::Event::Type") int type, int value);

    /**
      Clears the event array (resets to initial state)
    */
    public native void clear();
}
