// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.ale;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ale.global.ale.*;


@Namespace("ale") @NoOffset @Properties(inherit = org.bytedeco.ale.presets.ale.class)
public class StellaEnvironment extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StellaEnvironment(Pointer p) { super(p); }

  public StellaEnvironment(OSystem system, RomSettings settings) { super((Pointer)null); allocate(system, settings); }
  private native void allocate(OSystem system, RomSettings settings);

  /** Resets the system to its start state. */
  public native void reset();

  /** Returns a copy of the current environment state. Note that by default this **does**
   * include the PNRG for sticky actions. You can optionally include the PRNG by setting
   * {@code include_rng} to true. For planning you probably want to disable
   * sticky actions. The emulator is fully deterministic. */
  public native @ByVal ALEState cloneState(@Cast("bool") boolean include_rng/*=false*/);
  public native @ByVal ALEState cloneState();
  /** Restores a previously saved copy of the state. */
  public native void restoreState(@Const @ByRef ALEState arg0);

  /** Applies the given actions (e.g. updating paddle positions when the paddle is used)
   *  and performs one simulation step in Stella. Returns the resultant reward. When
   *  frame skip is set to > 1, up the corresponding number of simulation steps are performed.
   *  Note that the post-act() frame number might not correspond to the pre-act() frame
   *  number plus the frame skip.
   */
  public native @Cast("ale::reward_t") int act(@Cast("ale::Action") int player_a_action, @Cast("ale::Action") int player_b_action);

  /** This functions emulates a push on the reset button of the console */
  public native void softReset();

  /** Keep pressing the console select button for a given amount of time*/
  public native void pressSelect(@Cast("size_t") long num_steps/*=1*/);
  public native void pressSelect();

  /** Set the difficulty according to the value.
   *  If the first bit is 1, then it will put the left difficulty switch to A (otherwise leave it on B)
   *  If the second bit is 1, then it will put the right difficulty switch to A (otherwise leave it on B)
   *
   *  This change takes effect at the immediate next time step.
   */
  public native void setDifficulty(@Cast("ale::difficulty_t") int value);

  /** Set the game mode according to the value. The new mode will not take effect until reset() is
   *  called */
  public native void setMode(@Cast("ale::game_mode_t") int value);

  /** Returns true if the ROM reported a terminal signal OR if the episode is truncated
   * (i.e., isGameTerminal() || isTruncated()).
   * This functions serves to be backwards compatible with previous versions of ALE. */
  public native @Cast("bool") boolean isTerminal();

  /** Returns true if the ROM reported a terminal signal */
  public native @Cast("bool") boolean isGameTerminal();

  /** Returns true if the episode is truncated, i.e., max number of frames is reached */
  public native @Cast("bool") boolean isGameTruncated();

  /** Accessor methods for the environment state. */
  public native void setState(@Const @ByRef ALEState state);
  public native @Const @ByRef ALEState getState();

  /** Returns the current screen after processing (e.g. colour averaging) */
  public native @Const @ByRef ALEScreen getScreen();

  /** Accessor methods for RAM. {@code setRAM} can be useful to alter the environment.
   *  For example, learning a causal model of RAM transitions, changing environment dynamics, etc. */
  public native void setRAM(@Cast("size_t") long memory_index, @Cast("ale::byte_t") byte value);
  public native @Const @ByRef ALERAM getRAM();

  public native int getFrameNumber();
  public native int getEpisodeFrameNumber();

  public native @ByRef Random getEnvironmentRNG();

  // Returns the current difficulty switch setting in use by the environment.
  public native @Cast("ale::difficulty_t") int getDifficulty();

  // Returns the game mode value last specified to the environment.
  // This may not be the exact game mode that the ROM is currently running as
  // game mode changes only take effect when the environment is reset.
  public native @Cast("ale::game_mode_t") int getMode();

  /** Returns a wrapper providing #include-free access to our methods. */
  public native @Name("getWrapper().get") StellaEnvironmentWrapper getWrapper();
}
