// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.ale;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ale.global.ale.*;


/**
  This class represents objects which maintain a collection of
  properties.  A property is a key and its corresponding value.
  <p>
  A properties object can contain a reference to another properties
  object as its "defaults"; this second properties object is searched
  if the property key is not found in the original property list.
  <p>
  @author  Bradford W. Mott
  @version $Id: Props.hxx,v 1.15 2007/02/06 23:34:33 stephena Exp $
*/
@Name("ale::stella::Properties") @NoOffset @Properties(inherit = org.bytedeco.ale.presets.ale.class)
public class StellaProperties extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StellaProperties(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public StellaProperties(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public StellaProperties position(long position) {
        return (StellaProperties)super.position(position);
    }
    @Override public StellaProperties getPointer(long i) {
        return new StellaProperties((Pointer)this).offsetAddress(i);
    }

    /**
      Creates an empty properties object with the specified defaults.  The
      new properties object does not claim ownership of the defaults.
    */
    public StellaProperties() { super((Pointer)null); allocate(); }
    private native void allocate();

    /**
      Creates a properties list by copying another one
      <p>
      @param properties The properties to copy
    */
    public StellaProperties(@Const @ByRef StellaProperties properties) { super((Pointer)null); allocate(properties); }
    private native void allocate(@Const @ByRef StellaProperties properties);

    /**
      Destructor
    */
    /**
      Get the value assigned to the specified key.  If the key does
      not exist then the empty string is returned.
      <p>
      @param key  The key of the property to lookup
      @return     The value of the property
    */
    public native @StdString BytePointer get(@Cast("ale::stella::PropertyType") int key);

    /**
      Set the value associated with key to the given value.
      <p>
      @param key      The key of the property to set
      @param value    The value to assign to the property
    */
    public native void set(@Cast("ale::stella::PropertyType") int key, @StdString BytePointer value);
    public native void set(@Cast("ale::stella::PropertyType") int key, @StdString String value);

    /**
      Load properties from the specified input stream
      <p>
      @param in The input stream to use
    */
    public native void load(@Cast("std::istream*") @ByRef Pointer in);

    /**
      Save properties to the specified output stream
      <p>
      @param out The output stream to use
    */
    public native void save(@Cast("std::ostream*") @ByRef Pointer out);

    /**
      Print the attributes of this properties object
    */
    public native void print();

    /**
      Resets all properties to their defaults
    */
    public native void setDefaults();
    /**
      Overloaded assignment operator
      <p>
      @param properties The properties object to set myself equal to
      @return Myself after assignment has taken place
    */
    public native @ByRef @Name("operator =") StellaProperties put(@Const @ByRef StellaProperties properties);
}
