// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.ale;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ale.global.ale.*;


/**
  This class maintains a sorted collection of properties.  The objects
  are maintained in a binary search tree sorted by md5, since this is
  the attribute most likely to be present in each entry in stella.pro
  and least likely to change.  A change in MD5 would mean a change in
  the game rom image (essentially a different game) and this would
  necessitate a new entry in the stella.pro file anyway.
  <p>
  @author  Stephen Anthony
*/
@Name("ale::stella::PropertiesSet") @NoOffset @Properties(inherit = org.bytedeco.ale.presets.ale.class)
public class StellaPropertiesSet extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StellaPropertiesSet(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public StellaPropertiesSet(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public StellaPropertiesSet position(long position) {
        return (StellaPropertiesSet)super.position(position);
    }
    @Override public StellaPropertiesSet getPointer(long i) {
        return new StellaPropertiesSet((Pointer)this).offsetAddress(i);
    }

    /**
      Create an empty properties set object using the md5 as the
      key to the BST.
    */
    public StellaPropertiesSet() { super((Pointer)null); allocate(); }
    private native void allocate();

    /**
      Destructor
    */
    /**
      Get the property from the set with the given MD5.
      <p>
      @param md5         The md5 of the property to get
      @param properties  The property with the given MD5, or the default
                         properties if not found
      @param defaults    Use the built-in defaults, ignoring any external properties
    */
    public native void getMD5(@StdString BytePointer md5, @ByRef StellaProperties properties,
                    @Cast("bool") boolean useDefaults/*=false*/);
    public native void getMD5(@StdString BytePointer md5, @ByRef StellaProperties properties);
    public native void getMD5(@StdString String md5, @ByRef StellaProperties properties,
                    @Cast("bool") boolean useDefaults/*=false*/);
    public native void getMD5(@StdString String md5, @ByRef StellaProperties properties);

    /**
      Insert the properties into the set.  If a duplicate is inserted
      the old properties are overwritten with the new ones.
      <p>
      @param properties  The collection of properties
      @param save        Indicates whether to set the 'save' tag for
                         this property
    */
    public native void insert(@Const @ByRef StellaProperties properties, @Cast("bool") boolean save);

    /**
      Marks the property with the given MD5 as being removed.
      <p>
      @param md5  The md5 of the property to remove
    */
    public native void removeMD5(@StdString BytePointer md5);
    public native void removeMD5(@StdString String md5);

    /**
      Get the number of properties in the collection.
      <p>
      @return  The number of properties in the collection
    */
    public native @Cast("uint32_t") int size();

    /**
      Prints the contents of the PropertiesSet as a flat file.
    */
    public native void print();
}
