// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Store a stack of bitsets efficiently. The top bitset may be
 *  accessed and its bits may be modified, but it may not be resized. */
@Namespace("arrow::internal") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class BitsetStack extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BitsetStack() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BitsetStack(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BitsetStack(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BitsetStack position(long position) {
        return (BitsetStack)super.position(position);
    }


  /** \brief push a bitset onto the stack
   *  @param size number of bits in the next bitset
   *  @param value initial value for bits in the pushed bitset */
  public native void Push(int size, @Cast("bool") boolean value);

  /** \brief number of bits in the bitset at the top of the stack */
  public native int TopSize();

  /** \brief pop a bitset off the stack */
  public native void Pop();

  /** \brief get the value of a bit in the top bitset
   *  @param i index of the bit to access */

  /** \brief get a mutable reference to a bit in the top bitset
   *  @param i index of the bit to access */
  public native @ByVal @Name("operator []") BoolPointer get(int i);
}
