// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief An output stream that writes to a resizable buffer */
@Namespace("arrow::io") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class BufferOutputStream extends OutputStream {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BufferOutputStream(Pointer p) { super(p); }

  public BufferOutputStream(@SharedPtr ResizableBuffer buffer) { super((Pointer)null); allocate(buffer); }
  private native void allocate(@SharedPtr ResizableBuffer buffer);

  /** \brief Create in-memory output stream with indicated capacity using a
   *  memory pool
   *  @param initial_capacity [in] the initial allocated internal capacity of
   *  the OutputStream
   *  @param pool [in,out] a MemoryPool to use for allocations
   *  @return the created stream */
  public static native @ByVal BufferOutputStreamResult Create(
        @Cast("int64_t") long initial_capacity, MemoryPool pool/*=arrow::default_memory_pool()*/);
  public static native @ByVal BufferOutputStreamResult Create(
        @Cast("int64_t") long initial_capacity);

  public static native @Deprecated @ByVal Status Create(@Cast("int64_t") long initial_capacity, MemoryPool pool,
                         @SharedPtr BufferOutputStream out);

  // Implement the OutputStream interface

  /** Close the stream, preserving the buffer (retrieve it with Finish()). */
  public native @ByVal Status Close();
  public native @Cast("bool") boolean closed();
  public native @ByVal LongResult Tell();
  public native @ByVal Status Write(@Const Pointer data, @Cast("int64_t") long nbytes);

  /** \cond FALSE */
  /** \endcond
   <p>
   *  Close the stream and return the buffer */
  public native @ByVal BufferResult Finish();

  public native @Deprecated @ByVal Status Finish(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer result);

  /** \brief Initialize state of OutputStream with newly allocated memory and
   *  set position to 0
   *  @param initial_capacity [in] the starting allocated capacity
   *  @param pool [in,out] the memory pool to use for allocations
   *  @return Status */
  public native @ByVal Status Reset(@Cast("int64_t") long initial_capacity/*=1024*/, MemoryPool pool/*=arrow::default_memory_pool()*/);
  public native @ByVal Status Reset();

  public native @Cast("int64_t") @Name("capacity") long _capacity();
}
