// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class ChunkedArray
 *  \brief A data structure managing a list of primitive Arrow arrays logically
 *  as one large array */
@Namespace("arrow") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class ChunkedArray extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ChunkedArray(Pointer p) { super(p); }

  /** \brief Construct a chunked array from a vector of arrays
   * 
   *  The vector must be non-empty and all its elements must have the same
   *  data type. */
  public ChunkedArray(@Const @ByRef ArrayVector chunks) { super((Pointer)null); allocate(chunks); }
  private native void allocate(@Const @ByRef ArrayVector chunks);

  /** \brief Construct a chunked array from a single Array */
  
  ///
  public ChunkedArray(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array chunk) { super((Pointer)null); allocate(chunk); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array chunk);

  /** \brief Construct a chunked array from a vector of arrays and a data type
   * 
   *  As the data type is passed explicitly, the vector may be empty. */
  public ChunkedArray(@Const @ByRef ArrayVector chunks, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type) { super((Pointer)null); allocate(chunks, type); }
  private native void allocate(@Const @ByRef ArrayVector chunks, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);

  /** @return the total length of the chunked array; computed on construction */
  public native @Cast("int64_t") long length();

  /** @return the total number of nulls among all chunks */
  public native @Cast("int64_t") long null_count();

  public native int num_chunks();

  /** @return chunk a particular chunk from the chunked array */
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array chunk(int i);

  
  ///
  ///
  public native @Const @ByRef ArrayVector chunks();

  /** \brief Construct a zero-copy slice of the chunked array with the
   *  indicated offset and length
   * 
   *  @param offset [in] the position of the first element in the constructed
   *  slice
   *  @param length [in] the length of the slice. If there are not enough
   *  elements in the chunked array, the length will be adjusted accordingly
   * 
   *  @return a new object wrapped in std::shared_ptr<ChunkedArray> */
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::ChunkedArray>"}) ChunkedArray Slice(@Cast("int64_t") long offset, @Cast("int64_t") long length);

  /** \brief Slice from offset until end of the chunked array */
  
  ///
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::ChunkedArray>"}) ChunkedArray Slice(@Cast("int64_t") long offset);

  /** \brief Flatten this chunked array as a vector of chunked arrays, one
   *  for each struct field
   * 
   *  @param pool [in] The pool for buffer allocations, if any
   *  @param out [out] The resulting vector of arrays */
  public native @ByVal Status Flatten(MemoryPool pool, ChunkedArrayVector out);

  /** Construct a zero-copy view of this chunked array with the given
   *  type. Calls Array::View on each constituent chunk. Always succeeds if
   *  there are zero chunks */
  public native @ByVal Status View(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                @SharedPtr ChunkedArray out);

  
  ///
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type();

  /** \brief Determine if two chunked arrays are equal.
   * 
   *  Two chunked arrays can be equal only if they have equal datatypes.
   *  However, they may be equal even if they have different chunkings. */
  public native @Cast("bool") boolean Equals(@Const @ByRef ChunkedArray other);
  /** \brief Determine if two chunked arrays are equal. */

  /** \brief Perform cheap validation checks to determine obvious inconsistencies
   *  within the chunk array's internal data.
   * 
   *  This is O(k*m) where k is the number of array descendents,
   *  and m is the number of chunks.
   * 
   *  @return Status */
  
  ///
  ///
  public native @ByVal Status Validate();

  /** \brief Perform extensive validation checks to determine inconsistencies
   *  within the chunk array's internal data.
   * 
   *  This is O(k*n) where k is the number of array descendents,
   *  and n is the length in elements.
   * 
   *  @return Status */
  public native @ByVal Status ValidateFull();
}
