// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Compression codec */
@Namespace("arrow::util") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class Codec extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Codec(Pointer p) { super(p); }


  /** \brief Return special value to indicate that a codec implementation
   *  should use its default compression level */
  public static native int UseDefaultCompressionLevel();

  /** \brief Return a string name for compression type */
  public static native @StdString String GetCodecAsString(Compression.type t);
  public static native @StdString BytePointer GetCodecAsString(@Cast("arrow::Compression::type") int t);

  /** \brief Create a codec for the given compression algorithm */
  public static native @ByVal CodecResult Create(
        Compression.type codec, int compression_level/*=arrow::util::kUseDefaultCompressionLevel*/);
  public static native @ByVal CodecResult Create(
        Compression.type codec);
  public static native @ByVal CodecResult Create(
        @Cast("arrow::Compression::type") int codec, int compression_level/*=arrow::util::kUseDefaultCompressionLevel*/);
  public static native @ByVal CodecResult Create(
        @Cast("arrow::Compression::type") int codec);

  /** \brief Return true if support for indicated codec has been enabled */
  
  ///
  ///
  public static native @Cast("bool") boolean IsAvailable(Compression.type codec);
  public static native @Cast("bool") boolean IsAvailable(@Cast("arrow::Compression::type") int codec);

  /** \brief One-shot decompression function
   * 
   *  output_buffer_len must be correct and therefore be obtained in advance.
   *  The actual decompressed length is returned.
   * 
   *  \note One-shot decompression is not always compatible with streaming
   *  compression.  Depending on the codec (e.g. LZ4), different formats may
   *  be used. */
  
  ///
  ///
  public native @ByVal LongResult Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") BytePointer input,
                                       @Cast("int64_t") long output_buffer_len,
                                       @Cast("uint8_t*") BytePointer output_buffer);
  public native @ByVal LongResult Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") ByteBuffer input,
                                       @Cast("int64_t") long output_buffer_len,
                                       @Cast("uint8_t*") ByteBuffer output_buffer);
  public native @ByVal LongResult Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") byte[] input,
                                       @Cast("int64_t") long output_buffer_len,
                                       @Cast("uint8_t*") byte[] output_buffer);

  /** \brief One-shot compression function
   * 
   *  output_buffer_len must first have been computed using MaxCompressedLen().
   *  The actual compressed length is returned.
   * 
   *  \note One-shot compression is not always compatible with streaming
   *  decompression.  Depending on the codec (e.g. LZ4), different formats may
   *  be used. */
  public native @ByVal LongResult Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") BytePointer input,
                                     @Cast("int64_t") long output_buffer_len, @Cast("uint8_t*") BytePointer output_buffer);
  public native @ByVal LongResult Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") ByteBuffer input,
                                     @Cast("int64_t") long output_buffer_len, @Cast("uint8_t*") ByteBuffer output_buffer);
  public native @ByVal LongResult Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") byte[] input,
                                     @Cast("int64_t") long output_buffer_len, @Cast("uint8_t*") byte[] output_buffer);

  public native @Cast("int64_t") long MaxCompressedLen(@Cast("int64_t") long input_len, @Cast("const uint8_t*") BytePointer input);
  public native @Cast("int64_t") long MaxCompressedLen(@Cast("int64_t") long input_len, @Cast("const uint8_t*") ByteBuffer input);
  public native @Cast("int64_t") long MaxCompressedLen(@Cast("int64_t") long input_len, @Cast("const uint8_t*") byte[] input);

  /** \brief Create a streaming compressor instance */
  public native @ByVal CompressorResult MakeCompressor();

  /** \brief Create a streaming compressor instance */
  public native @ByVal DecompressorResult MakeDecompressor();

  public native String name();

  // Deprecated APIs

  /** \brief Create a codec for the given compression algorithm */
  public static native @Deprecated @ByVal Status Create(Compression.type codec, @UniquePtr Codec out);
  public static native @Deprecated @ByVal Status Create(@Cast("arrow::Compression::type") int codec, @UniquePtr Codec out);

  /** \brief Create a codec for the given compression algorithm and level */
  public static native @Deprecated @ByVal Status Create(Compression.type codec, int compression_level,
                         @UniquePtr Codec out);
  public static native @Deprecated @ByVal Status Create(@Cast("arrow::Compression::type") int codec, int compression_level,
                         @UniquePtr Codec out);

  /** \brief One-shot decompression function */
  public native @Deprecated @ByVal Status Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") BytePointer input, @Cast("int64_t") long output_buffer_len,
                      @Cast("uint8_t*") BytePointer output_buffer, @Cast("int64_t*") LongPointer output_len);
  public native @Deprecated @ByVal Status Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") ByteBuffer input, @Cast("int64_t") long output_buffer_len,
                      @Cast("uint8_t*") ByteBuffer output_buffer, @Cast("int64_t*") LongBuffer output_len);
  public native @Deprecated @ByVal Status Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") byte[] input, @Cast("int64_t") long output_buffer_len,
                      @Cast("uint8_t*") byte[] output_buffer, @Cast("int64_t*") long[] output_len);

  /** \brief One-shot compression function */
  public native @Deprecated @ByVal Status Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") BytePointer input, @Cast("int64_t") long output_buffer_len,
                    @Cast("uint8_t*") BytePointer output_buffer, @Cast("int64_t*") LongPointer output_len);
  public native @Deprecated @ByVal Status Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") ByteBuffer input, @Cast("int64_t") long output_buffer_len,
                    @Cast("uint8_t*") ByteBuffer output_buffer, @Cast("int64_t*") LongBuffer output_len);
  public native @Deprecated @ByVal Status Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") byte[] input, @Cast("int64_t") long output_buffer_len,
                    @Cast("uint8_t*") byte[] output_buffer, @Cast("int64_t*") long[] output_len);

  /** \brief Create a streaming compressor instance */
  public native @Deprecated @ByVal Status MakeCompressor(@SharedPtr Compressor out);

  /** \brief Create a streaming decompressor instance */
  public native @Deprecated @ByVal Status MakeDecompressor(@SharedPtr Decompressor out);
}
