// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class Datum
 *  \brief Variant type for various Arrow C++ data structures */
@Namespace("arrow::compute") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class Datum extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Datum(Pointer p) { super(p); }

  /** enum arrow::compute::Datum::type */
  public static final int NONE = 0, SCALAR = 1, ARRAY = 2, CHUNKED_ARRAY = 3, RECORD_BATCH = 4, TABLE = 5, COLLECTION = 6;

  

  /** \brief Empty datum, to be populated elsewhere */
  public Datum() { super((Pointer)null); allocate(); }
  private native void allocate();

  public Datum(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar value) { super((Pointer)null); allocate(value); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar value);
  public Datum(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData value) { super((Pointer)null); allocate(value); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData value);

  public Datum(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array value) { super((Pointer)null); allocate(value); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array value);

  public Datum(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ChunkedArray>"}) ChunkedArray value) { super((Pointer)null); allocate(value); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ChunkedArray>"}) ChunkedArray value);
  public Datum(@SharedPtr @Cast({"", "std::shared_ptr<arrow::RecordBatch>"}) RecordBatch value) { super((Pointer)null); allocate(value); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::RecordBatch>"}) RecordBatch value);
  public Datum(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Table>"}) Table value) { super((Pointer)null); allocate(value); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Table>"}) Table value);
  public Datum(@Const @ByRef DatumVector value) { super((Pointer)null); allocate(value); }
  private native void allocate(@Const @ByRef DatumVector value);

  // Cast from subtypes of Array to Datum

  // Convenience constructors
  public Datum(@Cast("bool") boolean value) { super((Pointer)null); allocate(value); }
  private native void allocate(@Cast("bool") boolean value);
  public Datum(byte value) { super((Pointer)null); allocate(value); }
  private native void allocate(byte value);
  public Datum(short value) { super((Pointer)null); allocate(value); }
  private native void allocate(short value);
  public Datum(int value) { super((Pointer)null); allocate(value); }
  private native void allocate(int value);
  public Datum(@Cast("int64_t") long value) { super((Pointer)null); allocate(value); }
  private native void allocate(@Cast("int64_t") long value);
  public Datum(float value) { super((Pointer)null); allocate(value); }
  private native void allocate(float value);
  public Datum(double value) { super((Pointer)null); allocate(value); }
  private native void allocate(double value);

  public Datum(@Const @ByRef Datum other) { super((Pointer)null); allocate(other); }
  @NoException private native void allocate(@Const @ByRef Datum other);

  public native @ByRef @Name("operator =") @NoException Datum put(@Const @ByRef Datum other);

  // Define move constructor and move assignment, for better performance

  public native int kind();

  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData array();

  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array make_array();

  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::ChunkedArray>"}) ChunkedArray chunked_array();

  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::RecordBatch>"}) RecordBatch record_batch();

  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Table>"}) Table table();

  public native @Const @ByVal DatumVector collection();

  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar scalar();

  public native @Cast("bool") boolean is_array();

  public native @Cast("bool") boolean is_arraylike();

  public native @Cast("bool") boolean is_scalar();

  
  ///
  public native @Cast("bool") boolean is_collection();

  /** \brief The value type of the variant, if any
   * 
   *  @return nullptr if no type */
  
  ///
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type();

  /** \brief The value length of the variant, if any
   * 
   *  @return kUnknownLength if no type */
  public native @Cast("int64_t") long length();

  public native @Cast("bool") boolean Equals(@Const @ByRef Datum other);
}
