// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


// ----------------------------------------------------------------------
// DictionaryArray

/** \brief Array type for dictionary-encoded data with a
 *  data-dependent dictionary
 * 
 *  A dictionary array contains an array of non-negative integers (the
 *  "dictionary indices") along with a data type containing a "dictionary"
 *  corresponding to the distinct values represented in the data.
 * 
 *  For example, the array
 * 
 *    ["foo", "bar", "foo", "bar", "foo", "bar"]
 * 
 *  with dictionary ["bar", "foo"], would have dictionary array representation
 * 
 *    indices: [1, 0, 1, 0, 1, 0]
 *    dictionary: ["bar", "foo"]
 * 
 *  The indices in principle may have any integer type (signed or unsigned),
 *  though presently data in IPC exchanges must be signed int32. */
@Namespace("arrow") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class DictionaryArray extends Array {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DictionaryArray(Pointer p) { super(p); }


  public DictionaryArray(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data) { super((Pointer)null); allocate(data); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data);

  
  ///
  ///
  public DictionaryArray(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                    @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array indices,
                    @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary) { super((Pointer)null); allocate(type, indices, dictionary); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                    @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array indices,
                    @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary);

  /** \brief Construct DictionaryArray from dictionary and indices
   *  array and validate
   * 
   *  This function does the validation of the indices and input type. It checks if
   *  all indices are non-negative and smaller than the size of the dictionary
   * 
   *  @param type [in] a dictionary type
   *  @param dictionary [in] the dictionary with same value type as the
   *  type object
   *  @param indices [in] an array of non-negative signed
   *  integers smaller than the size of the dictionary
   *  @param out [out] the resulting DictionaryArray instance */
  
  ///
  ///
  public static native @ByVal Status FromArrays(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                             @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array indices,
                             @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary,
                             @SharedPtr Array out);

  /** \brief Transpose this DictionaryArray
   * 
   *  This method constructs a new dictionary array with the given dictionary type,
   *  transposing indices using the transpose map.
   *  The type and the transpose map are typically computed using
   *  DictionaryUnifier.
   * 
   *  @param pool [in] a pool to allocate the array data from
   *  @param type [in] the new type object
   *  @param dictionary [in] the new dictionary
   *  @param transpose_map [in] transposition array of this array's indices
   *  into the target array's indices
   *  @param out [out] the resulting DictionaryArray instance */
  public native @ByVal Status Transpose(MemoryPool pool, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                     @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary, @Const IntPointer transpose_map,
                     @SharedPtr Array out);
  public native @ByVal Status Transpose(MemoryPool pool, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                     @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary, @Const IntBuffer transpose_map,
                     @SharedPtr Array out);
  public native @ByVal Status Transpose(MemoryPool pool, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                     @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary, @Const int[] transpose_map,
                     @SharedPtr Array out);

  /** \brief Determine whether dictionary arrays may be compared without unification */
  public native @Cast("bool") boolean CanCompareIndices(@Const @ByRef DictionaryArray other);

  /** \brief Return the dictionary for this array, which is stored as
   *  a member of the ArrayData internal structure */
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary();
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array indices();

  public native @Const DictionaryType dict_type();
}
